<?php $__env->startSection('content'); ?>
<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire.css')); ?>">

<?php if(Auth::check()): ?>
<?php $__env->startSection('content'); ?>
<?php if($errors->any()): ?>
    <ul class="alert alert-warning">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
<?php endif; ?>
<!-- *********** Manifestations internationales  -->
<div class="container">
    <form action="<?php echo e(route('admin.manifestation2.update', $demande->id_demande)); ?>" method="POST" enctype="multipart/form-data" lang="ar">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>

            <input type="hidden" name="type_formulaire_id" value="13">

        <!-- step1 -->
        <div class="container">
            <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire2->id_type); ?>">
            <h3><?php echo e($formulaire->type_ar); ?></h3>
        <h4 style="text-align:center;">تحيين الاستمارة</h4>

<?php 
    // helper to get label from $statut collection (robust)
    $getStatLabel = function($all, $id) {
        if (is_null($id) || $id === '') return '—';
        $found = $all->firstWhere('id_statut', $id) ?? $all->firstWhere('id', $id) ?? $all->firstWhere('ID', $id);
        if (!$found) return '—';
        return $found->libelle_ar ?? $found->statut_ar ?? $found->label ?? $found->name ?? $found->statut ?? '—';
    };

    $currentAdminStatus   = old('id_type', $demande->id_type ?? null);
    $currentUniversity    = old('statut_id', $demande->statut_id ?? null);
    $currentCommittee     = old('statut2_id', $demande->statut2_id ?? null);

    // determine the last overall status (keep your original logic but use full label)
    if (!is_null($demande->statut2_id)) {
        $lastStatut = $demande->statut2_id;
        $lastSource = 'اللجنة الوطنية المختلطة';
    } elseif (!is_null($demande->statut_id)) {
        $lastStatut = $demande->statut_id;
        $lastSource = 'الجامعة';
    } else {
        $lastStatut = $demande->id_type;
        $lastSource = 'الإدارة الفرعية';
    }

    $lastLabel = $getStatLabel($statut, $lastStatut);
?>

<div class="card shadow-lg border-0 mb-4 rounded-4">
    <div class="card-header bg-custom-gray text-dark d-flex justify-content-between align-items-center">
        <div>
            <h5 class="mb-0 fw-bold">الوضعية الحالية:</h5>
            <!-- <div class="very-small text-muted mt-1">المصدر: <?php echo e($lastSource); ?></div> -->
        </div>

        
        <?php if((int)$lastStatut === 1): ?>
            <span class="status-badge status-badge--success"><?php echo e($lastLabel); ?></span>
        <?php elseif((int)$lastStatut === 3): ?>
            <span class="status-badge status-badge--danger"><?php echo e($lastLabel); ?></span>
        <?php else: ?>
            <span class="status-badge status-badge--pending"><?php echo e($lastLabel); ?></span>
        <?php endif; ?>
    </div>

    <div class="card-body">
        <p class="text-muted mb-4 text-center fs-6">
            إذا كنت ترغب في تعديل الوضعية الحالية، يرجى الاختيار من القائمة أدناه:
        </p>

        
        <?php
            $currentStatusAdminLabel = $getStatLabel($statut, $currentAdminStatus ?? $demande->id_type);
            $currentMotifAdmin = old('commentaire_motif', $demande->commentaire_motif ?? '');
            $adminValue = (int) old('id_type', $demande->id_type ?? 0);
        ?>

        <div id="section1" class="mb-3">
            <div class="card border-0">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="fw-bold">تغيير الوضعية من قبل الادارة الفرعية</div>
                        <div class="very-small text-muted"><?php echo e($currentStatusAdminLabel); ?></div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="form-group row align-items-center mb-3">
                        <label class="col-sm-6 col-form-label fw-bold">اختر الوضعية</label>
                        <div class="col-sm-4">
                            <select class="form-control" id="id_type" name="id_type" onchange="toggleSteps()">
                                <option value="">اختر...</option>
                                <?php $__currentLoopData = $statut; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $statutId = $s->id_statut ?? $s->id ?? $s->ID;
                                        $statutIdInt = (int) $statutId;
                                        if (in_array($statutIdInt, [2,6], true)) continue; // hide id 2 and 6
                                        $label = $s->libelle_ar ?? $s->statut_ar ?? $s->label ?? $s->name ?? $s->statut ?? '—';
                                        $selected = (string) old('id_type', $demande->id_type ?? '') === (string) $statutId;
                                    ?>
                                    <option value="<?php echo e($statutId); ?>" <?php echo e($selected ? 'selected' : ''); ?>>
                                        <?php echo e($label); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    
                    <div class="mb-3 <?php echo e($adminValue === 3 ? '' : 'd-none'); ?>" id="motif1">
                        <label class="form-label fw-bold text-danger">سبب / تعليق</label>
                        <textarea maxlength="100" name="commentaire_motif" class="form-control border-danger shadow-sm" rows="3" placeholder="الرجاء إدخال سبب أو تعليق"></textarea>
                    </div>

                    
                    <div class="mb-3 <?php echo e(in_array($adminValue, [4,5]) ? '' : 'd-none'); ?>" id="motifDivStatus1">
                        <label class="form-label fw-bold text-warning">سبب / تعليق</label>
                        <textarea maxlength="100" name="commentaire_motif" id="commentaire_status_admin" class="form-control border-warning shadow-sm" rows="3" placeholder="الرجاء إدخال السبب أو التعليق"></textarea>
                    </div>
                </div>
            </div>
        </div>

        
        <?php
            $currentStatusUnivLabel = $getStatLabel($statut, $currentUniversity ?? $demande->statut_id);
            $currentMotifUniv = old('commentaire_motif2', $demande->commentaire_motif2 ?? '');
            $univValue = (int) old('statut_id', $demande->statut_id ?? 0);
        ?>

        <div id="section2" class="mb-3">
            <div class="card border-0">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="fw-bold">تغيير الوضعية من قبل الجامعة</div>
                        <div class="very-small text-muted"><?php echo e($currentStatusUnivLabel); ?></div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="form-group row align-items-center mb-3">
                        <label class="col-sm-6 col-form-label fw-bold">اختر الوضعية</label>
                        <div class="col-sm-4">
                            <select class="form-control" id="statut_id" name="statut_id" onchange="toggleSteps()">
                                <option value="">اختر...</option>
                                <?php $__currentLoopData = $statut; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $statutId = $s->id_statut ?? $s->id ?? $s->ID;
                                        $statutIdInt = (int) $statutId;
                                        if (in_array($statutIdInt, [2,6], true)) continue; // hide id 2 and 6
                                        $label = $s->libelle_ar ?? $s->statut_ar ?? $s->label ?? $s->name ?? $s->statut ?? '—';
                                        $selected = (string) old('statut_id', $demande->statut_id ?? '') === (string) $statutId;
                                    ?>
                                    <option value="<?php echo e($statutId); ?>" <?php echo e($selected ? 'selected' : ''); ?>>
                                        <?php echo e($label); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    
                    <div class="mb-3 <?php echo e($univValue === 3 ? '' : 'd-none'); ?>" id="motif2">
                        <label class="form-label fw-bold text-danger">سبب / تعليق</label>
                        <textarea  maxlength="100" name="commentaire_motif2" class="form-control border-danger shadow-sm" rows="3" placeholder="الرجاء إدخال سبب أو تعليق"><?php echo e($currentMotifUniv); ?></textarea>
                    </div>

                    
                    <div class="mb-3 <?php echo e(in_array($univValue, [4,5]) ? '' : 'd-none'); ?>" id="motifDivStatus2">
                        <label class="form-label fw-bold text-warning">سبب / تعليق</label>
                        <textarea maxlength="100" name="commentaire_motif2" id="commentaire_status_univ" class="form-control border-warning shadow-sm" rows="3" placeholder="الرجاء إدخال السبب أو التعليق"><?php echo e($currentMotifUniv); ?></textarea>
                    </div>
                </div>
            </div>
        </div>

        
        <?php
            $currentStatusCommLabel = $getStatLabel($statut, $currentCommittee ?? $demande->statut2_id);
            $currentMotifComm = old('commentaire_motif3', $demande->commentaire_motif3 ?? '');
            $commValue = (int) old('statut2_id', $demande->statut2_id ?? 0);
        ?>

        <div id="section3" class="mb-3">
            <div class="card border-0">
                <div class="card-header py-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="fw-bold">تغيير الوضعية من قبل اللجنة الوطنية المختلطة</div>
                        <div class="very-small text-muted"><?php echo e($currentStatusCommLabel); ?></div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="form-group row align-items-center mb-3">
                        <label class="col-sm-6 col-form-label fw-bold">اختر الوضعية</label>
                        <div class="col-sm-4">
                            <select class="form-control" id="statut2_id" name="statut2_id" onchange="toggleSteps()">
                                <option value="">اختر...</option>
                                <?php $__currentLoopData = $statut; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $statutId = $s->id_statut ?? $s->id ?? $s->ID;
                                        $statutIdInt = (int) $statutId;
                                        if (in_array($statutIdInt, [2,6], true)) continue; // hide id 2 and 6
                                        $label = $s->libelle_ar ?? $s->statut_ar ?? $s->label ?? $s->name ?? $s->statut ?? '—';
                                        $selected = (string) old('statut2_id', $demande->statut2_id ?? '') === (string) $statutId;
                                    ?>
                                    <option value="<?php echo e($statutId); ?>" <?php echo e($selected ? 'selected' : ''); ?>>
                                        <?php echo e($label); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    
                    <div class="mb-3 <?php echo e($commValue === 3 ? '' : 'd-none'); ?>" id="motif3">
                        <label class="form-label fw-bold text-danger">سبب / تعليق</label>
                        <textarea maxlength="100" name="commentaire_motif3" class="form-control border-danger shadow-sm" rows="3" placeholder="الرجاء إدخال سبب أو تعليق"><?php echo e($currentMotifComm); ?></textarea>
                    </div>

                    
                    <div class="mb-3 <?php echo e(in_array($commValue, [4,5]) ? '' : 'd-none'); ?>" id="motifDivStatus3">
                        <label class="form-label fw-bold text-warning">سبب / تعليق</label>
                        <textarea maxlength="100" name="commentaire_motif3" id="commentaire_status_comm" class="form-control border-warning shadow-sm" rows="3" placeholder="الرجاء إدخال السبب أو التعليق"><?php echo e($currentMotifComm); ?></textarea>
                    </div>

                    <!--div id="fileSection" class="d-none">
                        <div class="form-group row align-items-center mb-3">
                            <label class="col-sm-3 col-form-label fw-bold">ادراج الترخيص</label>
                            <div class="col-sm-7">
                                <input type="file" class="form-control" name="file" value="<?php echo e(old('file', $demande->file ?? '')); ?>">
                            </div>
                        </div>
                    </div-->
					<div id="fileSection" class="d-none">
    <div class="form-group row align-items-center mb-3">
        <label class="col-sm-3 col-form-label fw-bold">ادراج الترخيص</label>
        <div class="col-sm-7">
            <?php
                // دالة مساعدة للتحقق من وجود الملف
                $checkFileExists = function($path) {
                    if (empty($path)) {
                        return false;
                    }
                    
                    // إذا كان المسار مطلقاً (يبدأ بـ /)
                    if (strpos($path, '/') === 0) {
                        return file_exists($path);
                    }
                    
                    // محاولة العثور على المسار المطلق
                    $uploadDir = '/home/preprov/www/mjs/shared_uploads/images';
                    $fullPath = $uploadDir . '/' . basename($path);
                    
                    return file_exists($fullPath) || file_exists($path);
                };
                
                $fileExists = $checkFileExists($demande->file ?? null);
            ?>
            
            <?php if($demande->file && $fileExists): ?>
                <div class="mb-2">
                    <p class="mb-1 text-success">
                        <i class="bx bx-file"></i> الملف الحالي:
                    </p>
                    <?php
                        // Extraire le nom du fichier depuis le chemin
                        $fileName = basename($demande->file);
                    ?>
                    
                    
                    <a href="<?php echo e(route('manifestation.decision.show', $demande->id_demande)); ?>" 
                       target="_blank" 
                       class="btn btn-sm btn-outline-primary">
                        <i class="bx bx-show"></i> عرض الملف: <?php echo e($fileName); ?>

                    </a>
                    
                    
                </div>
            <?php elseif($demande->file): ?>
                
                <div class="mb-2">
                    <p class="mb-1 text-warning">
                        <i class="bx bx-error"></i> مسار الملف موجود ولكن الملف غير موجود على الخادم
                    </p>
                    <small class="text-muted">مسار الملف: <?php echo e($demande->file); ?></small>
                </div>
            <?php else: ?>
                <p class="text-muted mb-2">
                    <i class="bx bx-info-circle"></i> لا يوجد ملف مرفق حالياً
                </p>
            <?php endif; ?>
            
            <input type="file" class="form-control" name="file" id="fileInput">
            <small class="text-muted">يُسمح بصيغ: PDF, JPG, JPEG, PNG (الحجم الأقصى: 4MB)</small>
            <?php $__errorArgs = ['file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <small class="text-danger d-block"><?php echo e($message); ?></small>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
    </div>
</div>
					
					
                </div>
            </div>
        </div>

    </div>
</div>


<div class="card shadow-lg border-0 mb-4 rounded-4">
    <div class="card-header bg-light py-2">
        <h5 class="mb-0 fw-bold">تاريخ تغيّر الوضعية (سجل كامل)</h5>
    </div>

    <div class="card-body p-2" dir="rtl">
        <?php
            // تأكد أن العلاقة موجودة
            $histories = $demande->statutHistories ?? collect();
        ?>

        <?php if($histories->isEmpty()): ?>
            <p class="text-muted mb-0">لا توجد تغييرات سابقة.</p>
        <?php else: ?>
            <div class="compact-timeline">
                <?php $__currentLoopData = $histories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        // From / To labels (full)
                        $fromLabel = optional($hist->fromStatut)->statut_ar
                                     ?? optional($hist->fromStatut)->libelle_ar
                                     ?? $getStatLabel($statut, $hist->from_statut_id ?? null);

                        $toLabel = optional($hist->toStatut)->statut_ar
                                   ?? optional($hist->toStatut)->libelle_ar
                                   ?? $getStatLabel($statut, $hist->to_statut_id ?? null);

                        // Determine a human-friendly "source" if stored - best-effort:
                        // if you stored demande_manifestation_id => we know it's from demande
                        $source = 'سجل حالة';
                        if (!empty($hist->documents_financement_list_id)) {
                            $source = 'قائمة تمويل';
                        } elseif (!empty($hist->documents_formulaire_id)) {
                            $source = 'نموذج وثائق';
                        } elseif (!empty($hist->demande_manifestation_id)) {
                            // optionally try to guess which "slot" changed by comparing values:
                            $source = 'طلب تظاهرة';
                        } elseif (!empty($hist->projet_id)) {
                            $source = 'مشروع مرتبط';
                        }

                        $toId = $hist->to_statut_id ? (int)$hist->to_statut_id : null;
                        $badgeClass = $toId === 1 ? 'badge-success' : ($toId === 3 ? 'badge-danger' : 'badge-muted');

                        $changer = optional($hist->changer)->nom_prenom ?? optional($hist->changer)->email ?? 'نظام';
                    ?>

                    <div class="compact-item">
                        <div class="compact-row d-flex align-items-center justify-content-between w-100">
                            <div class="left-block text-end">
                                <div class="small text-muted compact-date"><?php echo e($hist->created_at?->format('d/m/Y H:i') ?? $hist->created_at); ?></div>
                                <div class="very-small text-muted compact-user">بواسطة: <?php echo e($changer); ?></div>
                                <!-- <div class="very-small text-muted mt-1">المصدر: <?php echo e($source); ?></div> -->
                            </div>

                            <div class="right-block text-right flex-fill">
                                <span class="compact-from small text-muted"><?php echo e($fromLabel); ?></span>
                                <span class="compact-arrow" aria-hidden="true"> &larr; </span>
                                <span class="compact-to small <?php echo e($badgeClass); ?>"><?php echo e($toLabel); ?></span>
                            </div>
                        </div>

                        <?php if(!empty($hist->commentaire)): ?>
                            <details class="compact-comment mt-1">
                                <summary class="very-small text-danger">سبب / تعليق</summary>
                                <div class="very-small text-muted mt-1"><?php echo e($hist->commentaire); ?></div>
                            </details>
                        <?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>
</div>





<script>
function toggleSteps() {
    // read current values
    const idTypeEl  = document.getElementById('id_type');
    const statutEl  = document.getElementById('statut_id');
    const statut2El = document.getElementById('statut2_id');

    const idType  = idTypeEl ? idTypeEl.value : '';
    const statut1 = statutEl ? statutEl.value : '';
    const statut2 = statut2El ? statut2El.value : '';

    // helper: treat empty / null / "0" as empty
    const isEmpty = v => v === null || v === undefined || v === '' || v === '0';

    // hide everything first
    ['motif1','motifDivStatus1','motif2','motifDivStatus2','motif3','motifDivStatus3','section2','section3','fileSection']
        .forEach(id => { const el = document.getElementById(id); if(el) el.classList.add('d-none'); });

    // If none of the three status selects has been chosen yet => only show first section
    if (isEmpty(idType) && isEmpty(statut1) && isEmpty(statut2)) {
        const s1 = document.getElementById('section1');
        if (s1) s1.classList.remove('d-none');
        // ensure others remain hidden (already hidden above)
        return;
    }

    // ---- STEP 1: administration (id_type) ----
    // show section1 always when we reach here (it may be already visible)
    const s1 = document.getElementById('section1');
    if (s1) s1.classList.remove('d-none');

    if (idType === "3") {
        const m = document.getElementById('motif1'); if (m) m.classList.remove('d-none');
        // when reject no next step
        return;
    }

    if (idType === "4" || idType === "5") {
        const m = document.getElementById('motifDivStatus1'); if (m) m.classList.remove('d-none');
        return;
    }

    // Only when admin explicitly accepted (idType === "1") show section2
    if (idType === "1") {
        const s2 = document.getElementById('section2'); if (s2) s2.classList.remove('d-none');
    }

    // ---- STEP 2: university (statut_id) ----
    if (statut1 === "3") {
        const m2 = document.getElementById('motif2'); if (m2) m2.classList.remove('d-none');
        return;
    }
    if (statut1 === "4" || statut1 === "5") {
        const m2w = document.getElementById('motifDivStatus2'); if (m2w) m2w.classList.remove('d-none');
        return;
    }
    // Only when university explicitly accepted (statut1 === "1") show section3
    if (statut1 === "1") {
        const s3 = document.getElementById('section3'); if (s3) s3.classList.remove('d-none');
    }

    // ---- STEP 3: committee (statut2_id) ----
    if (statut2 === "3") {
        const m3 = document.getElementById('motif3'); if (m3) m3.classList.remove('d-none');
        return;
    }
    if (statut2 === "4" || statut2 === "5") {
        const m3w = document.getElementById('motifDivStatus3'); if (m3w) m3w.classList.remove('d-none');
        return;
    }
    // Only when committee explicitly accepted (statut2 === "1") show fileSection
    if (statut2 === "1") {
        const f = document.getElementById('fileSection'); if (f) f.classList.remove('d-none');
    }
}

// run once on load to reflect current selections
document.addEventListener('DOMContentLoaded', function() {
    toggleSteps();

    // also attach change listeners to keep UI reactive if selects are changed dynamically
    ['id_type','statut_id','statut2_id'].forEach(id => {
        const el = document.getElementById(id);
        if (el) el.addEventListener('change', toggleSteps);
    });
});
</script>


            <h3 style="font-size:25px;"><?php echo e($formulaire2->type_ar); ?></h3>
            <br>
            <div class="form-section">
                <div class="form-group row mb-3"  style="padding-top:20px;">
                    <label class="col-sm-2 col-form-label"> اسم الهيكل غير الرياضي </label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" name="org[nom]" placeholder=" اسم الهيكل غير الرياضي  "
                            maxlength="100" value="<?php echo e(old('org.nom', $org->nom ?? '')); ?>">                    
                    </div>
                </div> 

                <div class="form-group row mb-3" >
                    <label class="col-sm-2 col-form-label"> عدد التاشيرة</label>
                    <div class="col-sm-4">
                        <input  type="number" class="form-control" name="org[num_visa]" value="<?php echo e(old('org.num_visa', $org->num_visa ?? '')); ?>" max=9999999999999 >
                    </div>
                    <label class="col-sm-2 col-form-label"> تاريخ التسجيل س.و.م </label>
                    <div class="col-sm-4">
                        <input  type="date" class="form-control" value="<?php echo e(old('org.date_enregistrement', $org->date_enregistrement ?? '')); ?>" name="org[date_enregistrement]">
                    </div>
                </div>
                
                <div class="form-group row mb-3" >
                    <label class="col-sm-2 col-form-label"> المعرف الجبائي </label>
                    <div class="col-sm-4">
                        <input  type="number" class="form-control" value="<?php echo e(old('org.identifiant_fiscal', $org->identifiant_fiscal ?? '')); ?>" name="org[identifiant_fiscal]" placeholder=" المعرف الجبائي  " max=99999999999>
                    </div>
                    <label class="col-sm-2 col-form-label">  رقم الحساب البنكي </label>
                    <div class="col-sm-4">
                        <input  type="text" class="form-control" value="<?php echo e(old('org.num_compte_bancaire', $org->num_compte_bancaire ?? '')); ?>" name="org[num_compte_bancaire]" placeholder=" xxxx_xxxxxxxxxxxxxxxx" maxlength="20">
                    </div>
                </div>

                <div class="form-group row mb-3" >
                    <label class="col-sm-2 col-form-label"> العنوان  </label>
                    <div class="col-sm-10">
                        <input  type="text" class="form-control" value="<?php echo e(old('org.adresse', $org->adresse ?? '')); ?>" name="org[adresse]" placeholder=" العنوان " maxlength="150">
                    </div>
                </div>

                <div class="form-group row mb-3" >
                    <label class="col-sm-2 col-form-label">  رقم الهاتف </label>
                    <div class="col-sm-4">
                        <input  type="text" class="form-control" name="org[tel]" value="<?php echo e(old('org.tel', $org->tel ?? '')); ?>" placeholder="216xxxxxxxx+" maxlength="12">
                    </div>
                    <label class="col-sm-2 col-form-label">  رقم الفاكس </label>
                    <div class="col-sm-4">
                        <input  type="text" class="form-control" name="org[fax]" value="<?php echo e(old('org.fax', $org->fax ?? '')); ?>" placeholder="216xxxxxxxx+" maxlength="12">
                    </div>
                </div>

                <div class="form-group row mb-3" >
                    <label class="col-sm-2 col-form-label">  البريد الالكتروني  </label>
                    <div class="col-sm-4">
                        <input  type="email" class="form-control" name="org[email]" value="<?php echo e(old('org.email', $org->email ?? '')); ?>" placeholder=" xxx@xxx.xxx" maxlength="100">
                    </div>
                </div>
            </div>   
        </div>

        <div class="container">
            <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire3->id_type); ?>">
            <input type="hidden" name="demande_id" value="<?php echo e($demande->id ?? ''); ?>">  

            <h3 style="font-size:25px;">ملف التامين الخاص</h3>
            <br>
            <div class="form-section">
                <div class="form-group row mb-3" style="padding-top:20px;">
                    <label class="col-sm-6 col-form-label">
                        نسخة من ملف التأمين الخاص بالتظاهرة الرياضية
                    </label>
                    <div class="col-sm-12">
                        <?php if($demande->assuranceFile): ?>
                            <p> الملف الحالي :
                                <a href="<?php echo e(route('manifestation.attachment.show', $demande->assuranceFile->id_attach)); ?>"
                                target="_blank">
                                    عرض الملف
                                </a>
                            </p>
                        <?php endif; ?>

                        
                        <input type="file" class="form-control" name="assurance_file" accept=".pdf,.jpg,.jpeg,.png">
                        <?php $__errorArgs = ['assurance_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="text-danger"><?php echo e($message); ?></small>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- step2 -->
         <?php
            $evenement = $demande->evenementSportifs->first(); // On prend le premier événement lié
        ?>

        <div class="container">
            <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire3->id_type); ?>">

            <h3 style="font-size:25px;"><?php echo e($formulaire3->type_ar); ?></h3>
            <br>

            <div class="form-section">
                <div class="form-group row mb-3" style="padding-top:20px;">
                    <label class="col-sm-2 col-form-label"> اسم التظاهرة </label>
                    <div class="col-sm-10">
                        <input  type="text" class="form-control" value="<?php echo e(old('nom_even', $evenement->nom_even ?? '')); ?>" name="nom_even" placeholder=" اسم التظاهرة " maxlength="100" value="<?php echo e(old('nom_even')); ?>">
                    </div>
                </div>
                <div class="form-group row mb-3">
                    <label class="col-sm-12 col-form-label"> الهدف من تنظيم التظاهرة و آثارها الرياضية و الأبعاد الاقتصادية والاجتماعية </label>
                    <div class="col-sm-12">
                        <textarea name="objectifs" class="form-control" rows="3"><?php echo e(old('objectifs', $evenement->objectifs ?? '')); ?></textarea>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-12 col-form-label"> محتوى التظاهرة و الاختصاصات الرياضية المستهدفة </label>
                    <div class="col-sm-12">
                        <textarea name="contenus" class="form-control" rows="3"><?php echo e(old('contenus', $evenement->contenus ?? '')); ?></textarea>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label"> تاريخ تنظيم التظاهرة </label>
                    <div class="col-sm-4">
                        <input  type="date" class="form-control" name="date" value="<?php echo e(old('date', $evenement->date ?? '')); ?>">
                        
                    </div>
                    <label class="col-sm-2 col-form-label"> توقيت تنظيم التظاهرة </label>
                    <div class="col-sm-4">
                        <input type="time" class="form-control" name="heure"
                            value="<?php echo e(old('heure', isset($evenement->heure) ? \Carbon\Carbon::parse($evenement->heure)->format('H:i') : '')); ?>">
                    </div>

                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label"> الولاية </label>
                    <div class="col-sm-4">
                        <select  class="form-control" name="gouvernorat_id" id="gouvernorat_id">
                            <option value="" disabled selected>اختر...</option>
                            <?php $__currentLoopData = $gouvernorats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gouv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($gouv->id_gouver); ?>" 
                                    <?php echo e((old('gouvernorat_id', $evenement->gouvernorat_id ?? '') == $gouv->id_gouver) ? 'selected' : ''); ?>>
                                    <?php echo e($gouv->nom_ar); ?>

                                </option>                            
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <label class="col-sm-2 col-form-label"> البلدية </label>
                    <div class="col-sm-4">
                        <select class="form-control" name="delegation_id" id="delegation_id"
                            <?php echo e(old('delegation_id', $evenement->delegation_id ?? '') ? '' : 'disabled'); ?>>
                            <option value="" disabled <?php echo e(!old('delegation_id', $evenement->delegation_id ?? '') ? 'selected' : ''); ?>>اختر...</option>

                            <?php $__currentLoopData = $delegations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deleg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($deleg->id_delegation); ?>"
                                    <?php echo e(old('delegation_id', $evenement->delegation_id ?? '') == $deleg->id_delegation ? 'selected' : ''); ?>>
                                    <?php echo e($deleg->nom_ar); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-12 col-form-label"> المنشئات الرياضية التي ستستغل </label>
                    <div class="col-sm-12">
                        <textarea name="instalation_sportives" class="form-control" rows="2"><?php echo e(old('instalation_sportives', $evenement->instalation_sportives ?? '')); ?></textarea>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label"> الجامعة الرياضية مرجع الاختصاص </label>
                    <div class="col-sm-4">
                        <input type="text" class="form-control" name="reference" maxlength="100" value="<?php echo e(old('reference', $evenement->reference ?? '')); ?>">
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label"> المداخيل التقديرية الجملية </label>
                    <div class="col-sm-4">
                        <input type="number" step="0.001" class="form-control" name="estimation_evenement" value="<?php echo e(old('estimation_evenement', $evenement->estimation_evenement ?? '')); ?>">
                    </div>
                    <label class="col-sm-2 col-form-label"> المصاريف التقديرية الجملية </label>
                    <div class="col-sm-4">
                        <input type="number" step="0.001" class="form-control" name="cout_total_evenement" value="<?php echo e(old('cout_total_evenement', $evenement->cout_total_evenement ?? '')); ?>">
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label"> الفارق التقديري </label>
                    <div class="col-sm-4">
                        <input type="number" step="0.001" class="form-control" name="difference_estimee" value="<?php echo e(old('difference_estimee', $evenement->difference_estimee ?? '')); ?>">
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label"> بيان الجوائز </label>
                    <div class="col-sm-10">
                        <textarea name="recompense" class="form-control" rows="2"><?php echo e(old('recompense', $evenement->recompense ?? '')); ?></textarea>
                    </div>
                </div>
                <input type="hidden" name="user_id" value="<?php echo e(Auth::user()->id); ?>">
            </div>
        </div>

        <!-- step3 -->
        <div class="container">
            <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire4->id_type); ?>">
            <h3 style="font-size:25px;"><?php echo e($formulaire4->type_ar); ?></h3>
            <br>

            <div class="form-section">
                <div class="form-group row">
                    <label class="col-sm-6 col-form-label">قائمة عناصر فريق التنظيم</label>
                    <table id="membres-table" class="custom-table">
                        <thead>
                            <tr>
                                <th>الاسم واللقب</th>
                                <th>الصفة</th>
                                <th>الجنسية</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody id="membres-body">
                            <?php
                                $membres = $evenement && $evenement->membres
                                    ? $evenement->membres->where('type_membre_id', 1)
                                    : collect();
                            ?>

                            <?php if($membres->count()): ?>
                                <?php $__currentLoopData = $membres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $membre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td data-label="الاسم واللقب">
                                            <input type="text" name="membres[<?php echo e($index); ?>][nom_prenom]" 
                                                value="<?php echo e(old('membres.'.$index.'.nom_prenom', $membre->nom_prenom)); ?>" 
                                                class="form-control" placeholder="الاسم واللقب">
                                        </td>
                                        <td data-label="الصفة">
                                            <input type="text" name="membres[<?php echo e($index); ?>][role]" 
                                                value="<?php echo e(old('membres.'.$index.'.role', $membre->role)); ?>" 
                                                class="form-control" placeholder="الصفة">
                                        </td>
                                        <td data-label="الجنسية">
                                            <input type="text" name="membres[<?php echo e($index); ?>][nationalite]" 
                                                value="<?php echo e(old('membres.'.$index.'.nationalite', $membre->nationalite)); ?>" 
                                                class="form-control" placeholder="الجنسية">
                                        </td>
                                        <td class="action-buttons">
                                            <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <tr>
                                    <td data-label="الاسم واللقب">
                                        <input type="text" name="membres[0][nom_prenom]" class="form-control" placeholder="الاسم واللقب">
                                    </td>
                                    <td data-label="الصفة">
                                        <input type="text" name="membres[0][role]" readonly value="رئيس لجنة التنظيم" class="form-control bg-white" placeholder="الصفة">
                                    </td>
                                    <td data-label="الجنسية">
                                        <input type="text" name="membres[0][nationalite]" class="form-control" placeholder="الجنسية">
                                    </td>
                                    <td class="action-buttons">
                                        <div style="width: 40px; height: 31px;"></div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                    <button type="button" class="btn btn-success mt-2" onclick="addOrganisateurRow()">
                        إضافة صف
                    </button>
                </div>

                <div class="form-group row mt-4">
                    <label class="col-sm-6 col-form-label">الشخصيات الرسمية المدعوة</label>
                    <table id="invites-table" class="custom-table">
                        <thead>
                            <tr>
                                <th>الاسم واللقب</th>
                                <th>الصفة</th>
                                <th>الجنسية</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody id="invites-body">
                             <?php
                                $invites = $evenement && $evenement->membres
                                    ? $evenement->membres->where('type_membre_id', 2)
                                    : collect();
                            ?>

                            <?php if($invites->count()): ?>
                                <?php $__currentLoopData = $invites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $invite): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><input type="text" name="invites[<?php echo e($index); ?>][nom_prenom]" value="<?php echo e(old('invites.'.$index.'.nom_prenom', $invite->nom_prenom)); ?>" class="form-control" placeholder="الاسم واللقب"></td>
                                        <td><input type="text" name="invites[<?php echo e($index); ?>][role]" value="<?php echo e(old('invites.'.$index.'.role', $invite->role)); ?>" class="form-control" placeholder="الصفة"></td>
                                        <td><input type="text" name="invites[<?php echo e($index); ?>][nationalite]" value="<?php echo e(old('invites.'.$index.'.nationalite', $invite->nationalite)); ?>" class="form-control" placeholder="الجنسية"></td>
                                        <td><button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <tr>
                                    <td><input type="text" name="invites[0][nom_prenom]" class="form-control" placeholder="الاسم واللقب"></td>
                                    <td><input type="text" name="invites[0][role]" class="form-control" placeholder="الصفة"></td>
                                    <td><input type="text" name="invites[0][nationalite]" class="form-control" placeholder="الجنسية"></td>
                                    <td><button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button></td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                    <button type="button" class="btn btn-success mt-2" onclick="addInviteRow()">إضافة صف</button>
                </div>
            </div>
        </div>

        <!-- step4 -->
        <div class="container">
            <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire5->id_type); ?>">
            <h3 style="font-size:25px;"><?php echo e($formulaire5->type_ar); ?></h3>
            <br>

           <div class="form-section">
                <div class="form-group row">
                    <label class="col-sm-12 col-form-label"> الجمعيات المشاركة </label>
                    <div class="table-responsive">
                        <table id="assoc-table" class="custom-table table table-bordered text-center align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th rowspan="2" style="width:4%">ع/ر</th>
                                    <th rowspan="2" style="width:20%">الجمعيات المشاركة</th>
                                    <th colspan="2" style="width:20%">عدد الرياضيين</th>
                                    <th rowspan="2" style="width:10%">المرافقون</th>
                                    <th rowspan="2" style="width:10%">المجموع</th>
                                    <th rowspan="2" style="width:8%">إجراء</th>
                                </tr>
                                <tr>
                                    <th style="width:10%">ذكور</th>
                                    <th style="width:10%">إناث</th>
                                </tr>
                            </thead>

                            <?php
                                $assocParticipantes = collect();
                                if ($demande->evenementSportifs && $demande->evenementSportifs->first()) {
                                    $assocParticipantes = $demande->evenementSportifs->first()->assocParticipantes ?? collect();
                                }
                            ?>

                            <tbody id="assoc_participantes-body">
                                <?php if($assocParticipantes->count()): ?>
                                    <?php $__currentLoopData = $assocParticipantes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $assoc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="row-number"><?php echo e($index + 1); ?></td>
                                            <td>
                                                <input type="text" name="assoc_participantes[<?php echo e($index); ?>][nom]"
                                                    value="<?php echo e(old('assoc_participantes.'.$index.'.nom', $assoc->nom)); ?>"
                                                    class="form-control" placeholder="اسم الجمعية">
                                            </td>
                                            <td>
                                                <input type="number" name="assoc_participantes[<?php echo e($index); ?>][num_athlete_h]"
                                                    value="<?php echo e(old('assoc_participantes.'.$index.'.num_athlete_h', $assoc->num_athlete_h)); ?>"
                                                    class="form-control text-center" placeholder="ذكور" min="0">
                                            </td>
                                            <td>
                                                <input type="number" name="assoc_participantes[<?php echo e($index); ?>][num_athlete_f]"
                                                    value="<?php echo e(old('assoc_participantes.'.$index.'.num_athlete_f', $assoc->num_athlete_f)); ?>"
                                                    class="form-control text-center" placeholder="إناث" min="0">
                                            </td>
                                            <td>
                                                <input type="number" name="assoc_participantes[<?php echo e($index); ?>][accompagnants]"
                                                    value="<?php echo e(old('assoc_participantes.'.$index.'.accompagnants', $assoc->accompagnants)); ?>"
                                                    class="form-control text-center" placeholder="عدد" min="0">
                                            </td>
                                            <td>
                                                <input type="number" name="assoc_participantes[<?php echo e($index); ?>][total]"
                                                    value="<?php echo e(old('assoc_participantes.'.$index.'.total', $assoc->total)); ?>"
                                                    class="form-control text-center" readonly>
                                            </td>
                                            <td>
                                                <button type="button" class="btn btn-danger btn-sm" onclick="removeAssocRow(this)">حذف</button>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    
                                    <tr>
                                        <td class="row-number">1</td>
                                        <td><input type="text" name="assoc_participantes[0][nom]" class="form-control" placeholder="اسم الجمعية"></td>
                                        <td><input type="number" name="assoc_participantes[0][num_athlete_h]" class="form-control text-center" placeholder="ذكور" min="0"></td>
                                        <td><input type="number" name="assoc_participantes[0][num_athlete_f]" class="form-control text-center" placeholder="إناث" min="0"></td>
                                        <td><input type="number" name="assoc_participantes[0][accompagnants]" class="form-control text-center" placeholder="عدد" min="0"></td>
                                        <td><input type="number" name="assoc_participantes[0][total]" class="form-control text-center" readonly placeholder="0"></td>
                                        <td><button type="button" class="btn btn-danger btn-sm" onclick="removeAssocRow(this)">حذف</button></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>

                            <tfoot>
                                <tr class="fw-bold">
                                    <td colspan="2" class="text-center">المجموع العام</td>

                                    <td>
                                        <input type="number" id="total-males" class="form-control text-center" readonly value="0">
                                    </td>
                                    <td>
                                        <input type="number" id="total-females" class="form-control text-center" readonly value="0">
                                    </td>

                                    <td>
                                        <input type="number" id="total-accompagnants" class="form-control text-center" readonly value="0">
                                    </td>

                                    <td>
                                        <input type="number" id="total-general" class="form-control text-center fw-bold" readonly value="0">
                                    </td>

                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>

                    <button type="button" class="btn btn-success mt-2" onclick="addAssocRow()">إضافة صف</button>
                </div>
            </div>
        </div>
  


        <!-- step5 -->
        <div class="container">
            <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire6->id_type); ?>">
            <h3 style="font-size:25px;"><?php echo e($formulaire6->type_ar); ?></h3>
            <br>

            <div class="form-section">
                <div class="form-group row"> 
                    <label class="col-sm-12 col-form-label"> الرياضيين المشاركين بصفة فردية  </label>
                    <div class="table-responsive">
                        <table id="athletes-table" class="custom-table table table-bordered text-center align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th rowspan="2" style="width:4%">ع/ر</th>
                                    <th rowspan="2" style="width:25%">اسم و لقب الرياضي المشارك</th>
                                    <th colspan="2" style="width:20%">عدد الرياضيين</th>
                                    <th rowspan="2" style="width:10%">المرافقون</th>
                                    <th rowspan="2" style="width:10%">المجموع</th>
                                    <th rowspan="2" style="width:8%">إجراء</th>
                                </tr>
                                <tr>
                                    <th style="width:10%">ذكور</th>
                                    <th style="width:10%">إناث</th>
                                </tr>
                            </thead>

                            <tbody id="athletes-body">
                                <?php $athleteIndex = 0; ?>
                                <?php $__currentLoopData = $demande->evenementSportifs->first()->athletesIndividuels ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $athlete): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="row-number"><?php echo e($loop->iteration); ?></td>
                                    <td>
                                        <input type="text" name="athletes[<?php echo e($athleteIndex); ?>][nom_prenom_sportif]" class="form-control" 
                                            value="<?php echo e($athlete->nom_prenom_sportif); ?>" placeholder="الاسم و اللقب">
                                    </td>
                                    <td>
                                        <input type="number" name="athletes[<?php echo e($athleteIndex); ?>][num_athlete_h]" class="form-control text-center" 
                                            value="<?php echo e($athlete->num_athlete_h); ?>" placeholder="ذكور" min="0">
                                    </td>
                                    <td>
                                        <input type="number" name="athletes[<?php echo e($athleteIndex); ?>][num_athlete_f]" class="form-control text-center" 
                                            value="<?php echo e($athlete->num_athlete_f); ?>" placeholder="إناث" min="0">
                                    </td>
                                    <td>
                                        <input type="number" name="athletes[<?php echo e($athleteIndex); ?>][accompagnants]" class="form-control text-center" 
                                            value="<?php echo e($athlete->accompagnants); ?>" placeholder="عدد" min="0">
                                    </td>
                                    <td>
                                        <input type="number" name="athletes[<?php echo e($athleteIndex); ?>][total]" class="form-control text-center" 
                                            value="<?php echo e($athlete->total); ?>" readonly placeholder="0">
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-danger btn-sm" onclick="removeAthleteRow(this)">حذف</button>
                                    </td>
                                </tr>
                                <?php $athleteIndex++; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>

                            <tfoot>
                                <tr class="fw-bold">
                                    <td colspan="2" class="text-center">المجموع العام</td>
                                    <td><input type="number" id="total2-males" class="form-control text-center" readonly value="0"></td>
                                    <td><input type="number" id="total2-females" class="form-control text-center" readonly value="0"></td>
                                    <td><input type="number" id="total2-accompagnants" class="form-control text-center" readonly value="0"></td>
                                    <td><input type="number" id="total2-general" class="form-control text-center fw-bold" readonly value="0"></td>
                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    <button type="button" class="btn btn-success mt-2" onclick="addAthleteRow()">إضافة صف</button>
                </div>
            </div>
        </div>

        <!-- step6 -->
        <div class="container">
            <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire7->id_type); ?>">
            <h3 style="font-size:25px;"><?php echo e($formulaire7->type_ar); ?></h3>
            <br>

            <div class="form-section">
                <div class="form-group row">
                    <label class="col-sm-12 col-form-label"> الرياضيين المشاركين </label>
                    <div class="table-responsive">
                        <table id="sportifs-table" class="custom-table table table-bordered text-center align-middle">
                            <thead>
                                <tr>
                                    <th>اسم و لقب الرياضي المشارك</th>
                                    <th>الصنف العمري</th>
                                    <th>تاريخ الولادة</th>
                                    <th>رقم بطاقة التعريف</th>
                                    <th>إجراء</th>
                                </tr>
                            </thead>
                            <tbody id="sportifs-body">
                                <?php $sportifIndex = 0; ?>
                                <?php $__currentLoopData = $demande->evenementSportifs->first()->sportifs ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sportif): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td data-label="الاسم واللقب">
                                        <input type="text" name="sportifs[<?php echo e($sportifIndex); ?>][nom_prenom]" class="form-control" 
                                            value="<?php echo e($sportif->nom_prenom); ?>" placeholder="الاسم واللقب">
                                    </td>
                                    <td data-label="الصنف العمري">
                                        <input type="text" name="sportifs[<?php echo e($sportifIndex); ?>][tranch_age]" class="form-control" 
                                            value="<?php echo e($sportif->tranch_age); ?>" placeholder="الصنف العمري">
                                    </td>
                                    <td data-label="تاريخ الولادة">
                                        <input type="date" name="sportifs[<?php echo e($sportifIndex); ?>][date_naissance]" class="form-control" 
                                            value="<?php echo e($sportif->date_naissance); ?>">
                                    </td>
                                    <td data-label="رقم بطاقة التعريف">
                                        <input type="text" name="sportifs[<?php echo e($sportifIndex); ?>][num_cin]" class="form-control" 
                                            value="<?php echo e($sportif->num_cin); ?>" placeholder="رقم البطاقة">
                                    </td>
                                    <td class="action-buttons">
                                        <button type="button" class="btn btn-danger btn-sm" onclick="removeSportifRow(this)">حذف</button>
                                    </td>
                                </tr>
                                <?php $sportifIndex++; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <button type="button" class="btn btn-success mt-2" onclick="addSportifRow()">
                            إضافة صف
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="container">
            <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire8->id_type); ?>">
            <input type="hidden" name="demande_id" value="<?php echo e($demande->id_demande ?? ''); ?>">  

            <h3 style="font-size:25px;"><?php echo e($formulaire8->type_ar); ?></h3>
            <br>

            <div class="form-section">
                <div class="form-group row">
                    <label class="col-sm-6 col-form-label">قائمة الرياضيين و المرافقين </label>
                    <table id="touristes-table" class="custom-table table table-bordered text-center align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>الاسم واللقب</th>
                                <th>البلد الأصلي</th>
                                <th>رقم جواز السفر</th>
                                <th>تاريخ الوصول</th>
                                <th>مكان الإقامة</th>
                                <th>تاريخ المغادرة</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody id="touristes-body">
                            <?php $__currentLoopData = $evenement->etrangeres->where('type_etranger_id', 1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $touriste): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><input type="text" name="touristes[<?php echo e($index); ?>][nom_prenom]" class="form-control" value="<?php echo e($touriste->nom_prenom); ?>"></td>
                                <td><input type="text" name="touristes[<?php echo e($index); ?>][pays_origine]" class="form-control" value="<?php echo e($touriste->pays_origine); ?>"></td>
                                <td><input type="text" name="touristes[<?php echo e($index); ?>][num_passport]" class="form-control" value="<?php echo e($touriste->num_passport); ?>"></td>
                                <td><input type="date" name="touristes[<?php echo e($index); ?>][date_arrive]" class="form-control" value="<?php echo e($touriste->date_arrive); ?>"></td>
                                <td><input type="text" name="touristes[<?php echo e($index); ?>][lieu_residence]" class="form-control" value="<?php echo e($touriste->lieu_residence); ?>"></td>
                                <td><input type="date" name="touristes[<?php echo e($index); ?>][date_depart]" class="form-control" value="<?php echo e($touriste->date_depart); ?>"></td>
                                <td>
                                    <button type="button" class="btn btn-danger btn-sm" onclick="removeTouristeRow(this)">
                                        <i class="la la-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                    <button type="button" class="btn btn-success mt-2" onclick="addTouristeRow()">
                        <i class="la la-plus"></i> إضافة صف
                    </button>
                </div>
            </div>

            <div class="form-section">
                <div class="form-group row">
                    <label class="col-sm-6 col-form-label">قائمة الحكام و الرسميين </label>
                    <table id="touriste2s-table" class="custom-table table table-bordered text-center align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>الاسم واللقب</th>
                                <th>البلد الأصلي</th>
                                <th>رقم جواز السفر</th>
                                <th>تاريخ الوصول</th>
                                <th>مكان الإقامة</th>
                                <th>تاريخ المغادرة</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody id="touriste2s-body">
                            <?php $__currentLoopData = $evenement->etrangeres->where('type_etranger_id', 2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $touriste2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <input type="hidden" name="touriste2s[<?php echo e($index); ?>][id]" value="<?php echo e($touriste2->id_etrangere); ?>">
                                        <input type="text" name="touriste2s[<?php echo e($index); ?>][nom_prenom]" class="form-control" value="<?php echo e($touriste2->nom_prenom); ?>">
                                    </td>
                                    <td><input type="text" name="touriste2s[<?php echo e($index); ?>][pays_origine]" class="form-control" value="<?php echo e($touriste2->pays_origine); ?>"></td>
                                    <td><input type="text" name="touriste2s[<?php echo e($index); ?>][num_passport]" class="form-control" value="<?php echo e($touriste2->num_passport); ?>"></td>
                                    <td><input type="date" name="touriste2s[<?php echo e($index); ?>][date_arrive]" class="form-control" value="<?php echo e($touriste2->date_arrive); ?>"></td>
                                    <td><input type="text" name="touriste2s[<?php echo e($index); ?>][lieu_residence]" class="form-control" value="<?php echo e($touriste2->lieu_residence); ?>"></td>
                                    <td><input type="date" name="touriste2s[<?php echo e($index); ?>][date_depart]" class="form-control" value="<?php echo e($touriste2->date_depart); ?>"></td>
                                    <td class="text-center">
                                        <button type="button" class="btn btn-danger btn-sm" onclick="removeTouriste2Row(this)">
                                            <i class="la la-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                    <button type="button" class="btn btn-success mt-2" onclick="addTouriste2Row()">
                        <i class="la la-plus"></i> إضافة صف
                    </button>
                </div>
            </div>
        </div>

        <div class="container">
            <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire9->id_type); ?>">
            <input type="hidden" name="demande_id" value="">  
            <h3 style="font-size:25px;"><?php echo e($formulaire9->type_ar); ?></h3>
            <br>
            <div class="form-section">
                <div class="form-group row">
                    <label class="col-sm-6 col-form-label">قائمة الشخصيات الرسمية الأجنبية</label>
                    <table id="touriste3s-table" class="custom-table table table-bordered text-center align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>الاسم واللقب</th>
                                <th>البلد الأصلي</th>
                                <th>رقم جواز السفر</th>
                                <th>تاريخ الوصول</th>
                                <th>مكان الإقامة</th>
                                <th>تاريخ المغادرة</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody id="touriste3s-body">
                            <?php if(isset($evenement) && $evenement->etrangeres): ?>
                                <?php $__currentLoopData = $evenement->etrangeres->where('type_etranger_id', 3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $touriste3): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><input type="text" name="touriste3s[<?php echo e($index); ?>][nom_prenom]" class="form-control" value="<?php echo e($touriste3->nom_prenom); ?>"></td>
                                        <td><input type="text" name="touriste3s[<?php echo e($index); ?>][pays_origine]" class="form-control" value="<?php echo e($touriste3->pays_origine); ?>"></td>
                                        <td><input type="text" name="touriste3s[<?php echo e($index); ?>][num_passport]" class="form-control" value="<?php echo e($touriste3->num_passport); ?>"></td>
                                        <td><input type="date" name="touriste3s[<?php echo e($index); ?>][date_arrive]" class="form-control" value="<?php echo e($touriste3->date_arrive); ?>"></td>
                                        <td><input type="text" name="touriste3s[<?php echo e($index); ?>][lieu_residence]" class="form-control" value="<?php echo e($touriste3->lieu_residence); ?>"></td>
                                        <td><input type="date" name="touriste3s[<?php echo e($index); ?>][date_depart]" class="form-control" value="<?php echo e($touriste3->date_depart); ?>"></td>
                                        <td class="text-center">
                                            <button type="button" class="btn btn-danger btn-sm" onclick="removeTouriste3Row(this)">
                                                <i class="la la-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <tr>
                                    <td><input type="text" name="touriste3s[0][nom_prenom]" class="form-control" placeholder="الاسم واللقب"></td>
                                    <td><input type="text" name="touriste3s[0][pays_origine]" class="form-control" placeholder="البلد الأصلي"></td>
                                    <td><input type="text" name="touriste3s[0][num_passport]" class="form-control" placeholder="رقم جواز السفر"></td>
                                    <td><input type="date" name="touriste3s[0][date_arrive]" class="form-control"></td>
                                    <td><input type="text" name="touriste3s[0][lieu_residence]" class="form-control" placeholder="مكان الإقامة"></td>
                                    <td><input type="date" name="touriste3s[0][date_depart]" class="form-control"></td>
                                    <td class="text-center">
                                        <button type="button" class="btn btn-danger btn-sm" onclick="removeTouriste3Row(this)">
                                            <i class="la la-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                    <button type="button" class="btn btn-success mt-2" onclick="addTouriste3Row()">
                        <i class="la la-plus"></i> إضافة صف
                    </button>
                </div>
            </div>
        </div>

        <div class="container">
            <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire3->id_type); ?>">
            <input type="hidden" name="demande_id" value="<?php echo e($demande->id ?? ''); ?>">  

            <h3 style="font-size:25px;">موافقة مبدئية</h3>
            <br>
            <div class="form-section">
                <div class="form-group row mb-3" style="padding-top:20px;">
                    <label class="col-sm-10 col-form-label">
                        موافقة مبدئية كتابية لاستغلال مكان إقامة التظاهرة الرياضية من المصالح المختصة
                    </label>
                    <div class="col-sm-12">
                        <?php if($demande->accordFile): ?>
                            <p> الملف الحالي :

                                <a href="<?php echo e(route('manifestation.attachment.show', $demande->accordFile->id_attach)); ?>"
                                target="_blank">
                                    عرض الملف
                                </a>
                            </p>
                        <?php endif; ?>
                        <input type="file" class="form-control" name="accord_file" accept=".pdf,.jpg,.jpeg,.png">
                        <?php $__errorArgs = ['accord_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="text-danger"><?php echo e($message); ?></small>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>
        </div>


        <div class="container">
            <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire3->id_type); ?>">
            <input type="hidden" name="demande_id" value="<?php echo e($demande->id ?? ''); ?>">  

            <h3 style="font-size:25px;">الملف الفني</h3>
            <br>
            <div class="form-section">
                <div class="form-group row mb-3" style="padding-top:20px;">
                    <label class="col-sm-6 col-form-label">
                        الملف الفني للتظاهرة 
                    </label>
                    <div class="col-sm-12">
                        <?php if($demande->techniqueFile): ?>
                            <p> الملف الحالي :
                               

                                 <a href="<?php echo e(route('manifestation.attachment.show', $demande->techniqueFile->id_attach)); ?>"
                                target="_blank">
                                    عرض الملف
                                </a>
                            </p>
                        <?php endif; ?>
                                        <input type="file" class="form-control" name="technique_file" accept=".pdf,.jpg,.jpeg,.png">
                        <?php $__errorArgs = ['technique_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="text-danger"><?php echo e($message); ?></small>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="container">
            <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire3->id_type); ?>">
            <input type="hidden" name="demande_id" value="<?php echo e($demande->id ?? ''); ?>">  

            <h3 style="font-size:25px;">مطلب في إقامة تظاهرة رياضية وطنية بالبلاد التونسية</h3>
            <br>
            <div class="form-section">
                <div class="form-group row mb-3" style="padding-top:20px;">
                    <label class="col-sm-6 col-form-label">
                       المطلب 
                    </label>
                    <div class="col-sm-12">
                        <?php if($demande->demandeFile): ?>
                            <p> الملف الحالي :
                                <a href="<?php echo e(route('manifestation.attachment.show', $demande->demandeFile->id_attach)); ?>"
                                target="_blank">
                                    عرض الملف
                                </a>
                            </p>
                        <?php endif; ?>
                                        <input type="file" class="form-control" name="demandeFile" accept=".pdf,.jpg,.jpeg,.png">
                        <?php $__errorArgs = ['technique_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="text-danger"><?php echo e($message); ?></small>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>
        </div>

      <div class="form-group text-center mt-5">
            <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
                <button type="submit" class="btn btn-success d-flex align-items-center justify-content-center gap-1 flex-fill">
                <i class="bx bx-save"></i> حفظ
                </button>
                <a href="<?php echo e(route('admin.manifestation2.index')); ?>" class="btn btn-primary d-flex align-items-center justify-content-center gap-1 flex-fill">
                    <i class="bx bx-arrow-back" style="margin-right:5px;"></i> رجوع
                </a>
            </div>
        </div>
		<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    </form>
</div>


<script>
    let orgIndex = <?php echo e($membres->count() ?: 1); ?>;
    function addOrganisateurRow() {
        let tableBody = document.getElementById('membres-body');
        let newRow = `
            <tr>
                <td data-label="الاسم واللقب">
                    <input type="text" name="membres[${orgIndex}][nom_prenom]" class="form-control" placeholder="الاسم واللقب">
                </td>
                <td data-label="الصفة">
                    <input type="text" name="membres[${orgIndex}][role]" class="form-control" placeholder="الصفة">
                </td>
                <td data-label="الجنسية">
                    <input type="text" name="membres[${orgIndex}][nationalite]" class="form-control" placeholder="الجنسية">
                </td>
                <td class="action-buttons">
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button>
                </td>
            </tr>`;
        tableBody.insertAdjacentHTML('beforeend', newRow);
        orgIndex++;
    }

    let inviteIndex = <?php echo e($invites->count() ?: 1); ?>;
    function addInviteRow() {
        let tableBody = document.getElementById('invites-body');
        let newRow = `
            <tr>
                <td data-label="الاسم واللقب">
                    <input type="text" name="invites[${inviteIndex}][nom_prenom]" class="form-control" placeholder="الاسم واللقب">
                </td>
                <td data-label="الصفة">
                    <input type="text" name="invites[${inviteIndex}][role]" class="form-control" placeholder="الصفة">
                </td>
                <td data-label="الجنسية">
                    <input type="text" name="invites[${inviteIndex}][nationalite]" class="form-control" placeholder="الجنسية">
                </td>
                <td class="action-buttons">
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button>
                </td>
            </tr>`;
        tableBody.insertAdjacentHTML('beforeend', newRow);
        inviteIndex++;
    }

    function removeRow(button) {
        button.closest('tr').remove();
    }
</script>


<script>
    let assocIndex = <?php echo e($assocParticipantes->count() ?? 1); ?>;

    function addAssocRow() {
        const tbody = document.getElementById('assoc_participantes-body');
        const newRow = document.createElement('tr');

        newRow.innerHTML = `
            <td class="row-number"></td>
            <td><input type="text" name="assoc_participantes[${assocIndex}][nom]" class="form-control" placeholder="اسم الجمعية"></td>
            <td><input type="number" name="assoc_participantes[${assocIndex}][num_athlete_h]" class="form-control text-center" placeholder="ذكور" min="0"></td>
            <td><input type="number" name="assoc_participantes[${assocIndex}][num_athlete_f]" class="form-control text-center" placeholder="إناث" min="0"></td>
            <td><input type="number" name="assoc_participantes[${assocIndex}][accompagnants]" class="form-control text-center" placeholder="عدد" min="0"></td>
            <td><input type="number" name="assoc_participantes[${assocIndex}][total]" class="form-control text-center" readonly placeholder="0"></td>
            <td><button type="button" class="btn btn-danger btn-sm" onclick="removeAssocRow(this)">حذف</button></td>
        `;
        tbody.appendChild(newRow);
        assocIndex++;
        updateAssocRowNumbers();
        updateTotals();
    }

    function removeAssocRow(button) {
        button.closest('tr').remove();
        updateAssocRowNumbers();
        updateTotals();
    }

    function updateAssocRowNumbers() {
        const rows = document.querySelectorAll('#assoc_participantes-body tr');
        rows.forEach((row, index) => {
            row.querySelector('.row-number').textContent = index + 1;
        });
    }

    document.addEventListener('input', function(e) {
        if (!e.target.closest('#assoc_participantes-body')) return;

        const row = e.target.closest('tr');

        const males = Number(row.querySelector('input[name$="[num_athlete_h]"]').value) || 0;
        const females = Number(row.querySelector('input[name$="[num_athlete_f]"]').value) || 0;
        const escorts = Number(row.querySelector('input[name$="[accompagnants]"]').value) || 0;

        const rowTotal = males + females + escorts;
        const totalInput = row.querySelector('input[name$="[total]"]');
        if (totalInput) totalInput.value = rowTotal;

        updateTotals();
    });

    function updateTotals() {
        let totalMales = 0;
        let totalFemales = 0;
        let totalAccompagnants = 0;
        let totalGeneral = 0;

        document.querySelectorAll('#assoc_participantes-body tr').forEach(row => {
            totalMales += Number(row.querySelector('input[name$="[num_athlete_h]"]').value) || 0;
            totalFemales += Number(row.querySelector('input[name$="[num_athlete_f]"]').value) || 0;
            totalAccompagnants += Number(row.querySelector('input[name$="[accompagnants]"]').value) || 0;
            totalGeneral += Number(row.querySelector('input[name$="[total]"]').value) || 0;
        });

        document.getElementById('total-males').value = totalMales;
        document.getElementById('total-females').value = totalFemales;
        document.getElementById('total-accompagnants').value = totalAccompagnants;
        document.getElementById('total-general').value = totalGeneral;
    }

    updateTotals();
</script>


<script>
let athleteIndex = 1;

function addAthleteRow() {
    const tbody = document.getElementById('athletes-body');
    const newRow = document.createElement('tr');

    newRow.innerHTML = `
        <td class="row-number"></td>
        <td><input type="text" name="athletes[${athleteIndex}][nom_prenom_sportif]" class="form-control" placeholder="الاسم و اللقب"></td>
        <td><input type="number" name="athletes[${athleteIndex}][num_athlete_h]" class="form-control text-center" placeholder="ذكور" min="0"></td>
        <td><input type="number" name="athletes[${athleteIndex}][num_athlete_f]" class="form-control text-center" placeholder="إناث" min="0"></td>
        <td><input type="number" name="athletes[${athleteIndex}][accompagnants]" class="form-control text-center" placeholder="عدد" min="0"></td>
        <td><input type="number" name="athletes[${athleteIndex}][total]" class="form-control text-center" readonly placeholder="0"></td>
        <td><button type="button" class="btn btn-danger btn-sm" onclick="removeAthleteRow(this)">حذف</button></td>
    `;
    tbody.appendChild(newRow);
    athleteIndex++;
    updateAthleteRowNumbers();
    update2Totals();
}

function removeAthleteRow(button) {
    button.closest('tr').remove();
    updateAthleteRowNumbers();
    update2Totals();
}

function updateAthleteRowNumbers() {
    const rows = document.querySelectorAll('#athletes-body tr');
    rows.forEach((row, index) => {
        row.querySelector('.row-number').textContent = index + 1;
    });
}

document.addEventListener('input', function(e) {
    if (!e.target.closest('#athletes-body')) return;

    const row = e.target.closest('tr');

    const males = Number(row.querySelector('input[name$="[num_athlete_h]"]').value) || 0;
    const females = Number(row.querySelector('input[name$="[num_athlete_f]"]').value) || 0;
    const escorts = Number(row.querySelector('input[name$="[accompagnants]"]').value) || 0;

    const rowTotal = males + females + escorts;
    const totalInput = row.querySelector('input[name$="[total]"]');
    if (totalInput) totalInput.value = rowTotal;

    update2Totals();
});

function update2Totals() {
    let total2Males = 0;
    let total2Females = 0;
    let total2Accompagnants = 0;
    let total2General = 0;

    document.querySelectorAll('#athletes-body tr').forEach(row => {
        total2Males += Number(row.querySelector('input[name$="[num_athlete_h]"]').value) || 0;
        total2Females += Number(row.querySelector('input[name$="[num_athlete_f]"]').value) || 0;
        total2Accompagnants += Number(row.querySelector('input[name$="[accompagnants]"]').value) || 0;
        total2General += Number(row.querySelector('input[name$="[total]"]').value) || 0;
    });

    document.getElementById('total2-males').value = total2Males;
    document.getElementById('total2-females').value = total2Females;
    document.getElementById('total2-accompagnants').value = total2Accompagnants;
    document.getElementById('total2-general').value = total2General;
}

update2Totals();
</script>


<script>
    let sportifIndex = <?php echo e($sportifIndex ?? 1); ?>; 

    function addSportifRow() {
        const tbody = document.getElementById('sportifs-body');
        const newRow = document.createElement('tr');

        newRow.innerHTML = `
            <td data-label="الاسم واللقب">
                <input type="text" name="sportifs[${sportifIndex}][nom_prenom]" class="form-control" placeholder="الاسم واللقب">
            </td>
            <td data-label="الصنف العمري">
                <input type="text" name="sportifs[${sportifIndex}][tranch_age]" class="form-control" placeholder="الصنف العمري">
            </td>
            <td data-label="تاريخ الولادة">
                <input type="date" name="sportifs[${sportifIndex}][date_naissance]" class="form-control">
            </td>
            <td data-label="رقم بطاقة التعريف">
                <input type="text" name="sportifs[${sportifIndex}][num_cin]" class="form-control" placeholder="رقم البطاقة">
            </td>
            <td class="action-buttons">
                <button type="button" class="btn btn-danger btn-sm" onclick="removeSportifRow(this)">حذف</button>
            </td>
        `;

        tbody.appendChild(newRow);
        sportifIndex++;
    }

    function removeSportifRow(button) {
        button.closest('tr').remove();
    }

</script>

<script>
    let touristeIndex = document.querySelectorAll('#touristes-body tr').length;

    function addTouristeRow() {
        const tbody = document.getElementById('touristes-body');
        const row = document.createElement('tr');

        row.innerHTML = `
            <td><input type="text" name="touristes[${touristeIndex}][nom_prenom]" class="form-control" placeholder="الاسم واللقب"></td>
            <td><input type="text" name="touristes[${touristeIndex}][pays_origine]" class="form-control" placeholder="البلد الأصلي"></td>
            <td><input type="text" name="touristes[${touristeIndex}][num_passport]" class="form-control" placeholder="رقم جواز السفر"></td>
            <td><input type="date" name="touristes[${touristeIndex}][date_arrive]" class="form-control"></td>
            <td><input type="text" name="touristes[${touristeIndex}][lieu_residence]" class="form-control" placeholder="مكان الإقامة"></td>
            <td><input type="date" name="touristes[${touristeIndex}][date_depart]" class="form-control"></td>
            <td class="text-center">
                <button type="button" class="btn btn-danger btn-sm" onclick="removeTouristeRow(this)">
                    <i class="la la-trash"></i>
                </button>
            </td>
        `;

        tbody.appendChild(row);
        touristeIndex++;
    }

    function removeTouristeRow(button) {
        const row = button.closest('tr');
        const hiddenId = row.querySelector('input[name$="[id]"]');

        if (hiddenId) {
            const idValue = hiddenId.value;
            const deletedInput = document.createElement('input');
            deletedInput.type = 'hidden';
            deletedInput.name = 'delete_touristes[]';
            deletedInput.value = idValue;
            document.querySelector('form').appendChild(deletedInput);
        }

        row.remove();
    }
</script>

<script>
    let touriste2Index = document.querySelectorAll('#touriste2s-body tr').length;

    function addTouriste2Row() {
        const tbody = document.getElementById('touriste2s-body');
        const row = document.createElement('tr');

        row.innerHTML = `
            <td><input type="text" name="touriste2s[${touriste2Index}][nom_prenom]" class="form-control" placeholder="الاسم واللقب"></td>
            <td><input type="text" name="touriste2s[${touriste2Index}][pays_origine]" class="form-control" placeholder="البلد الأصلي"></td>
            <td><input type="text" name="touriste2s[${touriste2Index}][num_passport]" class="form-control" placeholder="رقم جواز السفر"></td>
            <td><input type="date" name="touriste2s[${touriste2Index}][date_arrive]" class="form-control"></td>
            <td><input type="text" name="touriste2s[${touriste2Index}][lieu_residence]" class="form-control" placeholder="مكان الإقامة"></td>
            <td><input type="date" name="touriste2s[${touriste2Index}][date_depart]" class="form-control"></td>
            <td class="text-center">
                <button type="button" class="btn btn-danger btn-sm" onclick="removeTouriste2Row(this)">
                    <i class="la la-trash"></i>
                </button>
            </td>
        `;

        tbody.appendChild(row);
        touriste2Index++;
    }

    function removeTouriste2Row(button) {
        const row = button.closest('tr');
        const hiddenId = row.querySelector('input[name$="[id]"]');

        if (hiddenId) {
            const deletedInput = document.createElement('input');
            deletedInput.type = 'hidden';
            deletedInput.name = 'delete_touriste2s[]';
            deletedInput.value = hiddenId.value;
            document.querySelector('form').appendChild(deletedInput);
        }

        row.remove();
    }
</script>

<script>
    let touriste3Index = <?php echo e(isset($evenement) && $evenement->etrangeres ? $evenement->etrangeres->where('type_etranger_id', 3)->count() : 1); ?>;

    function addTouriste3Row() {
        const tbody = document.getElementById('touriste3s-body');
        const row = document.createElement('tr');

        row.innerHTML = `
            <td><input type="text" name="touriste3s[${touriste3Index}][nom_prenom]" class="form-control" placeholder="الاسم واللقب"></td>
            <td><input type="text" name="touriste3s[${touriste3Index}][pays_origine]" class="form-control" placeholder="البلد الأصلي"></td>
            <td><input type="text" name="touriste3s[${touriste3Index}][num_passport]" class="form-control" placeholder="رقم جواز السفر"></td>
            <td><input type="date" name="touriste3s[${touriste3Index}][date_arrive]" class="form-control"></td>
            <td><input type="text" name="touriste3s[${touriste3Index}][lieu_residence]" class="form-control" placeholder="مكان الإقامة"></td>
            <td><input type="date" name="touriste3s[${touriste3Index}][date_depart]" class="form-control"></td>
            <td class="text-center">
                <button type="button" class="btn btn-danger btn-sm" onclick="removeTouriste3Row(this)">
                    <i class="la la-trash"></i>
                </button>
            </td>
        `;

        tbody.appendChild(row);
        touriste3Index++;
    }

    function removeTouriste3Row(button) {
        button.closest('tr').remove();
    }
</script>
<!-- **************** old toggle sections by rym **************** -->
<!-- <script>
function toggleSteps() {
    const id_type = document.getElementById('id_type').value;
    const statut_id = document.getElementById('statut_id').value;
    const statut2_id = document.getElementById('statut2_id').value;

    // Réinitialiser visibilité
    document.getElementById('section2').classList.add('d-none');
    document.getElementById('section3').classList.add('d-none');
    document.getElementById('fileSection').classList.add('d-none');
    document.getElementById('motif1').classList.add('d-none');
    document.getElementById('motif2').classList.add('d-none');
    document.getElementById('motif3').classList.add('d-none');

    // 1️⃣ Si admin choisit رفض => afficher motif1 uniquement
    if (id_type == "3") {
        document.getElementById('motif1').classList.remove('d-none');
        return;
    }

    // 2️⃣ Si admin choisit قبول => passer à la section الجامعة
    if (id_type == "1") {
        document.getElementById('section2').classList.remove('d-none');

        if (statut_id == "3") {
            document.getElementById('motif2').classList.remove('d-none');
            return;
        }

        if (statut_id == "1") {
            document.getElementById('section3').classList.remove('d-none');

            if (statut2_id == "3") {
                document.getElementById('motif3').classList.remove('d-none');
                return;
            }

            if (statut2_id == "1") {
                document.getElementById('fileSection').classList.remove('d-none');
            }
        }
    }
}
</script> -->



<script>document.addEventListener("DOMContentLoaded", function () {    const gouvSelect = document.getElementById('gouvernorat_id');    const delSelect  = document.getElementById('delegation_id');    gouvSelect.addEventListener('change', function () {        let gouvId = this.value;        delSelect.innerHTML = '';        delSelect.disabled = true;        delSelect.innerHTML = '<option disabled selected>تحميل...</option>';        let url = "<?php echo e(route('delegations.get', ['gouvernoratId' => 'ID_PLACEHOLDER'])); ?>";        url = url.replace("ID_PLACEHOLDER", gouvId);        fetch(url)            .then(response => response.json())            .then(data => {                                delSelect.innerHTML = '<option disabled selected>اختر...</option>';                                data.forEach(d => {                    let option = document.createElement('option');                    option.value = d.id_delegation;                    option.text  = d.nom_ar;                    delSelect.appendChild(option);                });                delSelect.disabled = false;            });    });});</script>
<?php else: ?>
    <script>
        window.location.href = "<?php echo e(route('login')); ?>";
    </script>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/manifestation_sport/demande_inter/edit.blade.php ENDPATH**/ ?>