<!doctype html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>حالة المشروع</title>
</head>
<body>
    <div class="email-wrapper" style="font-family: Arial, sans-serif; direction: rtl; text-align: right; max-width: 600px; margin: 20px auto; border: 1px solid #ddd; padding: 20px; border-radius: 10px;">

        <div class="header" style="font-size: 20px; font-weight: bold; margin-bottom: 20px; text-align: center;">
            ملف الإعفاء الجبائي
        </div>

        <div class="content" style="line-height: 1.6; color: #222;">
            <?php if($type === 'accepted'): ?>
                <p>مرحباً <strong><?php echo e($utilisateur->nom_prenom ?? 'المستخدم'); ?></strong>،</p>
                <p>تم <strong>قبول</strong> ملفكم بنجاح.</p>
                <p> رقم الملف : <strong><?php echo e($numeroDossier); ?></strong></p>

            <?php elseif($type === 'rejected'): ?>
                <p>مرحباً <strong><?php echo e($utilisateur->nom_prenom ?? 'المستخدم'); ?></strong>،</p>
                <p>تم <strong>رفض</strong> ملفكم.</p>
                <p> رقم الملف : <strong><?php echo e($numeroDossier); ?></strong></p>
                <p><strong>السبب :</strong></p>
                <div><?php echo $motif ?? 'غير محدد'; ?></div>

            <?php elseif($type === 'incomplete'): ?>
                <p>مرحباً <strong><?php echo e($utilisateur->nom_prenom ?? 'المستخدم'); ?></strong>،</p>
                
                <p> رقم الملف : <strong><?php echo e($numeroDossier); ?></strong></p>
                <p><strong>التوضيح :</strong></p>
                <div><?php echo $motif ?? 'غير محدد'; ?></div>

            <?php elseif($type === 'deferred'): ?>
                <p>مرحباً <strong><?php echo e($utilisateur->nom_prenom ?? 'المستخدم'); ?></strong>،</p>
                <p>تم <strong>إرجاء</strong> ملفكم.</p>
                <p> رقم الملف : <strong><?php echo e($numeroDossier); ?></strong></p>
                <p><strong>الملاحظة :</strong></p>
                <div><?php echo $motif ?? 'غير محدد'; ?></div>

            <?php else: ?>
                <p>مرحباً <strong><?php echo e($utilisateur->nom_prenom ?? 'المستخدم'); ?></strong>،</p>
                <p>تم تحديث حالة ملفكم. رقم الملف : <strong><?php echo e($numeroDossier); ?></strong></p>
                <div><?php echo $motif ?? ''; ?></div>
            <?php endif; ?>

            <p style="margin-top: 15px;">نشكركم على تعاونكم واهتمامكم.</p>
        </div>

        <hr style="margin: 20px 0; border: none; border-top: 1px solid #eee;">

        <div class="footer" style="text-align: center; font-size: 12px; color: #555;">
            <div class="app-name"> وزارة الشباب والرياضة </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/preprov/www/mjs/back/resources/views/emails/document_status.blade.php ENDPATH**/ ?>