<?php $__env->startSection('title', 'إدارة المركبات و مراكز اقامة الشباب'); ?>

<?php $__env->startSection('content'); ?>

<?php if(Auth::check()): ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0 shadow-sm rounded-3 border-0">

                
                <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
                    <h2 class="widget-title m-0">إدارة المركبات و مراكز اقامة الشباب</h2>
                    <a class="btn btn-success btn-sm px-3" href="<?php echo e(route('auberges.create')); ?>">
                        <i class="la la-plus me-1"></i> إضافة
                    </a>
                </div>

                
                <div class="block-card-header px-4 border-bottom-0 pb-3">
                    <form method="GET" action="<?php echo e(route('auberges.index')); ?>">
                        <div class="form-row align-items-center" style="direction: rtl;">
                            <div class="col-auto" style="width: 250px;">
                                <input 
                                    type="text" 
                                    name="q" 
                                    class="form-control" 
                                    placeholder="بحث بالإسم، المدير أو العنوان" 
                                    value="<?php echo e($search ?? ''); ?>"
                                >
                            </div>
                            <div class="col d-flex">
                                <button type="submit" class="btn bg-rgb-primary1 font-weight-medium" style="width: 105px;">
                                    بحث
                                </button>
                                <a href="<?php echo e(route('auberges.index')); ?>"
                                   class="btn bg-rgb-primary1 font-weight-medium d-flex align-items-center justify-content-center"
                                   style="width: 45px; height: 38px; margin-right: 5px; padding: 0;">
                                    <i class="fa-solid fa-rotate-right"></i>
                                </a>
                            </div>
                        </div>
                    </form>
                </div>

                
                <div class="block-card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>

                    <div class="my-table table-responsive" style="direction: rtl; text-align: right;">
                        <table class="table align-items-center table-flush mb-0 table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th>المعرف</th>
                                    <th>الإسم</th>
                                    <th>الإسم واللقب المدير</th>
                                    <th>الولاية</th>
                                    <th>المعتمدية</th>
                                    <th>العنوان</th>
                                    <th>إجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $auberges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $auberge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($index + 1); ?></td>
                                        <td class="fw-bold text-primary"><?php echo e($auberge->nom_ar); ?></td>
                                        <td><?php echo e($auberge->nom_directeur); ?></td>
                                        <td><?php echo e($auberge->gouvernorat?->nom_ar ?? '-'); ?></td>
                                        <td><?php echo e($auberge->delegation?->nom_ar ?? '-'); ?></td>
                                        <td><?php echo e($auberge->adresse_ar); ?></td>
                                        <td>
                                            <div class="d-flex justify-content-center gap-2">
                                                
                                                <a href="<?php echo e(route('auberges.show', $auberge->id)); ?>" 
                                                   class="btn-icon btn-icon--primary" 
                                                   title="عرض">
                                                    <i class="la la-eye"></i>
                                                </a>

                                                
                                                <button type="button"
                                                        class="btn-icon btn-icon--warning"
                                                        onclick="window.location='<?php echo e(route('auberges.edit', $auberge->id)); ?>'"
                                                        title="تعديل">
                                                    <i class="la la-edit"></i>
                                                </button>

                                                
                                                <form action="<?php echo e(route('auberges.destroy', $auberge->id)); ?>" method="POST" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="button"
                                                            onclick="return confirmAction('هل تريد حذف هذه المركز؟', null, this.closest('form'))"
                                                            class="btn-icon btn-icon--danger"
                                                            title="حذف">
                                                        <i class="la la-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="7" class="py-4 text-center text-muted">لا توجد دور إقامة حاليا</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <?php echo e($auberges->links('pagination::bootstrap-5')); ?>

                    </div>
                </div>

            </div>
        </div>
    </div>
</div>


<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: 'تأكيد',
        text: message,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            if (url) {
                window.location.href = url;
            } else if (form) {
                form.submit();
            }
        }
    });
    return false;
}
</script>

<style>
.table-hover th, 
.table-hover td {
    vertical-align: middle;
    text-align: center;
}

.table-hover th:nth-child(2),
.table-hover td:nth-child(2) {
    text-align: right !important;
    direction: rtl;
}

.status-badge {
    display: inline-block;
    padding: 6px 12px;
    border-radius: 12px;
    font-size: 14px;
    font-weight: 600;
    color: #fff;
    min-width: 60px;
    text-align: center;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.status-badge--success {
    background-color: #e8f9ee; 
    color: #27ae60;           
}

.status-badge--danger {
    background-color: #fde8ea; 
    color: #e74c3c;            
}
</style>

<?php else: ?>
<script>window.location.href = "<?php echo e(route('admin')); ?>";</script>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/auberges/creation_centre/index.blade.php ENDPATH**/ ?>