<?php $__env->startSection('content'); ?>
<div class="dashboard-content p-4">
    <!-- Header -->
	
    <div class="header-section mb-5" style="width: 1100px; height: 150px; padding-bottom: 150px; margin: 10px 10px 10px 10px;">
        <div class="row align-items-center">
            <div class="col-md-8 text-md-start text-center">
                <div class="d-flex align-items-center">
					<div class="user-avatar me-4 bg-danger-light rounded-circle" style="width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                        <i class="la la-user text-danger" style="font-size: 24px;"></i>
                    </div>
                    <div>
                        <h6 class="text-muted mb-1">مرحباً بك</h6>
                        <h4 class="mb-0"><?php echo e(auth()->user()->nom_prenom ?? 'زائر'); ?></h4>
                    </div>
                </div>
            </div>
            <div class="col-md-4 text-md-end text-center mt-md-0 mt-3">
                <div class="current-date bg-white rounded-pill px-4 py-2 shadow-sm d-inline-flex align-items-center">
                    <i class="la la-calendar text-danger me-2"></i>
                    <span><?php echo e(now()->translatedFormat('l j F Y')); ?></span>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row g-4 mb-4">
        <!-- Sports Facilities Stats -->
        <div class="col-md-3 mb-4">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="stat-icon bg-danger-light">
                            <i class="la la-dumbbell text-danger"></i>
                        </div>
                        <h6 class="text-muted" style="direction: rtl; text-align: right;">قاعات الرياضة</h6>
                    </div>
                    <h3 class="mb-2"><?php echo e(\App\Models\Immobilier::where('id_type_formulaire', 1)->count()); ?></h3>
                    <div class="progress" style="height: 4px;direction: rtl; text-align: right;">
                        <div class="progress-bar bg-danger" style="width: 70%"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Funding Requests Stats -->
        <div class="col-md-3 mb-4">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="stat-icon bg-success-light">
                            <i class="la la-money-bill text-success"></i>
                        </div>
                        <h6 class="text-muted" style="direction: rtl; text-align: right;">طلبات التمويل</h6>
                    </div>
                    <h3 class="mb-2"><?php echo e(\App\Models\DemandeFinancement::count()); ?></h3>
                    <div class="progress" style="height: 4px;direction: rtl; text-align: right;">
                        <div class="progress-bar bg-success" style="width: 85%"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sports Events Stats -->
        <div class="col-md-3 mb-4">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="stat-icon bg-warning-light">
                            <i class="la la-trophy text-warning"></i>
                        </div>
                        <h6 class="text-muted" style="direction: rtl; text-align: right;">التظاهرات الرياضية</h6>
                    </div>
                    <h3 class="mb-2"><?php echo e(\App\Models\DemandeManifestation::count()); ?></h3>
                    <div class="progress" style="height: 4px;direction: rtl; text-align: right;">
                        <div class="progress-bar bg-warning" style="width: 60%"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Users Stats -->
        <div class="col-md-3 mb-4">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="stat-icon bg-info-light">
                            <i class="la la-users text-info"></i>
                        </div>
                        <h6 class="text-muted" style="direction: rtl; text-align: right;">المستخدمين</h6>
                    </div>
                    <h3 class="mb-2"><?php echo e(\App\Models\Utilisateur::count()); ?></h3>
                    <div class="progress" style="height: 4px;direction: rtl; text-align: right;">
                        <div class="progress-bar bg-info" style="width: 75%"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Mini Stats Row -->
    <div class="row g-4 mb-4">
        <div class="col-md-6 col-lg-3">
            <div class="card mini-stat h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="text-muted mb-2" style="direction: rtl; text-align: right;">قاعات جديدة</h6>
                            <h4 class="mb-0"><?php echo e(\App\Models\Immobilier::whereMonth('created_at', now()->month)->count()); ?></h4>
                        </div>
                        <div class="mini-stat-icon bg-primary-light rounded-circle">
                            <i class="la la-plus text-primary"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6 col-lg-3">
            <div class="card mini-stat h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="text-muted mb-2" style="direction: rtl; text-align: right;">طلبات مقبولة</h6>
                            <h4 class="mb-0"><?php echo e(\App\Models\Immobilier::where('id_statut', 2)->count()); ?></h4>
                        </div>
                        <div class="mini-stat-icon bg-success-light rounded-circle">
                            <i class="la la-check text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6 col-lg-3">
            <div class="card mini-stat h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="text-muted mb-2" style="direction: rtl; text-align: right;">طلبات قيد المراجعة</h6>
                            <h4 class="mb-0"><?php echo e(\App\Models\Immobilier::where('id_statut', 1)->count()); ?></h4>
                        </div>
                        <div class="mini-stat-icon bg-warning-light rounded-circle">
                            <i class="la la-clock text-warning"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6 col-lg-3">
            <div class="card mini-stat h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="text-muted mb-2" style="direction: rtl; text-align: right;">طلبات مرفوضة</h6>
                            <h4 class="mb-0"><?php echo e(\App\Models\Immobilier::where('id_statut', 3)->count()); ?></h4>
                        </div>
                        <div class="mini-stat-icon bg-danger-light rounded-circle">
                            <i class="la la-times text-danger"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4 mb-4">
        <div class="col-lg-8 col-md-12">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h5 class="card-title mb-0" style="direction: rtl; text-align: right;">إحصائيات الطلبات الشهرية</h5>
                        <div class="chart-options">
                            <select class="form-select form-select-sm" id="yearSelect">
                                <option value="2025">2025</option>
                                <option value="2024">2024</option>
                                <option value="2023">2023</option>
                            </select>
                        </div>
                    </div>
                    <div style="width: 100%; height: 300px;">
                        <canvas id="monthlyRequestsChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Request Types Distribution -->
        <div class="col-lg-4 col-md-12">
            <div class="card h-100">
                <div class="card-body">
                    <h5 class="card-title mb-4" style="direction: rtl; text-align: right;">توزيع الطلبات حسب النوع</h5>
                    <div style="width: 100%; height: 300px;">
                        <canvas id="requestTypesChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Status Timeline -->
    <div class="card mb-4">
        <div class="card-body">
            <h5 class="card-title mb-4" style="direction: rtl; text-align: right;">تطور حالة الطلبات</h5>
            <div style="width: 100%; height: 150px;">
                <canvas id="statusTimelineChart"></canvas>
            </div>
        </div>
    </div>

    <!-- Recent Activity Table -->
    <div class="card" style="direction: rtl; text-align: right;">
        <div class="card-body">
            <h5 class="card-title mb-4">آخر النشاطات</h5>
            <div class="table-responsive">
                <table class="table dashboard-table" style="direction: rtl; text-align: right;">
                    <thead>
                        <tr>
                            <th>النوع</th>
                            <th>العنوان</th>
                            <th>الحالة</th>
                            <th>التاريخ</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            $recentActivities = collect()
                                ->merge(\App\Models\Immobilier::latest()->take(5)->get()->map(function($item) {
                                    return [
                                        'type' => 'قاعة رياضة',
                                        'title' => $item->adresse_imm,
                                        'status' => $item->statut->statut_ar ?? '-',
                                        'date' => $item->created_at
                                    ];
                                }))
                                ->merge(\App\Models\DemandeFinancement::latest()->take(5)->get()->map(function($item) {
                                    return [
                                        'type' => 'طلب تمويل',
                                        'title' => $item->titre ?? '-',
                                        'status' => $item->statut ?? '-',
                                        'date' => $item->created_at
                                    ];
                                }))
                                ->sortByDesc('date')
                                ->take(5);
                        ?>

                        <?php $__currentLoopData = $recentActivities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($activity['type']); ?></td>
                                <td><?php echo e($activity['title']); ?></td>
                                <td>
                                    <span class="badge <?php echo e($activity['status'] == 'مقبول' ? 'bg-success' : 'bg-warning'); ?>">
                                        <?php echo e($activity['status']); ?>

                                    </span>
                                </td>
                                <td><?php echo e($activity['date']->format('Y-m-d')); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>

<style>
    .dashboard-content {
        max-width: 1400px;
        margin: 0 auto;
    }
    
    .header-section {
        background: linear-gradient(to left, rgba(255,255,255,0.95), rgba(255,255,255,0.8));
        padding: 2rem;
        border-radius: 20px;
        margin-bottom: 2rem;
        backdrop-filter: blur(10px);
        box-shadow: 0 4px 15px rgba(0,0,0,0.05);
    }

    .stat-card {
        transition: all 0.3s ease;
        border: none;
        border-radius: 15px;
        overflow: hidden;
        background: linear-gradient(145deg, rgba(255,255,255,0.95), rgba(255,255,255,0.9));
        backdrop-filter: blur(10px);
    }

    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    }

    .stat-icon {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .stat-icon i {
        font-size: 24px;
    }

    .bg-danger-light {
        background: rgba(228, 33, 37, 0.1);
    }

    .bg-success-light {
        background: rgba(40, 167, 69, 0.1);
    }

    .bg-warning-light {
        background: rgba(255, 193, 7, 0.1);
    }

    .bg-info-light {
        background: rgba(23, 162, 184, 0.1);
    }

    .progress {
        background: rgba(0,0,0,0.05);
        border-radius: 10px;
        height: 6px;
    }

    .progress-bar {
        border-radius: 10px;
        transition: all 0.5s ease;
    }

    .card {
        border: none;
        border-radius: 15px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.05);
        background: linear-gradient(145deg, rgba(255,255,255,0.95), rgba(255,255,255,0.9));
        backdrop-filter: blur(10px);
        transition: all 0.3s ease;
    }

    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    }

    .card-body {
        padding: 1.5rem;
    }

    .card-title {
        color: #333;
        font-weight: 600;
        margin-bottom: 1.5rem;
    }

    .dashboard-table th {
        font-weight: 600;
        color: #333;
        background: rgba(228, 33, 37, 0.05);
        padding: 1rem;
    }

    .dashboard-table td {
        vertical-align: middle;
    }

    .badge {
        padding: 6px 12px;
        border-radius: 30px;
        font-weight: 500;
    }

    /* Chart Styles */
    .chart-options {
        background: rgba(255, 255, 255, 0.9);
        padding: 0.5rem;
        border-radius: 20px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    }

    .chart-options .form-select {
        border: none;
        background-color: transparent;
        padding-left: 1.5rem;
        padding-right: 0.5rem;
        font-size: 0.9rem;
        color: #666;
        cursor: pointer;
    }

    .chart-options .form-select:focus {
        box-shadow: none;
    }

    .card-title {
        color: #333;
        font-size: 1.1rem;
        font-weight: 600;
    }

    canvas {
        filter: drop-shadow(0 4px 6px rgba(0,0,0,0.02));
    }

    /* Animation for charts */
    @keyframes chartFadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .card canvas {
        animation: chartFadeIn 0.6s ease-out forwards;
    }

    /* Hover effect for chart cards */
    .card:hover canvas {
        filter: drop-shadow(0 8px 12px rgba(0,0,0,0.05));
        transition: filter 0.3s ease;
    }
</style>

<script src="https://cdn.jsdelivr.net/npm/chart.js@2.9.4/dist/Chart.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Configuration simple pour les graphiques
    const ctx1 = document.getElementById('monthlyRequestsChart').getContext('2d');
    const ctx2 = document.getElementById('requestTypesChart').getContext('2d');
    const ctx3 = document.getElementById('statusTimelineChart').getContext('2d');
    // Graphique 1 : Demandes mensuelles
    new Chart(ctx1, {
        type: 'line',
        data: {
            labels: ['جانفي', 'فيفري', 'مارس', 'أفريل', 'ماي', 'جوان', 'جويلية', 'أوت', 'سبتمبر', 'أكتوبر', 'نوفمبر', 'ديسمبر'],
            datasets: [{
                label: 'الطلبات الجديدة',
                data: [25, 30, 35, 40, 45, 50, 45, 40, 35, 30, 25, 20],
                borderColor: '#e42125',
                tension: 0.4,
                fill: false
            }, {
                label: 'الطلبات المقبولة',
                data: [20, 25, 30, 35, 40, 45, 40, 35, 30, 25, 20, 15],
                borderColor: '#28a745',
                tension: 0.4,
                fill: false
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'top',
                    rtl: true
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        drawBorder: false
                    }
                },
                x: {
                    grid: {
                        display: false
                    }
                }
            }
        }
    });

    // Graphique 2 : Distribution des types
    new Chart(ctx2, {
        type: 'doughnut',
        data: {
            labels: ['قاعات رياضية', 'تظاهرات', 'تمويلات'],
            datasets: [{
                data: [30, 20, 15],
                backgroundColor: ['#e42125', '#ffc107', '#17a2b8'],
                borderWidth: 0
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    rtl: true
                }
            },
            cutout: '70%'
        }
    });

    // Graphique 3 : Timeline des statuts
    new Chart(ctx3, {
        type: 'bar',
        data: {
            labels: ['<?php echo e(now()->format('F')); ?>', '<?php echo e(now()->subMonth(1)->format('F')); ?>', '<?php echo e(now()->subMonth(2)->format('F')); ?>', '<?php echo e(now()->subMonth(3)->format('F')); ?>'],
            datasets: [{
                label: 'قيد المراجعة',
                data: [15, 12, 10, 8],
                backgroundColor: '#ffc107'
            }, {
                label: 'مقبولة',
                data: [20, 25, 30, 35],
                backgroundColor: '#28a745'
            }, {
                label: 'مرفوضة',
                data: [5, 3, 2, 1],
                backgroundColor: '#dc3545'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'top',
                    rtl: true
                }
            },
            scales: {
                x: {
                    stacked: true,
                    grid: {
                        display: false
                    }
                },
                y: {
                    stacked: true,
                    grid: {
                        drawBorder: false
                    }
                }
            }
        }
    });
});
</script>

    </div>
</div>

<style>
.dashboard-content {
    padding: 2rem;
}

.dashboard-card {
    transition: all 0.3s ease;
    border: none;
    border-radius: 15px;
    box-shadow: 0 0 15px rgba(0,0,0,0.1);
    overflow: hidden;
}

.dashboard-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(228, 33, 37, 0.1);
}

.icon-box {
    width: 70px;
    height: 70px;
    margin: 0 auto;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 50%;
    background: rgba(228, 33, 37, 0.1);
}

.card-title {
    color: #333;
    font-size: 1.2rem;
    margin-bottom: 0.5rem;
}

.card-text {
    color: #666;
    font-size: 0.9rem;
}

.text-danger {
    color: #e42125 !important;
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Dell\Desktop\projet MJS\back\back\resources\views/backoffice/dashboard-content.blade.php ENDPATH**/ ?>