<!DOCTYPE html>
<html lang="<?php echo e($lang); ?>" dir="<?php echo e($direction); ?>">
<head>
<meta charset="utf-8">

<style>
body {
    font-family: DejaVu Sans;
    font-size: 12px;
    direction: <?php echo e($direction); ?>;
    text-align: <?php echo e($direction == 'rtl' ? 'right' : 'left'); ?>;
    color: #222;
    line-height: 1.6;
}

/* HEADER */
.header {
    border-bottom: 3px solid #c62828;
    margin-bottom: 20px;
    padding-bottom: 10px;
}

.header h3 {
    margin: 0;
    font-size: 17px;
    font-weight: bold;
}

/* TITRES */
h4 {
    margin: 25px 0 8px;
    padding-bottom: 4px;
    font-size: 14px;
    border-bottom: 2px solid #c62828;
    color: #000;
}

/* SECTIONS */
.section {
    background-color: #ffffff;
    border: 1px solid #ddd;
    border-<?php echo e($direction == 'rtl' ? 'right' : 'left'); ?>: 5px solid #c62828;
    padding: 12px 14px;
    margin-bottom: 15px;
}

/* ROWS */
.row {
    display: flex;
    flex-wrap: wrap;
    margin-bottom: 8px;
}

.field {
    width: 48%;
    margin-bottom: 8px;
}

/* LABEL + VALUE */
.label {
    font-size: 11px;
    color: #555;
    margin-bottom: 2px;
}

.value {
    font-size: 12px;
    font-weight: 500;
    padding: 4px 0;
    border-bottom: 1px dotted #999;
    min-height: 18px;
}

/* TABLE */
table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 10px;
    font-size: 11.5px;
}

th {
    background-color: #f2f2f2;
    border: 1px solid #000;
    padding: 6px;
    font-weight: bold;
}

td {
    border: 1px solid #000;
    padding: 6px;
}

/* REMARQUES */
.remarks-block {
    margin-top: 10px;
    padding: 10px;
    border: 1.5px solid #000;
    min-height: 70px;
}
</style>
</head>

<body>


<div class="header">
    <table width="100%" style="border:none;">
        <tr>
            <td style="width:120px; text-align:right; border:none;">
                <img src="<?php echo e(public_path('storage/logo.png')); ?>" style="width:90px;">
            </td>
            <td style="text-align:center; border:none;">
                <h3><?php echo e($formulaire->type_ar); ?></h3>
            </td>
            <td style="width:120px; border:none;"></td>
        </tr>
    </table>
</div>



<h4>المستثمر</h4>
<div class="section">
<?php
    $user = $activite->investissements->first()?->utilisateur;
?>

 <?php
    $user = $activite->investissements->first()?->utilisateur;
?>

    <div class="row">
        <div class="field">
            <span class="label">الاسم و اللقب</span>
            <span class="value"><?php echo e($user->nom_prenom ?? '-'); ?></span>
        </div>

       <div class="row">
            <div class="field">
                <span class="label">مكان الولادة</span>
                <span class="value"><?php echo e($user->lieu_naissance ?? '-'); ?></span>
            </div>

            <div class="field">
                <span class="label">
تاريخ الولادة</span>
                <span class="value"><?php echo e($user->date_naissance ?? '-'); ?></span>
            </div>
        </div>


        
        <div class="field">
            <span class="label">العنوان الشخصي</span>
            <span class="value"><?php echo e($user->adresse ?? '-'); ?></span>
        </div>
    </div>

    <div class="row">
        <div class="field">
            <span class="label">الهوية الشخصية</span>
            <span class="value"><?php echo e($activite->investissements->first()?->utilisateur->typeIdentite->type_ar ?? '-'); ?></span>
        </div>

        <div class="row">
        <?php if($user->id_type_identite == 1): ?>
            <div class="field">
                <span class="label">رقم بطاقة التعريف الوطنية</span>
                <span class="value"><?php echo e($user->cin ?? '-'); ?></span>
            </div>
            <div class="field">
                <span class="label">تاريخ إصدار البطاقة</span>
                <span class="value"><?php echo e($user->date_delivrance_cin ?? '-'); ?></span>
            </div>
             <div class="field">
                <span class="label"> مكان الإصدار </span>
                <span class="value"> <?php echo e($user->lieu_delivrance_cin ?? '-'); ?></span>
            </div>
        <?php elseif($user->id_type_identite == 2): ?>
            <div class="field">
                <span class="label">جواز السفر</span>
                <span class="value"><?php echo e($user->passport ?? '-'); ?></span>
            </div>
        <?php elseif($user->id_type_identite == 3): ?>
            <div class="field">
                <span class="label">الرقم الضريبي</span>
                <span class="value"><?php echo e($user->num_fiscal ?? '-'); ?></span>
            </div>
        <?php endif; ?>
    </div>

    <div class="field">
                <span class="label">المستوى التعليمي</span>
                <span class="value"><?php echo e($user->niveau_etude ?? '-'); ?></span>
            </div>
 <div class="field">
                <span class="label">آخر شهادة متحصل عليها</span>
                <span class="value"><?php echo e($user->dernier_diplome ?? '-'); ?></span>
            </div>

    <div class="field">
                <span class="label">الاقدمية في تعاطي النشاط</span>
                <span class="value"><?php echo e($user->experience ?? '-'); ?></span>
            </div>

            

        
    </div>
</div>


<h4> خاصيات النشاط </h4>
<div class="section">
    <div class="row">
        

        <div class="field">
            <span class="label">تنظيم الأنشطة الترفيهية للشباب و الطفولة </span>
            
        </div>

        <div class="field">
            <span class="label">الإستثمار في هذا النشاط</span>
            <span class="value"><?php echo e($activite->statutInv->statut_ar ?? '-'); ?></span>
        </div>

        <div class="field">
            <span class="label">طبيعة الأنشطة</span>
            <span class="value"><?php echo e($activite->natureActivite->nature_ar ?? '-'); ?></span>
        </div>

        <div class="field">
            <span class="label">الاسم التجاري للمشروع</span>
            <span class="value">      <?php echo e($activite->nom_projet ?? '-'); ?></span>
        </div>
<div class="field">
            <span class="label">عنوان المقر الاجتماعي</span>
            <span class="value"> <?php echo e($activite->adresse_siege ?? '-'); ?></span>
        </div>

    <div class="field">
            <span class="label"> الولاية</span>
            <span class="value"> <?php echo e($activite->gouvernorat->nom_ar ?? '-'); ?></span>
        </div>

        <div class="field">
            <span class="label">البلدية</span>
            <span class="value"> <?php echo e($activite->delegation->nom_ar ?? '-'); ?></span>
        </div>
        <div class="field">
            <span class="label">  
عنوان المقر الاجتماعي</span>
            <span class="value">    <?php echo e($activite->adresse_siege ?? __('site.jeunesse.table.no_value')); ?></span>
        </div>

        <div class="field">
            <span class="label"> الترقيم البريدي</span>
            <span class="value"> <?php echo e($activite->code_postal ?? __('site.jeunesse.table.no_value')); ?></span>
        </div>
</div>





               








       

        













<h4>جدول الاستثمار و التمويل</h4>
<div class="section">
<table>
    <thead>
        <tr>
           <th>الإستثمار</th>
                        <th>مبلغ الإستثمار</th>
                        <th>مصادر التمويل</th>
                        <th>مبلغ التمويل</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $activite->investissements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td> <?php echo e($secteurs->firstWhere('id_secteur', $inv->secteur_invest_id)?->secteur_ar ?? 'غير محدد'); ?></td>
            <td><?php echo e(number_format($inv->montant_inv,2)); ?></td>
            <td><?php echo e($source_fin->firstWhere('id_source', $inv->id_source_financement)?->source_ar ?? 'غير محدد'); ?></td>
            <td><?php echo e(number_format($inv->montant_fin, 2) ?? __('site.jeunesse.table.no_value')); ?></td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
</div>


<div class="section">
    <strong>تصريح على الشرف</strong><br>
    إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.
</div>

<div class="remarks-block">
        <strong>ملاحظات خاصة بالمندوبية الجهوية للشباب و الرياضة و التربية البدنية :</strong><br>
        <?php echo e(old('remarques', $activite->remarques) ?? ''); ?>

    </div>

</body>
</html>
<?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/investissement/gestion_jeunesse/pdf2.blade.php ENDPATH**/ ?>