
<?php $__env->startSection('content'); ?>


<section class="login-area section--padding text-rtl" style="margin-top: 100px;">
    <div class="container">

        <?php if(session('status')): ?>
            <div class="alert alert-success">
                <?php echo e(session('status')); ?>

            </div>
        <?php endif; ?>
    
        <?php if(session('error')): ?>
            <div class="alert alert-danger">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <?php if($errors->has('email')): ?>
            <div class="alert alert-danger mt-2">
                <?php echo e($errors->first('email')); ?>

            </div>
        <?php endif; ?>

        <div class="row justify-content-center">
            <div class="col-lg-5 col-md-7">
                <div class="card card-custom">
                    <div class="card-body p-4">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h3 class="text-center mx-auto mb-0" style="color: #A2052B; font-weight: bold;">
                                استرجاع كلمة المرور
                            </h3>
                            <button type="button" onclick="window.location.href='<?php echo e(route('login')); ?>'" class="btn btn-outline-secondary btn-sm">
                                رجوع <i class="bi bi-arrow-left"></i>
                            </button>
                        </div>

                        <form method="POST" action="<?php echo e(route('admin.password.email')); ?>" onsubmit="return validateRecaptcha()">
                            <?php echo csrf_field(); ?>

                            <div class="form-group mb-3">
                                <label for="email" class="font-weight-bold">البريد الإلكتروني</label>
                                <input type="email" class="form-control" style="text-transform: none; direction: rtl;" id="email" name="email"
                                       value="<?php echo e(old('email')); ?>" required autofocus>
                            </div>

                            <div class="form-group mb-3">
                                <div class="g-recaptcha" data-sitekey="<?php echo e(env('RECAPTCHA_SITE_KEY')); ?>"></div>
                                <span id="recaptcha-error" class="invalid-feedback" 
                                      style="display: none; text-align: right; color: red;">
                                    يرجى تأكيد أنك لست روبوتًا.
                                </span>
                            </div>

                            <button type="submit" class="btn btn-block btn-red">
                                ارسال رابط إعادة تعيين كلمة المرور
                            </button>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
    function validateRecaptcha() {
        const response = grecaptcha.getResponse();
        const errorMessageElement = document.getElementById('recaptcha-error');

        errorMessageElement.style.display = 'none';

        if (!response) {
            errorMessageElement.style.display = 'block';
            return false;
        }
        return true;
    }
</script>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.authentification.layouts_auth.app_auth', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/back/resources/views/backoffice/authentification/password/forgot-password.blade.php ENDPATH**/ ?>