<?php $__env->startSection('content'); ?>

<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire.css')); ?>">

<style>

    @media print {

    body * {

        visibility: hidden;

    }
    .container, .container * {

        visibility: visible; 

    }
    .no-print {

        display: none !important;

    }
    .container {

        position: absolute;

        left: 0;

        top: 0;

        width: 100%;

    }
}
</style>



<?php if(Auth::check()): ?>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-pO6Faa4sdB7Z3K/ZzF8O1NjcZk7CjJmUjeF3fXxOZbq1dsm7GJxSFeWmyt3E5kzZ+vHVH3K2Yv/Vs1QY7PZ3UQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />



<div class="container printable-content">

    <form action="<?php echo e(route('salle-sport.update', $immobilier->id_imm)); ?>" method="POST" enctype="multipart/form-data" lang="ar">

        <?php echo csrf_field(); ?>

        <?php echo method_field('PUT'); ?>



        <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire->id_type); ?>">



        <div class="header-print-container">

    <div class="header-side header-left">

        <span class="delegation-print">

            المندوبية الجهوية للشباب و الرياضة : 

            <?php echo e($delegations->where('id_delegation', $immobilier->delegation_id ?? '')->first()->nom_ar ?? '-'); ?>


        </span>

    </div>



    <div class="header-center">

   

        <h3 class="title-form">استمارة إيداع كراس الشروط لإحداث قاعة خاصة للرياضة</h3>

        <h4 class="title-request">اطلاع على المطلب</h4>

    </div>

<a href="<?php echo e(route('salle-sport.pdf', $immobilier->id_imm)); ?>" target="_blank"
   class="btn btn-danger">
    <i class="fa fa-file-pdf"></i> تحميل PDF
</a>


    

</div>

        <div>

            <div class="d-flex align-items-center mb-3">
    <h5 class="mb-0 fw-bold me-2">الوضعية الحالية:</h5>

    <?php switch($immobilier->id_statut):

        case (1): ?>
            <span><strong> قبول</strong></span>
            <?php break; ?>

        <?php case (2): ?>
            <span><strong>في الانتظار</strong></span>
            <?php break; ?>

        <?php case (3): ?>
            <span><strong>رفض</strong></span>
            <?php break; ?>

        <?php case (4): ?>
            <span><strong>موافقة شريطة</strong></span>
            <?php break; ?>

        <?php case (5): ?>
            <span><strong>إرجاء لإبداء الرأي</strong></span>
            <?php break; ?>

        <?php case (6): ?>
            <span><strong>مسودّة</strong></span>
            <?php break; ?>

        <?php default: ?>
            <span><strong>غير محدد</strong></span>

    <?php endswitch; ?>
</div>



            <?php if($immobilier->id_statut == 3 && !empty($immobilier->commentaire_motif)): ?>

                <div class="d-flex align-items-center mb-3">

                    <label class="fw-bold text-danger me-2 mb-0">سبب الرفض:</label>

                    <p class="mb-0 border p-2 rounded shadow-sm text-muted"><?php echo e($immobilier->commentaire_motif); ?></p>

                </div>

            <?php endif; ?>

        </div>



<div class="card shadow-lg border-0 mb-4 rounded-4">
  <div class="card-header bg-light py-2">
    <h5 class="mb-0 fw-bold">تاريخ تغيّر الوضعية</h6>
  </div>

  <div class="card-body p-2" dir="rtl">
    <?php if($immobilier->statutHistories->isEmpty()): ?>
      <p class="text-muted mb-0 ">لا توجد تغييرات سابقة.</p>
    <?php else: ?>
      <div class="compact-timeline">
        <?php $__currentLoopData = $immobilier->statutHistories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php
            $from = optional($hist->fromStatut)->statut_ar
                    ?? optional($hist->fromStatut)->libelle_ar
                    ?? '—';
            $to = optional($hist->toStatut)->statut_ar
                  ?? optional($hist->toStatut)->libelle_ar
                  ?? '—';
            $toId = optional($hist->toStatut)->id_statut;
            $badgeClass = $toId === 1 ? 'badge-success'
                         : ($toId === 3 ? 'badge-danger' : 'badge-muted');
            $changer = optional($hist->changer)->nom_prenom ?? optional($hist->changer)->email ?? 'نظام';
          ?>

          <div class="compact-item">
            <div class="compact-row d-flex align-items-center justify-content-between w-100">
              <div class="left-block text-end">
                <div class="small text-muted compact-date"><?php echo e($hist->created_at->format('d/m/Y H:i')); ?></div>
                <div class="very-small text-muted compact-user">بواسطة: <?php echo e($changer); ?></div>
              </div>

              <div class="right-block text-right flex-fill">
                <span class="compact-from small text-muted"><?php echo e($from); ?></span>
                <span class="compact-arrow" aria-hidden="true"> &larr; </span>
                <span class="compact-to small <?php echo e($badgeClass); ?>"><?php echo e($to); ?></span>
              </div>
            </div>

            <?php if($hist->commentaire): ?>
              <details class="compact-comment mt-1">
                <summary class="very-small text-danger">سبب / تعليق</summary>
                <div class="very-small text-muted mt-1"><?php echo e($hist->commentaire); ?></div>
              </details>
            <?php endif; ?>
          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
    <?php endif; ?>
  </div>
</div>

<style>
/* Compact timeline styles (RTL) */
.compact-timeline { display: flex; flex-direction: column; gap: 6px; }
.compact-item { padding: 6px 4px; border-bottom: 1px solid rgba(0,0,0,0.06); }

.compact-row { gap: 8px; align-items: flex-start; }

/* left block (date + user) placed on the right visually because of RTL */
.left-block { width: 160px; min-width: 120px; margin-left: 12px; }
.compact-date { font-size: 12px; color: #6c757d; }
.compact-user { font-size: 11px; color: #8a8f94; margin-top: 2px; }

/* main labels */
.right-block { display:flex; align-items:center; gap:6px; justify-content:flex-start; }
.compact-from { color: #6c757d; font-size: 13px; }
.compact-arrow { color: #6c757d; font-size: 14px; margin: 0 4px; }
.compact-to { font-size: 13px; padding: 3px 8px; border-radius: 10px; }

/* small badge color helpers */
.badge-success { background:#198754; color:#fff; }
.badge-danger  { background:#dc3545; color:#fff; }
.badge-muted   { background:#6c757d; color:#fff; }

/* comment details (very compact) */
.compact-comment summary {
  list-style: none;
  cursor: pointer;
  outline: none;
  padding: 0;
}

</style>


        <div class="form-section">

            <h4 class="mb-3 fw-bold">هوية الباعث</h4>   

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">الاسم و اللقب أو الاسم التجاري</label>

                <div class="col-sm-10 pt-2">

                    <span><?php echo e($immobilier->utilisateur->nom_prenom ?? '-'); ?></span>

                </div>

            </div>  

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">الهوية الشخصية</label>  

                <div class="col-sm-4 pt-2">

                    <span>

                        <?php echo e($typesIdentite->where('id_type', $immobilier->utilisateur->id_type_identite ?? '')->first()->type_ar ?? '-'); ?>


                    </span>

                </div>

                <div class="col-sm-6 pt-2">

                    <?php if($immobilier->utilisateur->cin): ?>

                        <span>بطاقة تعريف: <?php echo e($immobilier->utilisateur->cin); ?></span>

                    <?php elseif($immobilier->utilisateur->passport): ?>

                        <span>جواز سفر: <?php echo e($immobilier->utilisateur->passport); ?></span>

                    <?php elseif($immobilier->utilisateur->num_fiscal): ?>

                        <span>معرّف جبائي: <?php echo e($immobilier->utilisateur->num_fiscal); ?></span>

                    <?php else: ?>

                        <span>-</span>

                    <?php endif; ?>

                </div>

            </div>

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">رقم الهاتف الشخصي</label>

                <div class="col-sm-10 pt-2">

                    <span><?php echo e($immobilier->utilisateur->tel ?? '-'); ?></span>

                </div>

            </div>

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">البريد الالكتروني</label>

                <div class="col-sm-10 pt-2">

                    <span><?php echo e($immobilier->utilisateur->email ?? '-'); ?></span>

                </div>

            </div>

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">العنوان الشخصي</label>

                <div class="col-sm-10 pt-2">

                    <span><?php echo e($immobilier->utilisateur->adresse ?? '-'); ?></span>

                </div>

            </div>



            <h4 class="mb-3 fw-bold">هوية العقار</h4> 

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">عنوان العقار</label>

                <div class="col-sm-10 pt-2">

                    <span><?php echo e($immobilier->adresse_imm ?? '-'); ?></span>

                </div>

            </div>

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">الولاية</label>

                <div class="col-sm-4 pt-2">

                    <span>

                        <?php echo e($gouvernorats->where('id_gouver', $immobilier->gouvernorat_id ?? '')->first()->nom_ar ?? '-'); ?>


                    </span>

                </div>

                <label class="col-sm-2 col-form-label fw-bold">البلدية</label>

                <div class="col-sm-4 pt-2">

                    <span>

                        <?php echo e($delegations->where('id_delegation', $immobilier->delegation_id ?? '')->first()->nom_ar ?? '-'); ?>


                    </span>

                </div>

            </div>

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">صيغة العقار</label>

                <div class="col-sm-4 pt-2">

                    <span>

                        <?php echo e($typesImmobilier->where('id_type', $immobilier->type_imm_id ?? '')->first()->type_ar ?? '-'); ?>


                    </span>

                </div>

                <label class="col-sm-2 col-form-label fw-bold">المساحة الجملية للعقار بالم2</label>

                <div class="col-sm-4 pt-2">

                    <span><?php echo e($immobilier->superfici_m2 ? $immobilier->superfici_m2.' م²' : '-'); ?></span>

                </div>

            </div>

            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">صيغة استغلال العقار</label>

                <div class="col-sm-4 pt-2">

                    <span>

                        <?php echo e($usagesImmobilier->where('id_usage_imm', $immobilier->usage_id ?? '')->first()->usage_ar ?? '-'); ?>


                    </span>

                </div>

                <label class="col-sm-2 col-form-label fw-bold">نسخة العقد/الملكية</label>

                <div class="col-sm-4 pt-2">

                    <?php if($immobilier->document_propriete): ?>
                         <a href="<?php echo e(route('immobilier.download', $immobilier->id_imm)); ?>?v=<?php echo e(time()); ?>"
   target="_blank">
   عرض
</a>
                    <?php else: ?>

                        <span>-</span>

                    <?php endif; ?>

                </div>
				
				

            </div>



            <h4 class="mb-3 fw-bold">مكونات العقار</h4>



<table class="table table-bordered text-center align-middle">

    <thead class="table-light">

        <tr>

            <th>المكوّن</th>

            <th>نعم / لا</th>

            <th>العدد</th>

            <th>المساحة</th>

        </tr>

    </thead>

    <tbody>

        <?php

            $components = [

                'salle_exercice'   => 'قاعة التمارين',

                'piscine'          => 'حوض مائي',

                'vestiaire'        => 'حجرات ملابس',

                'unitaires_sanitaire' => 'وحدات صحية',

                'stockage_conservation'  => 'فضاء للخزن وحفظ الأثاث والمعدات',

                'espace_exterieur' => 'فضاء خارجي',

                'garage'           => 'مأوى سيارات'

            ];

        ?>



        <?php $__currentLoopData = $components; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comp => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <tr>

                

                <td><?php echo e($label); ?></td>



                

                <td>

                    <?php if($immobilier->$comp == 1): ?>

                        نعم

                    <?php elseif($immobilier->$comp == 0): ?>

                        لا

                    <?php else: ?>

                        -

                    <?php endif; ?>

                </td>



                

<td>

    <?php if($immobilier->$comp == 1): ?>

        <?php if(in_array($comp, ['salle_exercice','piscine','vestiaire'])): ?>

            <?php echo e($immobilier->{'nbr_'.$comp} ?? '-'); ?>


        <?php else: ?>

            -

        <?php endif; ?>

    <?php else: ?>

        -

    <?php endif; ?>

</td>





<td>

    <?php if($immobilier->$comp == 1): ?>

        <?php echo e($immobilier->{'superface_'.$comp} ? $immobilier->{'superface_'.$comp}.' م²' : '-'); ?>


    <?php else: ?>

        -

    <?php endif; ?>

</td>



            </tr>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </tbody>

</table>





            <div class="form-group row mb-3">

                <label class="col-sm-2 col-form-label fw-bold">مساحات اخرى</label>

                <div class="col-sm-10 pt-2">

                   <span><?php echo e($immobilier->autres_surfaces ?? '-'); ?> م²</span>



                </div>

            </div>

        </div>

        <div class="form-group text-center mt-5">
            <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
                   <a href="<?php echo e(route('salle-sport.pdf', $immobilier->id_imm)); ?>" target="_blank"
                    class="btn btn-danger  d-flex align-items-center justify-content-center gap-1 flex-fill">
                        <i class="fa fa-file-pdf"></i> تحميل PDF
                    </a>
                <a href="<?php echo e(route('salle-sport.index')); ?>" class="btn btn-primary d-flex align-items-center justify-content-center gap-1 flex-fill">
                    <i class="bx bx-arrow-back" style="margin-right:5px;"></i> رجوع
                </a>
            </div>
        </div>
		<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">

    </form>

</div>



<?php else: ?>

    <script>

        window.location.href = "<?php echo e(route('admin')); ?>";

    </script>

<?php endif; ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/investissement/gestion_salle_sport/salle_sport/show.blade.php ENDPATH**/ ?>