<!DOCTYPE html>
<html lang="<?php echo e($lang); ?>" dir="<?php echo e($direction); ?>">
<head>
<meta charset="utf-8">

<style>
body {
    font-family: DejaVu Sans;
    font-size: 12px;
    direction: <?php echo e($direction); ?>;
    text-align: <?php echo e($direction == 'rtl' ? 'right' : 'left'); ?>;
    color: #222;
    line-height: 1.6;
}

/* HEADER */
.header {
    border-bottom: 3px solid #c62828;
    margin-bottom: 20px;
    padding-bottom: 10px;
}

.header h3 {
    margin: 0;
    font-size: 17px;
    font-weight: bold;
}

/* TITRES */
h4 {
    margin: 25px 0 8px;
    padding-bottom: 4px;
    font-size: 14px;
    border-bottom: 2px solid #c62828;
    color: #000;
}

/* SECTIONS */
.section {
    background-color: #ffffff;
    border: 1px solid #ddd;
    border-<?php echo e($direction == 'rtl' ? 'right' : 'left'); ?>: 5px solid #c62828;
    padding: 12px 14px;
    margin-bottom: 15px;
}

/* ROWS */
.row {
    display: flex;
    flex-wrap: wrap;
    margin-bottom: 8px;
}

.field {
    width: 48%;
    margin-bottom: 8px;
}

/* LABEL + VALUE */
.label {
    font-size: 11px;
    color: #555;
    margin-bottom: 2px;
}

.value {
    font-size: 12px;
    font-weight: 500;
    padding: 4px 0;
    border-bottom: 1px dotted #999;
    min-height: 18px;
}

/* TABLE */
table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 10px;
    font-size: 11.5px;
}

th {
    background-color: #f2f2f2;
    border: 1px solid #000;
    padding: 6px;
    font-weight: bold;
}

td {
    border: 1px solid #000;
    padding: 6px;
}

/* REMARQUES */
.remarks-block {
    margin-top: 10px;
    padding: 10px;
    border: 1.5px solid #000;
    min-height: 70px;
}
</style>
</head>

<body>

<div class="header">
    <table width="100%" style="border: none;">
        <tr>
            <td style="width:80px; text-align:right; border:none;">
                <img src="<?php echo e(public_path('storage/logo.png')); ?>" style="width:70px; height:auto;">
            </td>
            <td style="text-align:center; border:none;">
                <h3>مطلب في تنظيم أشخاص طبيعيين أو معنويين لتظاهرة رياضية وطنية بالبلاد التونسية</h3>
            </td>
            <td style="width:120px; border:none;"></td>
        </tr>
    </table>
</div>


<h4>جذاذة تعريفية بالأشخاص الطبيعيين أو المعنويين غير الهياكل الرياضية</h4> <div class="section"> <div class="row"> 
    <div class="field"> 
        <span class="label">اسم الهيكل غير الرياضي</span> 
    <span class="value"><?php echo e(old('org.nom', $org->nom ?? '')); ?></span> </div> <div class="field"> 
        <span class="label">عدد التاشيرة</span>
         <span class="value"><?php echo e($org->num_visa ?? ''); ?></span> </div> <div class="field">
             <span class="label">تاريخ التسجيل س.و.م</span>
             <span class="value"><?php echo e($org->date_enregistrement ?? ''); ?></span> 
            </div> <div class="field"> <span class="label">المعرف الجبائي</span> 
            <span class="value"><?php echo e($org->identifiant_fiscal ?? ''); ?></span> </div> <div class="field">
                
            <span class="label">رقم الحساب البنكي</span> 
            <span class="value"><?php echo e($org->num_compte_bancaire ?? ''); ?></span> </div> <div class="field">
                 <span class="label">العنوان</span> 
                 <span class="value"><?php echo e($org->adresse ?? ''); ?></span> </div> <div class="field">
                     <span class="label">رقم الهاتف</span> 
                     <span class="value"><?php echo e($org->tel ?? ''); ?></span> </div> <div class="field"> 
                        <span class="label">رقم الفاكس</span>
                         <span class="value"><?php echo e($org->fax ?? ''); ?></span> </div> </div> </div>

<h4 style="margin-top:30px;">
    ملف التامين الخاص
</h4>

<div class="section">
    <div class="row">

        <div class="field">
            <span class="label">
                نسخة من ملف التأمين الخاص بالتظاهرة الرياضية
            </span>

            
        </div>

        <?php if($demande->assuranceFile): ?>
                            <p>
                                الملف الحالي :
                                <a href="<?php echo e(route('manifestation.attachment.show', $demande->assuranceFile->id_attach)); ?>"
                                target="_blank">
                                    عرض الملف
                                </a>
                            </p>
                        <?php else: ?>
                            <p class="text-muted">لا يوجد</p>
                        <?php endif; ?>

    </div>
</div>
 <?php
            $evenement = $demande->evenementSportifs->first(); // On prend le premier événement lié
        ?>

    <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire3->id_type); ?>">

     <h4 style="margin-top:30px;">
   
   <?php echo e($formulaire3->type_ar); ?>

</h4>
          <br>
<div class="section">
    <div class="row">
        <div class="field">
            <span class="label">
               اسم التظاهرة
            </span>

            <span class="value">
                <?php echo e($evenement->nom_even ?? ''); ?>

            </span>
        </div>

        <div class="field">
            <span class="label">
              الهدف من تنظيم التظاهرة و آثارها الرياضية و الأبعاد الاقتصادية والاجتماعية: 
            </span>

            <span class="value">
                <?php echo e(old('objectifs', $evenement->objectifs ?? '')); ?>

            </span>
        </div>

        <div class="field">
            <span class="label">
             محتوى التظاهرة و الاختصاصات الرياضية المستهدفة : 
            </span>

            <span class="value">
                <?php echo e(old('contenus', $evenement->contenus ?? '')); ?>

            </span>
        </div>
		
		<div class="field">
            <span class="label">
              تاريخ تنظيم التظاهرة : 
            </span>

            <span class="value">
                <?php echo e($evenement->date ?? ''); ?>

            </span>
        </div>
		
		<div class="field">
            <span class="label">
              
توقيت تنظيم التظاهرة : 
            </span>

            <span class="value">
                <?php echo e(isset($evenement->heure) ? \Carbon\Carbon::parse($evenement->heure)->format('H:i') : ''); ?>

            </span>
        </div>
		
		<div class="field">
            <span class="label">
              الولاية
            </span>

            <span class="value">
                <?php echo e(optional($gouvernorats->firstWhere('id_gouver', $evenement->gouvernorat_id))->nom_ar ?? ''); ?>

            </span>
        </div>
		
		<div class="field">
            <span class="label">
             البلدية
            </span>

            <span class="value">
               <?php echo e(optional($delegations->firstWhere('id_delegation', $evenement->delegation_id))->nom_ar ?? ''); ?>

            </span>
        </div>
		
		<div class="field">
            <span class="label">
              المنشئات الرياضية التي ستستغل : 
            </span>

            <span class="value">
                <?php echo e(old('instalation_sportives', $evenement->instalation_sportives ?? '')); ?>

            </span>
        </div>
		
		<div class="field">
            <span class="label">
              الجامعة الرياضية مرجع الاختصاص : 
            </span>

            <span class="value">
                <?php echo e($evenement->reference ?? ''); ?>

            </span>
        </div>
		
		<div class="field">
            <span class="label">
              المداخيل التقديرية الجملية : 
            </span>

            <span class="value">
                <?php echo e($evenement->estimation_evenement ?? ''); ?>

            </span>
        </div>
		
		<div class="field">
            <span class="label">
             
المصاريف التقديرية الجملية :
            </span>

            <span class="value">
                <?php echo e($evenement->cout_total_evenement ?? ''); ?>

            </span>
        </div>
		
		<div class="field">
            <span class="label">
             الفارق التقديري : 
            </span>

            <span class="value">
                <?php echo e($evenement->difference_estimee ?? ''); ?>

            </span>
        </div>
		
		<div class="field">
            <span class="label">
             بيان الجوائز : 
            </span>

            <span class="value">
                <?php echo e($evenement->recompense ?? ''); ?>

            </span>
        </div>
		<input type="hidden" name="user_id" value="<?php echo e(Auth::user()->id); ?>">
    </div>
</div>
<input type="hidden" name="id_formulaire" value="<?php echo e($formulaire4->id_type); ?>">
           
<h4 style="margin-top:30px;">
  <?php echo e($formulaire4->type_ar); ?>

</h4>
          <br>



<div class="section">
    <div class="section-title">
    قائمة عناصر فريق التنظيم 
    </div>

    <?php
        $membres = $evenement && $evenement->membres
            ? $evenement->membres->where('type_membre_id', 1)
            : collect();
    ?>

    <table>
        <thead>
            <tr>
                <th>الاسم واللقب</th>
                <th>الصفة</th>
                <th>الجنسية</th>
            </tr>
        </thead>
        <tbody>
            <?php if($membres->count()): ?>
                <?php $__currentLoopData = $membres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $membre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($membre->nom_prenom ?? '-'); ?></td>
                        <td><?php echo e($membre->role ?? '-'); ?></td>
                        <td><?php echo e($membre->nationalite ?? '-'); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <tr>
                    <td>-</td>
                    <td>-</td>
                    <td>-</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>


<div class="section">
    <div class="section-title">
        الشخصيات الرسمية المدعوة
    </div>

    <?php
        $invites = $evenement && $evenement->membres
            ? $evenement->membres->where('type_membre_id', 2)
            : collect();
    ?>

    <table>
        <thead>
            <tr>
                <th>الاسم واللقب</th>
                <th>الصفة</th>
                <th>الجنسية</th>
            </tr>
        </thead>
        <tbody>
            <?php if($invites->count()): ?>
                <?php $__currentLoopData = $invites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invite): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($invite->nom_prenom ?? '-'); ?></td>
                        <td><?php echo e($invite->role ?? '-'); ?></td>
                        <td><?php echo e($invite->nationalite ?? '-'); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <tr>
                    <td>-</td>
                    <td>-</td>
                    <td>-</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<input type="hidden" name="id_formulaire" value="<?php echo e($formulaire5->id_type); ?>">
<h4 style="margin-top:30px;">
   <?php echo e($formulaire5->type_ar); ?>

</h4>
          <br>

 <div class="section">
    <div class="row">
        <div class="field">
            <span class="label">
                الجمعيات المشاركة
            </span>
			
		</div>
		
		
		<?php
        $assocParticipantes = collect();
        if ($demande->evenementSportifs && $demande->evenementSportifs->first()) {
            $assocParticipantes = $demande->evenementSportifs->first()->assocParticipantes ?? collect();
        }
    ?>

    <table>
        <thead>
            <tr>
                <th rowspan="2" style="width:5%">
                    ع/ر
                </th>
                <th rowspan="2" style="width:25%">
                    الجمعيات المشاركة
                </th>
                <th colspan="2" style="width:30%">
                    عدد الرياضيين
                </th>
                <th rowspan="2" style="width:15%">
                    المرافقون
                </th>
                <th rowspan="2" style="width:15%">
                   المجموع
                </th>
            </tr>
            <tr>
                <th>ذكور</th>
                <th>إناث</th>
            </tr>
        </thead>

        <tbody>
            <?php if($assocParticipantes->count()): ?>
                <?php $__currentLoopData = $assocParticipantes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $assoc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($index + 1); ?></td>
                        <td><?php echo e($assoc->nom ?? '-'); ?></td>
                        <td><?php echo e($assoc->num_athlete_h ?? 0); ?></td>
                        <td><?php echo e($assoc->num_athlete_f ?? 0); ?></td>
                        <td><?php echo e($assoc->accompagnants ?? 0); ?></td>
                        <td><strong><?php echo e($assoc->total ?? 0); ?></strong></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <tr>
                    <td>1</td>
                    <td>-</td>
                    <td>0</td>
                    <td>0</td>
                    <td>0</td>
                    <td><strong>0</strong></td>
                </tr>
            <?php endif; ?>
        </tbody>

        <tfoot>
            <tr>
                <th colspan="2">
                   المجموع العام
                </th>
                <th><?php echo e($assocParticipantes->sum('num_athlete_h')); ?></th>
                <th><?php echo e($assocParticipantes->sum('num_athlete_f')); ?></th>
                <th><?php echo e($assocParticipantes->sum('accompagnants')); ?></th>
                <th><strong><?php echo e($assocParticipantes->sum('total')); ?></strong></th>
            </tr>
        </tfoot>
    </table>
	</div>
</div>
                    
  
<input type="hidden" name="id_formulaire" value="<?php echo e($formulaire6->id_type); ?>">
<h4 style="margin-top:30px;">
  <?php echo e($formulaire6->type_ar); ?>

</h4>
<br> 
  
<div class="section">
    <div class="row">
        <div class="field">
            <span class="label">
                الرياضيين المشاركين بصفة فردية
            </span>
			
		</div>
		
		<?php
        $athletes = collect();
        if ($demande->evenementSportifs && $demande->evenementSportifs->first()) {
            $athletes = $demande->evenementSportifs->first()->athletesIndividuels ?? collect();
        }
    ?>

    <table>
        <thead>
            <tr>
                <th rowspan="2" style="width:5%">
                ع/ر
                </th>
                <th rowspan="2" style="width:30%">
                    اسم و لقب الرياضي المشارك
                </th>
                <th colspan="2" style="width:25%">
                    عدد الرياضيين
                </th>
                <th rowspan="2" style="width:15%">
                    المرافقون
                </th>
                <th rowspan="2" style="width:15%">
                   المجموع
                </th>
            </tr>
            <tr>
                <th>ذكور</th>
                <th>إناث</th>
            </tr>
        </thead>

        <tbody>
            <?php if($athletes->count()): ?>
                <?php $__currentLoopData = $athletes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $athlete): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($index + 1); ?></td>
                        <td><?php echo e($athlete->nom_prenom_sportif ?? '-'); ?></td>
                        <td><?php echo e($athlete->num_athlete_h ?? 0); ?></td>
                        <td><?php echo e($athlete->num_athlete_f ?? 0); ?></td>
                        <td><?php echo e($athlete->accompagnants ?? 0); ?></td>
                        <td><strong><?php echo e($athlete->total ?? 0); ?></strong></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <tr>
                    <td>1</td>
                    <td>-</td>
                    <td>0</td>
                    <td>0</td>
                    <td>0</td>
                    <td><strong>0</strong></td>
                </tr>
            <?php endif; ?>
        </tbody>

        <tfoot>
            <tr>
                <th colspan="2">
                    المجموع العام
                </th>
                <th><?php echo e($athletes->sum('num_athlete_h')); ?></th>
                <th><?php echo e($athletes->sum('num_athlete_f')); ?></th>
                <th><?php echo e($athletes->sum('accompagnants')); ?></th>
                <th><strong><?php echo e($athletes->sum('total')); ?></strong></th>
            </tr>
        </tfoot>
    </table>
	</div>
</div>	

<input type="hidden" name="id_formulaire" value="<?php echo e($formulaire7->id_type); ?>">
<h4 style="margin-top:30px;">
   <?php echo e($formulaire7->type_ar); ?>

</h4>
<br> 
  
<div class="section">
    <div class="row">
        <div class="field">
            <span class="label">
                الرياضيين المشاركين
            </span>
			
		</div>
		
		<?php
        $sportifs = collect();
        if ($demande->evenementSportifs && $demande->evenementSportifs->first()) {
            $sportifs = $demande->evenementSportifs->first()->sportifs ?? collect();
        }
    ?>

    <table>
        <thead>
            <tr>
                <th>اسم و لقب الرياضي المشارك</th>
                <th>الصنف العمري</th>
                <th>تاريخ الولادة</th>
                <th>رقم بطاقة التعريف</th>
            </tr>
        </thead>
        <tbody>
            <?php if($sportifs->count()): ?>
                <?php $__currentLoopData = $sportifs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sportif): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($sportif->nom_prenom ?? '-'); ?></td>
                        <td><?php echo e($sportif->tranch_age ?? '-'); ?></td>
                        <td><?php echo e($sportif->date_naissance ?? '-'); ?></td>
                        <td><?php echo e($sportif->num_cin ?? '-'); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <tr>
                    <td colspan="4">
                        لا يوجد
                    </td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
		
	</div>
</div>
<h4 style="margin-top:30px;">
   موافقة مبدئية
</h4>
<br> 
  
<div class="section">
    <div class="row">
        <div class="field">
            <span class="label">
                 موافقة مبدئية كتابية لاستغلال مكان إقامة التظاهرة الرياضية من المصالح المختصة
            </span>

            
        </div>

        <?php if($demande->accordFile): ?>
                            <p>
                                الملف الحالي :
                                <a href="<?php echo e(route('manifestation.attachment.show', $demande->accordFile->id_attach)); ?>"
                                target="_blank">
                                  عرض الملف
                                </a>
                            </p>
                        <?php else: ?>
                            <p class="text-muted">لا يوجد</p>
                        <?php endif; ?>

    </div>
</div>


<h4 style="margin-top:30px;">
الملف الفني
</h4>
 <br> 
  
<div class="section">
    <div class="row">
        <div class="field">
            <span class="label">
              الملف الفني للتظاهرة
            </span>

            
        </div>

        <?php if($demande->techniqueFile): ?>
                            <p>
                                الملف الحالي :
                                <a href="<?php echo e(route('manifestation.attachment.show', $demande->techniqueFile->id_attach)); ?>"
                                target="_blank">
                                    عرض الملف
                                </a>
                            </p>
                        <?php else: ?>
                            <p class="text-muted">لا يوجد</p>
                        <?php endif; ?>

    </div>
</div>           


<h4 style="margin-top:30px;">
 مطلب في إقامة تظاهرة رياضية وطنية بالبلاد التونسية
</h4>
 <br> 
  
<div class="section">
    <div class="row">
        <div class="field">
            <span class="label">
                المطلب
            </span>

            
        </div>

        <?php if($demande->demandeFile): ?>
                            <p>
                                الملف الحالي :
                                <a href="<?php echo e(route('manifestation.attachment.show', $demande->demandeFile->id_attach)); ?>"
                                target="_blank">
                                     عرض الملف
                                </a>
                            </p>
                        <?php else: ?>
                            <p class="text-muted">لا يوجد</p>
                        <?php endif; ?>

    </div>
</div> 


                

           
</body>
</html>
<?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/manifestation_sport/demande/pdf.blade.php ENDPATH**/ ?>