<?php $__env->startSection('content'); ?>

<?php if(Auth::check()): ?>
<section class="add-listing-area section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">
                <form method="POST" action="<?php echo e(route('federation.store')); ?>" enctype="multipart/form-data" id="federationForm" novalidate>
                    <?php echo csrf_field(); ?>

                    <div class="block-card mb-4">
                        <div class="block-card-header">
                            <h2 class="widget-title">إضافة جامعة رياضية</h2>
                            <div class="stroke-shape"></div>
                        </div>

                        <div class="block-card-body">

                            <div class="form-group">
                                <label>اسم الجامعة (بالعربية) <span class="text-danger">*</span></label>
                                <input name="nom_ar" class="form-control" value="<?php echo e(old('nom_ar')); ?>" required maxlength="100">
                                <div class="invalid-feedback-arabic" id="nom_ar_error"></div>
                            </div>

                            <div class="form-group">
                                <label>اسم الجامعة (بالفرنسية) <span class="text-danger">*</span></label>
                                <input name="nom_fr" class="form-control" value="<?php echo e(old('nom_fr')); ?>" required maxlength="100">
                                <div class="invalid-feedback-arabic" id="nom_fr_error"></div>
                            </div>

                            <div class="form-group">
                                <label>اسم الجامعة (بالإنجليزية) <span class="text-danger">*</span></label>
                                <input name="nom_en" class="form-control" value="<?php echo e(old('nom_en')); ?>" required maxlength="100">
                                <div class="invalid-feedback-arabic" id="nom_en_error"></div>
                            </div>

                            <div class="form-group">
                                <label>اسم الرئيس (بالعربية) <span class="text-danger">*</span></label>
                                <input name="president_ar" class="form-control" value="<?php echo e(old('president_ar')); ?>" required maxlength="100">
                                <div class="invalid-feedback-arabic" id="president_ar_error"></div>
                            </div>

                            <div class="form-group">
                                <label>اسم الرئيس (بالفرنسية) <span class="text-danger">*</span></label>
                                <input name="president_fr" class="form-control" value="<?php echo e(old('president_fr')); ?>" required maxlength="100">
                                <div class="invalid-feedback-arabic" id="president_fr_error"></div>
                            </div>

                            <div class="form-group">
                                <label>اسم الرئيس (بالإنجليزية) <span class="text-danger">*</span></label>
                                <input name="president_en" class="form-control" value="<?php echo e(old('president_en')); ?>" required maxlength="100">
                                <div class="invalid-feedback-arabic" id="president_en_error"></div>
                            </div>

                            <div class="form-group">
                                <label>الهاتف <span class="text-danger">*</span></label>
                                <input name="telephone" class="form-control" value="<?php echo e(old('telephone')); ?>" required pattern="\d{8}" maxlength="8">
                                <div class="invalid-feedback-arabic" id="telephone_error"></div>
                            </div>

                            <div class="form-group">
                                <label>الهاتف2</label>
                                <input name="telephone2" class="form-control" value="<?php echo e(old('telephone2')); ?>" pattern="\d{8}" maxlength="8">
                                <div class="invalid-feedback-arabic" id="telephone2_error"></div>
                            </div>

                            <div class="form-group">
                                <label>الفاكس</label>
                                <input name="fax" class="form-control" value="<?php echo e(old('fax')); ?>" pattern="\d{8}" maxlength="8">
                                <div class="invalid-feedback-arabic" id="fax_error"></div>
                            </div>

                            <div class="form-group">
                                <label>رابط الموقع</label>
                                <input name="site_web" class="form-control" value="<?php echo e(old('site_web')); ?>" maxlength="200" type="url">
                                <div class="invalid-feedback-arabic" id="site_web_error"></div>
                            </div>

                            <div class="form-group">
                                <label>العنوان بالعربية <span class="text-danger">*</span></label>
                                <textarea name="adresse_ar" class="form-control" required maxlength="150"><?php echo e(old('adresse_ar')); ?></textarea>
                                <div class="invalid-feedback-arabic" id="adresse_ar_error"></div>
                            </div>

                            <div class="form-group">
                                <label>العنوان بالفرنسية <span class="text-danger">*</span></label>
                                <textarea name="adresse_fr" class="form-control" required maxlength="150"><?php echo e(old('adresse_fr')); ?></textarea>
                                <div class="invalid-feedback-arabic" id="adresse_fr_error"></div>
                            </div>

                            <div class="form-group">
                                <label>العنوان بالإنجليزية <span class="text-danger">*</span></label>
                                <textarea name="adresse_en" class="form-control" required maxlength="150"><?php echo e(old('adresse_en')); ?></textarea>
                                <div class="invalid-feedback-arabic" id="adresse_en_error"></div>
                            </div>

                            <div class="form-group">
                                <label>تاريخ الإنشاء </label>
                                <input type="date" name="date_creation" class="form-control"  value="<?php echo e(old('date_creation')); ?>">
                                <div class="invalid-feedback-arabic" id="date_creation_error"></div>
                            </div>

                            <div class="form-group">
                                <label> البريد الإلكتروني</label>
                                <input type="email" name="email" class="form-control" value="<?php echo e(old('email')); ?>" maxlength="100">
                                <div class="invalid-feedback-arabic" id="email_error"></div>
                            </div>

                            <div class="form-group">
                                <label>الشعار <span class="text-danger">*</span></label>
                                <input type="file" name="logo" class="form-control" accept="image/*" required>
                                <div class="invalid-feedback-arabic" id="logo_error"></div>
                                <small class="form-text text-muted">الحجم الأقصى: 10 ميجابايت</small>
                            </div>

                        </div>

                        <div class="block-card-footer d-flex justify-content-start px-3 pb-3">
                            <button type="submit" class="btn bg-rgb-primary1 font-weight-medium mr-2">
                                <i class="la la-save mr-1"></i> حفظ
                            </button>
                            <a href="<?php echo e(route('federation.index')); ?>"
                                class="btn bg-rgb-primary1 font-weight-medium">
                                <i class="la la-times mr-1"></i> إلغاء
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('federationForm');
    const telephoneInput = document.querySelector('input[name="telephone"]');
    const telephone2Input = document.querySelector('input[name="telephone2"]');
    const faxInput = document.querySelector('input[name="fax"]');
    const siteWebInput = document.querySelector('input[name="site_web"]');
    const logoInput = document.querySelector('input[name="logo"]');
    const emailInput = document.querySelector('input[name="email"]');
    const MAX_FILE_SIZE = 10 * 1024 * 1024; // 10MB in bytes

    // Function to validate phone number
    function validatePhoneNumber(input, fieldName) {
        const value = input.value.trim();
        if (value === '' && input.hasAttribute('required')) {
            return 'هذا الحقل مطلوب';
        }
        
        if (value !== '' && !/^\d{8}$/.test(value)) {
            return 'يجب أن يتكون من 8 أرقام';
        }
        
        return null;
    }

    // Function to validate URL
    function validateURL(input) {
        const value = input.value.trim();
        if (value === '') return null;
        
        // Simple URL validation
        const urlPattern = /^(https?:\/\/)?([\da-z\.-]+)\.([a-z\.]{2,6})([\/\w \.-]*)*\/?$/;
        if (!urlPattern.test(value)) {
            return 'يرجى إدخال رابط صحيح';
        }
        
        return null;
    }

    // Function to validate email
    function validateEmail(input) {
        const value = input.value.trim();
        if (value === '') return null;
        
        const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (!emailPattern.test(value)) {
            return 'يرجى إدخال بريد إلكتروني صحيح';
        }
        
        return null;
    }

    // Function to validate file size
    function validateFileSize(fileInput) {
        if (fileInput.files.length > 0) {
            const file = fileInput.files[0];
            if (file.size > MAX_FILE_SIZE) {
                return 'حجم الملف يتجاوز 10 ميجابايت';
            }
        }
        return null;
    }

    // Function to validate max length
    function validateMaxLength(input, maxLength, fieldName) {
        const value = input.value.trim();
        if (value.length > maxLength) {
            return `لا يمكن أن يتجاوز ${maxLength} حرف`;
        }
        return null;
    }

    // Function to show error
    function showError(input, message) {
        input.classList.add('is-invalid');
        const errorDiv = document.getElementById(input.name + '_error');
        if (errorDiv && message) {
            errorDiv.textContent = message;
            errorDiv.style.display = 'block';
        }
    }

    // Function to clear error
    function clearError(input) {
        input.classList.remove('is-invalid');
        const errorDiv = document.getElementById(input.name + '_error');
        if (errorDiv) {
            errorDiv.textContent = '';
            errorDiv.style.display = 'none';
        }
    }

    // Real-time validation for phone numbers
    [telephoneInput, faxInput].forEach(input => {
        if (input) {
            input.addEventListener('input', function() {
                const error = validatePhoneNumber(this, this.name);
                if (error) {
                    showError(this, error);
                } else {
                    clearError(this);
                }
            });

            input.addEventListener('blur', function() {
                const error = validatePhoneNumber(this, this.name);
                if (error) {
                    showError(this, error);
                } else {
                    clearError(this);
                }
            });
        }
    });

    // Real-time validation for telephone2 (not required)
    if (telephone2Input) {
        telephone2Input.addEventListener('input', function() {
            if (this.value.trim()) {
                const error = validatePhoneNumber(this, this.name);
                if (error) {
                    showError(this, error);
                } else {
                    clearError(this);
                }
            } else {
                clearError(this);
            }
        });

        telephone2Input.addEventListener('blur', function() {
            if (this.value.trim()) {
                const error = validatePhoneNumber(this, this.name);
                if (error) {
                    showError(this, error);
                } else {
                    clearError(this);
                }
            } else {
                clearError(this);
            }
        });
    }

    // Real-time validation for URL (not required)
    if (siteWebInput) {
        siteWebInput.addEventListener('input', function() {
            if (this.value.trim()) {
                const urlError = validateURL(this);
                const lengthError = validateMaxLength(this, 200, 'site_web');
                const error = urlError || lengthError;
                
                if (error) {
                    showError(this, error);
                } else {
                    clearError(this);
                }
            } else {
                clearError(this);
            }
        });

        siteWebInput.addEventListener('blur', function() {
            if (this.value.trim()) {
                const urlError = validateURL(this);
                const lengthError = validateMaxLength(this, 200, 'site_web');
                const error = urlError || lengthError;
                
                if (error) {
                    showError(this, error);
                } else {
                    clearError(this);
                }
            } else {
                clearError(this);
            }
        });
    }

    // Real-time validation for email (not required)
    if (emailInput) {
        emailInput.addEventListener('input', function() {
            if (this.value.trim()) {
                const emailError = validateEmail(this);
                const lengthError = validateMaxLength(this, 100, 'email');
                const error = emailError || lengthError;
                
                if (error) {
                    showError(this, error);
                } else {
                    clearError(this);
                }
            } else {
                clearError(this);
            }
        });

        emailInput.addEventListener('blur', function() {
            if (this.value.trim()) {
                const emailError = validateEmail(this);
                const lengthError = validateMaxLength(this, 100, 'email');
                const error = emailError || lengthError;
                
                if (error) {
                    showError(this, error);
                } else {
                    clearError(this);
                }
            } else {
                clearError(this);
            }
        });
    }

    // Real-time validation for file size
    if (logoInput) {
        logoInput.addEventListener('change', function() {
            const error = validateFileSize(this);
            if (error) {
                showError(this, error);
            } else {
                clearError(this);
            }
        });
    }

    // Real-time validation for max length on president fields
    const presidentFields = document.querySelectorAll('input[name^="president_"]');
    presidentFields.forEach(input => {
        input.addEventListener('input', function() {
            const error = validateMaxLength(this, 100, this.name);
            if (error) {
                showError(this, error);
            } else {
                clearError(this);
            }
        });
    });

    // Real-time validation for max length on address fields
    const addressFields = document.querySelectorAll('textarea[name^="adresse_"]');
    addressFields.forEach(input => {
        input.addEventListener('input', function() {
            const error = validateMaxLength(this, 150, this.name);
            if (error) {
                showError(this, error);
            } else {
                clearError(this);
            }
        });
    });

    // Real-time validation for max length on nom fields
    const nomFields = document.querySelectorAll('input[name^="nom_"]');
    nomFields.forEach(input => {
        input.addEventListener('input', function() {
            const error = validateMaxLength(this, 100, this.name);
            if (error) {
                showError(this, error);
            } else {
                clearError(this);
            }
        });
    });

    // Clear error on input for all fields
    form.querySelectorAll('input, textarea').forEach(input => {
        input.addEventListener('input', function() {
            if (this.classList.contains('is-invalid')) {
                // Don't clear required field errors immediately if field is still empty
                if (!this.hasAttribute('required') || this.value.trim() !== '') {
                    clearError(this);
                }
            }
        });
    });

    // Form submission validation
    form.addEventListener('submit', function(event) {
        let isValid = true;
        
        // Clear all errors first
        form.querySelectorAll('.is-invalid').forEach(el => {
            el.classList.remove('is-invalid');
        });
        form.querySelectorAll('.invalid-feedback-arabic').forEach(el => {
            el.textContent = '';
            el.style.display = 'none';
        });

        // Check all required fields
        const requiredFields = form.querySelectorAll('[required]');
        requiredFields.forEach(field => {
            if (!field.value.trim()) {
                isValid = false;
                const fieldName = getFieldName(field.name);
                showError(field, `يرجى إدخال ${fieldName}`);
            }
        });

        // Validate telephone (required)
        const telephoneError = validatePhoneNumber(telephoneInput, 'telephone');
        if (telephoneError) {
            isValid = false;
            showError(telephoneInput, telephoneError);
        }

        // Validate telephone2 (not required - only if filled)
        if (telephone2Input && telephone2Input.value.trim()) {
            const telephone2Error = validatePhoneNumber(telephone2Input, 'telephone2');
            if (telephone2Error) {
                isValid = false;
                showError(telephone2Input, telephone2Error);
            }
        }

        // Validate fax (required)
        const faxError = validatePhoneNumber(faxInput, 'fax');
        if (faxError) {
            isValid = false;
            showError(faxInput, faxError);
        }

        // Validate URL (not required - only if filled)
        if (siteWebInput && siteWebInput.value.trim()) {
            const urlError = validateURL(siteWebInput);
            const lengthError = validateMaxLength(siteWebInput, 200, 'site_web');
            const siteWebError = urlError || lengthError;
            
            if (siteWebError) {
                isValid = false;
                showError(siteWebInput, siteWebError);
            }
        }

        // Validate email (not required - only if filled)
        if (emailInput && emailInput.value.trim()) {
            const emailError = validateEmail(emailInput);
            const lengthError = validateMaxLength(emailInput, 100, 'email');
            const emailValidationError = emailError || lengthError;
            
            if (emailValidationError) {
                isValid = false;
                showError(emailInput, emailValidationError);
            }
        }

        // Validate president fields length
        presidentFields.forEach(field => {
            const error = validateMaxLength(field, 100, field.name);
            if (error) {
                isValid = false;
                showError(field, error);
            }
        });

        // Validate address fields length
        addressFields.forEach(field => {
            const error = validateMaxLength(field, 150, field.name);
            if (error) {
                isValid = false;
                showError(field, error);
            }
        });

        // Validate nom fields length
        nomFields.forEach(field => {
            const error = validateMaxLength(field, 100, field.name);
            if (error) {
                isValid = false;
                showError(field, error);
            }
        });

        // Validate file size
        if (logoInput && logoInput.files.length > 0) {
            const fileError = validateFileSize(logoInput);
            if (fileError) {
                isValid = false;
                showError(logoInput, fileError);
            }
        }

        if (!isValid) {
            event.preventDefault();
            event.stopPropagation();
            
            // Scroll to first error
            const firstError = form.querySelector('.is-invalid');
            if (firstError) {
                firstError.scrollIntoView({ behavior: 'smooth', block: 'center' });
                firstError.focus();
            }
        }
    });

    // Helper function to get field name for error messages
    function getFieldName(field) {
        const fieldNames = {
            'nom_ar': 'اسم الجامعة بالعربية',
            'nom_fr': 'اسم الجامعة بالفرنسية',
            'nom_en': 'اسم الجامعة بالإنجليزية',
            'president_ar': 'اسم الرئيس بالعربية',
            'president_fr': 'اسم الرئيس بالفرنسية',
            'president_en': 'اسم الرئيس بالإنجليزية',
            'telephone': 'الهاتف',
            'adresse_ar': 'العنوان بالعربية',
            'adresse_fr': 'العنوان بالفرنسية',
            'adresse_en': 'العنوان بالإنجليزية',
            'logo': 'الشعار'
        };
        return fieldNames[field] || 'هذا الحقل';
    }
});
</script>

<style>
.invalid-feedback-arabic {
    display: none;
    color: #dc3545;
    font-size: 14px;
    margin-top: 5px;
    direction: rtl;
    text-align: right;
}

.is-invalid {
    border-color: #dc3545 !important;
    background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='none' stroke='%23dc3545' viewBox='0 0 12 12'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3e%3ccircle cx='6' cy='8.2' r='.6' fill='%23dc3545' stroke='none'/%3e%3c/svg%3e");
    background-repeat: no-repeat;
    background-position: right calc(0.375em + 0.1875rem) center;
    background-size: calc(0.75em + 0.375rem) calc(0.75em + 0.375rem);
    padding-right: 2.5rem !important;
}

.is-invalid:focus {
    border-color: #dc3545;
    box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25);
}

.form-group {
    margin-bottom: 1.5rem;
    position: relative;
}

.form-control {
    padding: 10px 15px;
    border: 1px solid #ddd;
    border-radius: 4px;
    transition: border-color 0.3s;
    width: 100%;
}

.form-control:focus {
    border-color: #007bff;
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
}

.form-text.text-muted {
    font-size: 12px;
    color: #6c757d;
    margin-top: 5px;
}

.text-danger {
    color: #dc3545 !important;
}

label {
    font-weight: 500;
    margin-bottom: 8px;
    display: block;
}

/* Custom styling for date input */
input[type="date"] {
    padding: 10px 15px;
    font-family: inherit;
}

/* Custom styling for file input */
input[type="file"] {
    padding: 8px 15px;
}

/* Ensure proper spacing */
.block-card-body {
    padding: 25px;
}

/* Style for required fields indicator */
.text-danger {
    font-size: 1.2em;
    vertical-align: middle;
}
</style>
<?php else: ?>
<script>
    window.location.href = "<?php echo e(route('admin')); ?>";
</script>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/federation/create.blade.php ENDPATH**/ ?>