<?php $__env->startSection('content'); ?>
<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire.css')); ?>">

<div class="container">
    <form action="<?php echo e(route('admin.debut_activite.store')); ?>" method="POST" id="myForm" lang="ar" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
<input type="hidden" name="immobilier_id" value="<?php echo e($immobilier_id ?? ''); ?>">
<input type="hidden" name="utilisateur_id" id="utilisateur_id">       
 <h2>الجمهورية التونسية  </h2>
        <h2> وزارة الشباب و الرياضة</h2>
        <h3>استمارة الاعلام ببداية النشاط</h3>
  
    <div class="form-section">
        <h4> هوية الباعث  </h4> 
        <div class="form-group row align-items-center mb-3">
            <label class="col-sm-2 col-form-label">نوع الهوية</label>
            <div class="col-sm-4">
                <select id="id_type_identite" class="form-control">
                    <option value="">اختر...</option>
                    <option value="1">بطاقة تعريف وطنية (CIN)</option>
                    <option value="2">جواز سفر (Passport)</option>
                    <option value="3">رقم تعريفي جبائي (Num Fiscal)</option>
                </select>
            </div>
            <div class="col-sm-4">
                <input type="text" class="form-control" id="identifiant" placeholder="ادخل رقم الهوية">
            </div>
            <div class="col-sm-2">
                <button type="button" id="verifierBtn" class="btn btn-primary w-100">التحقق</button>
            </div>
        </div>
        <div id="message"></div>
            <div id="sectionIdentite" class="d-none">
            <h5>بيانات الباعث</h5>
            <div class="form-group row">
                <label class="col-sm-2 col-form-label">الاسم و اللقب أو الاسم التجاري</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" id="nom_prenom" name="nom_prenom" readonly>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">رقم الهوية</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" id="identifiantAffiche" readonly>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">المندوبية الجهوية للشباب و الرياضة</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" id="mandoubia" readonly>
                </div>
            </div>
        </div>

            <h4> تاريخ بداية النشاط </h4> 
            <div class="form-group row">
                <div class="col-sm-11">
                    <input required type="date" class="form-control" id="date_debut_activite" name="date_debut_activite" placeholder="">
                </div>
            </div>
            <span>تاريخ بداية النشاط يجب ان يكون بعد 15 يوما من تاريخ استلام وصل التسجيل .</span>

            <h4> اضافة الوثائق المطلوبة </h4> 
            <div class="form-group row">
                <label for="preuve_propriete_location" class="col-sm-8 col-form-label"> 1- نسخة من شهادة الملكية او عقد بيع او عقد كراء او عقد هبة او اي وثيقة رسمية اخرى للعقار</label>
                <div class="col-sm-3">
                    <input required type="file" class="form-control" id="preuve_propriete_location" name="preuve_propriete_location" placeholder="">
                </div>
            </div>
            <div class="form-group row">
                <label for="plan_architectural" class="col-sm-8 col-form-label"> 2- مثال هندسي معد من قبل مهندس معماري مرسم بهيئة المهندسين المعماريين بالبلاد التونسية</label>
                <div class="col-sm-3">   
                    <input required type="file" class="form-control" id="plan_architectural" name="plan_architectural">
                </div>
            </div>
            <div class="form-group row">
                <label for="declaration_investissement" class="col-sm-8 col-form-label"> 3- شهادة تصريح بالاستثمار مسلمة من وكالةالنهوض بالصناعة و التجديد</label>
                <div class="col-sm-3">   
                    <input required type="file" class="form-control" id="declaration_investissement" name="declaration_investissement">
                </div>
            </div>

            <div class="form-group row">
                <label for="identification" class="col-sm-8 col-form-label"> 4- بطاقة تعريف جبائية</label>
                <div class="col-sm-3">   
                    <input required type="file" class="form-control" id="identification" name="identification">
                </div>
            </div>
            <div class="form-group row">
                <label for="extrait_registre_national_entreprise" class="col-sm-8 col-form-label"> 5- مضمون السجل الوطني للمؤسسات</label>
                <div class="col-sm-3">   
                    <input required type="file" class="form-control" id="extrait_registre_national_entreprise" name="extrait_registre_national_entreprise">
                </div>
            </div>
            <div class="form-group row">
                <label for="certificat_prevention" class="col-sm-8 col-form-label"> 6- شهادة وقاية مسلمة من المصالح الجهوية للحماية المدنية </label>
                <div class="col-sm-3">   
                    <input required type="file" class="form-control" id="certificat_prevention" name="certificat_prevention">
                </div>
            </div>
            <div class="form-group row">
                <label for="contrat_assurance" class="col-sm-8 col-form-label"> 7- عقد التامين</label>
                <div class="col-sm-3">   
                    <input required type="file" class="form-control" id="contrat_assurance" name="contrat_assurance">
                </div>
            </div>
            <div class="form-group row">
                <label for="approbation_autorite_minicipale" class="col-sm-8 col-form-label"> 8- عقود الشغل مع الاعوان القارين او تراخيص بمقابل بالنسبة للاعوان العموميين</label>
                <div class="col-sm-3">   
                    <input required type="file" class="form-control" id="approbation_autorite_minicipale" name="approbation_autorite_minicipale">
                </div>
            </div>

            <div class="form-group row text-center">
                <div class="col-sm-4 mx-auto">
                    <button type="submit"  style="width:150px;text-align:center;background-color:#C51B01;">تسجيل البيانات</button>
                </div>         
            </div>
        </div>   
    </form>
</div>

<script>
    const idTypeSelect = document.getElementById('id_type_identite');
    const identifiantInput = document.getElementById('identifiant');
    const verifierBtn = document.getElementById('verifierBtn');
    const sectionIdentite = document.getElementById('sectionIdentite');
    const nomPrenomInput = document.getElementById('nom_prenom');
    const identifiantAffiche = document.getElementById('identifiantAffiche');
    const mandoubiaInput = document.getElementById('mandoubia');
    const utilisateurIdInput = document.getElementById('utilisateur_id');
    const messageDiv = document.getElementById('message');
    idTypeSelect.addEventListener('change', function() {
        const type = this.value;
        if (type === "1") identifiantInput.placeholder = "ادخل رقم بطاقة التعريف الوطنية (CIN)";
        else if (type === "2") identifiantInput.placeholder = "ادخل رقم جواز السفر (Passport)";
        else if (type === "3") identifiantInput.placeholder = "ادخل الرقم التعريفي الجبائي (Num Fiscal)";
        else identifiantInput.placeholder = "ادخل رقم الهوية";
        identifiantInput.value = "";
        messageDiv.innerHTML = ''; 
    });
    verifierBtn.addEventListener('click', function() {
        const idType = idTypeSelect.value;
        const identifiant = identifiantInput.value;

        if (!idType || !identifiant) {
            messageDiv.innerHTML = '<div class="alert alert-warning">الرجاء اختيار نوع الهوية و إدخال الرقم</div>';
            sectionIdentite.classList.add('d-none');
            return;
        }
        fetch("<?php echo e(route('admin.debut_activite.verifier_identite')); ?>", {
            method: 'POST',
            headers: {
                'Content-Type':'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({ id_type_identite: idType, identifiant: identifiant, immobilier_id: "<?php echo e($immobilier_id); ?>" })
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                sectionIdentite.classList.remove('d-none');
                nomPrenomInput.value = data.user.nom_prenom;
                if (idType === "1") identifiantAffiche.value = data.user.cin ?? '';
                else if (idType === "2") identifiantAffiche.value = data.user.passport ?? '';
                else if (idType === "3") identifiantAffiche.value = data.user.num_fiscal ?? '';
                mandoubiaInput.value = data.immobilier?.gouvernorat_nom_ar ?? '';
                utilisateurIdInput.value = data.user.id;
                messageDiv.innerHTML = '<div class="alert alert-success">تم التحقق بنجاح</div>';
            } else {
                messageDiv.innerHTML = '<div class="alert alert-danger">رقم الهوية غير مطابق للمستخدم المحدد</div>';
                sectionIdentite.classList.add('d-none');
            }
        })
        .catch(err => {
            messageDiv.innerHTML = '<div class="alert alert-danger">حدث خطأ أثناء التحقق</div>';
            sectionIdentite.classList.add('d-none');
        });
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/investissement/gestion_salle_sport/debut_activite/create.blade.php ENDPATH**/ ?>