<?php $__env->startSection('content'); ?>

<?php if(Auth::check()): ?>
<style>
    .my-table table {
        font-size: 14px;
    }

    .my-table table th {
        font-size: 13px;
        white-space: nowrap;
    }

    .my-table table td {
        font-size: 13px;
        padding: 6px 8px;
    }

    /* ==== BADGE MODERNE ==== */
    .status-badge {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        padding: 6px 12px;
        font-size: 13px;
        border-radius: 8px;
        font-weight: 600;
        min-width: 75px;
        text-align: center;
        transition: 0.3s;
        box-shadow: 0 2px 6px rgba(0,0,0,0.05);
    }

    .status-badge--success {
        background-color: #e8f9ee;
        color: #27ae60;
    }
    .status-badge--danger {
        background-color: #fde8ea;
        color: #e74c3c;
    }
    .status-badge--pending {
        background-color: #fff8e1;
        color: #d4a017;
    }

    /* ==== ACTION BUTTONS ==== */
    .actions-cell {
        display: inline-flex;
        align-items: center;
        gap: 6px;
    }

    .btn-icon {
        width: 30px;
        height: 30px;
        border-radius: 6px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        border: none;
        cursor: pointer;
        background-color: #f8f9fa;
        font-size: 16px;
        transition: 0.2s;
    }

    .btn-icon:hover {
        transform: translateY(-1px);
        box-shadow: 0 2px 5px rgba(0,0,0,0.15);
    }

    /* couleurs */
    .btn-icon--primary {
        background-color: #e3f2fd;
        color: #0d6efd;
    }
    .btn-icon--danger {
        background-color: #f8d7da;
        color: #dc3545;
    }
</style>
<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0">
                <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
                   <h2 class="widget-title pb-0">قائمة الحجوزات</h2>
                </div>
                <?php if(session('success')): ?>
                    <div class="alert alert-success mt-2"><?php echo e(session('success')); ?></div>
                <?php endif; ?>

                <div class="block-card-body">
                    <div class="my-table table-responsive">
                        <table class="table align-items-center table-flush mb-0">
                            <thead class="thead-light">
                                <tr>
                                    <th width="5%">#</th>
                                    <th width="15%">إسم الحريف</th>
                                    <th width="15%">إسم المركب الشبابي</th>
                                    <th width="10%">تاريخ الحجز</th>
                                    <th width="10%">تاريخ الوصول</th>
                                    <th width="10%">تاريخ المغادرة</th>
                                    <th width="10%">السعر الإجمالي</th>
                                    <th width="15%">إجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $reservations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reserv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($reserv->reservation_id); ?></td>
                                        <td><?php echo e($reserv->utilisateur?->nom_prenom ?? '---'); ?></td>
                                        <td><?php echo e($reserv->auberge?->nom ?? '---'); ?></td>
                                        <td><?php echo e($reserv->date_reserv ?? '---'); ?></td>
                                        <td><?php echo e($reserv->date_arrive ?? '---'); ?></td>
                                        <td><?php echo e($reserv->date_depart ?? '---'); ?></td>
                                        <td><?php echo e($reserv->total_price ?? '---'); ?></td>
                                        <td class="text-center" style="white-space: nowrap;">
                                            <div class="d-flex justify-content-center align-items-center gap-1">
                                                <div class="actions-cell d-inline-flex gap-2">
                                                    <a href="<?php echo e(route('reservation.showArchive', $reserv->id)); ?>"
                                                        class="btn-icon btn-icon--primary"
                                                        title="عرض">
                                                        <i class="la la-eye"></i>
                                                    </a>

                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="9" class="text-center">لا يوجد حجز.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <?php echo e($reservations->links('pagination::bootstrap-5')); ?>

                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<div id="back-to-top">
    <i class="la la-arrow-up" title="Go top"></i>
</div>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<?php else: ?>
<script>
    window.location.href = "<?php echo e(route('admin')); ?>";
</script>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/auberges/reservation/archives.blade.php ENDPATH**/ ?>