

<?php $__env->startSection('content'); ?>


<?php if(Auth::check()): ?>
<div class="container-fluid dashboard-inner-body-container">
  <div class="row">
    <div class="col-lg-12">
      <div class="block-card dashboard-card mb-4 px-0">
        <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
          <h2 class="widget-title pb-0">المستخدمون</h2>
          <a class="btn btn-success font-weight-medium" href="<?php echo e(route('utilisateurs.create')); ?>">
            <i class="la la-plus mr-1"></i> إضافة مستخدم
          </a>
        </div>

<div class="block-card-header px-4 border-bottom-0 pb-0"> 
    <form method="GET" action="<?php echo e(route('utilisateurs.index')); ?>">
        <div class="form-row align-items-center">
            <div class="col-auto" style="width: 250px;">
                <select id="search-option" class="form-control" name="search_option" onchange="showSearchInput(this.value)">
                    <option value="">اختر</option>
                    <option value="cin" <?php echo e(request('search_option') == 'cin' ? 'selected' : ''); ?>>رقم بطاقة التعريف</option>
                    <option value="role" <?php echo e(request('search_option') == 'role' ? 'selected' : ''); ?>>فئة المستخدم</option>
                </select>
            </div>

            <div class="col" id="searchByCIN" style="display: none; width: 250px;">
                <input type="text" class="form-control" name="cin" placeholder="أدخل رقم بطاقة التعريف" value="<?php echo e(request('cin')); ?>">
            </div>

            <div class="col" id="searchByRole" style="display: none; width: 250px;">
                <select name="role_id" class="form-control">
                    <option value="">-- فئة المستخدم --</option>
                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($role->id_roles); ?>" <?php echo e(request('role_id') == $role->id_roles ? 'selected' : ''); ?>>
                            <?php echo e($role->nom_ar); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col d-flex">
                <button type="submit" class="btn bg-rgb-primary1 font-weight-medium" style="width: 105px;">بحث</button>
                <a href="<?php echo e(route('utilisateurs.index')); ?>" class="btn bg-rgb-primary1 font-weight-medium" style="width: 105px;">إعادة تعيين</a>
            </div>
        </div>
    </form>
</div>

         <div class="block-card-body">
          <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
              <?php echo e(session('success')); ?>

              <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
          <?php endif; ?>

          <div class="my-table table-responsive" style="direction: rtl; text-align: right;">
            <table class="table align-items-center table-flush mb-0 table-hover" style="direction: rtl; text-align: right;">
                <thead class="thead-light">
                    <tr>
                  <th width="5%">المعرف</th>
                  <th width="15%">الاسم</th>
                  <th width="15%">رقم بطاقة التعريف</th>
                  <th width="20%">البريد الإلكتروني</th>
                  <th width="15%">العنوان</th>
                  <th width="10%">الحالة</th>
                  <th width="10%">فئة المستخدم</th>
                  <th width="30%"></th>
                </tr>
              </thead>
              <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $utilisateurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                  <tr>
                    <td><?php echo e($u->id); ?></td>
                    <td><?php echo e($u->nom_prenom); ?></td>
                    <td><?php echo e($u->cin); ?></td>
                    <td><?php echo e($u->email); ?></td>
                    <td><?php echo e($u->adresse); ?></td>
                    <td>
                      <span class="status-badge  <?php echo e($u->est_active ? 'status-badge--success' : 'status-badge--danger'); ?>">
                        <?php echo e($u->est_active ? 'مفعل' : 'غير مفعل'); ?>

                      </span>
                    </td>
					
                    <td>
                     
                      <?php if($u->roles->isNotEmpty()): ?>
                          <span class="status-badge status-badge-info"><?php echo e($u->roles->first()->nom_ar); ?></span>
                      <?php else: ?>
                          <span class="status-badge status-badge-secondary">بدون دور</span>
                      <?php endif; ?>
                    </td>
                     <td class="text-center">
                            <div class="d-flex flex-wrap gap-2 justify-content-center">
                      <a class="btn-icon btn-icon--info" title="عرض" href="<?php echo e(route('utilisateurs.show', $u)); ?>">
                        <i class="la la-eye"></i> 
                      </a>

                      

                      <button type="button"
                        class="btn-icon btn-icon--warning" 
						onclick="window.location='<?php echo e(route('utilisateurs.edit', $u)); ?>'"
						
                          title="تعديل">
                          <i class="la la-edit"></i>
                      </button>

                      <form action="<?php echo e(route('utilisateurs.activation', $u)); ?>" method="POST" class="mr-2" style="display:inline;">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PATCH'); ?>
                        <button type="submit"    title="تغيير الحالة" aria-label="تغيير الحالة" class="btn btn-sm <?php echo e($u->est_active ? 'btn-outline-secondary' : 'btn-success-custom'); ?>">
                          <i class="la la-toggle-<?php echo e($u->est_active ? 'off' : 'on'); ?>"></i>
                         
                        </button>
						
                      </form>

                      <form action="<?php echo e(route('utilisateurs.destroy', $u->id)); ?>" 
                          method="POST" 
                          onsubmit="return confirm('هل تريد حقًا حذف هذه الاستمارة؟');">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="button" 
                                onclick="return confirmAction('هل تريد حقًا حذف هذا المستخدم؟', null, this.closest('form'))" 
                                  class="btn-icon btn-icon--danger"
                                          title="حذف">
                            <i class="la la-trash"> </i>
                        </button>
                    </form>
</div>
                    </td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                  <tr><td colspan="8" class="text-center">لا يوجد مستخدمون.</td></tr>
                <?php endif; ?>
              </tbody>
            </table>
          </div>

         
		  <div class="d-flex justify-content-between align-items-center mt-3">
                      <?php echo e($utilisateurs->links('pagination::bootstrap-5')); ?>

                    </div>
		  
        </div>

      </div>
    </div>
  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: 'تأكيد',
        text: message,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            if (url) {
                window.location.href = url;
            } else if (form) {
                form.submit();
            }
        }
    });
    return false;
}
</script>


<?php else: ?>
    <script>
        window.location.href = "<?php echo e(route('login')); ?>";
    </script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\DELL\Desktop\preprod mjs\back\resources\views/backoffice/role-permission/user/index.blade.php ENDPATH**/ ?>