<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<style>
body {
    font-family: DejaVu Sans;
    font-size: 12px;
    direction: rtl;
    text-align: right;
    color: #222;
    line-height: 1.6;
}

/* HEADER */
.header {
    border-bottom: 3px solid #c62828;
    margin-bottom: 20px;
    padding-bottom: 10px;
}
.header h1,h2,h3 {
    margin: 0;
    text-align: center;
}

/* SECTIONS */
.section {
    background-color: #ffffff;
    border: 1px solid #ddd;
    border-right: 5px solid #c62828;
    padding: 12px 14px;
    margin-bottom: 15px;
}

/* ROWS */
.row {
    display: flex;
    flex-wrap: wrap;
    margin-bottom: 8px;
}

.field {
    width: 48%;
    margin-bottom: 8px;
}

/* LABEL + VALUE */
.label {
    font-size: 11px;
    color: #555;
    margin-bottom: 2px;
    display: block;
}

.value {
    font-size: 12px;
    font-weight: 500;
    padding: 4px 0;
    border-bottom: 1px dotted #999;
    min-height: 18px;
}

/* TABLE */
table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 10px;
    font-size: 11.5px;
}
th {
    background-color: #f2f2f2;
    border: 1px solid #000;
    padding: 6px;
    font-weight: bold;
}
td {
    border: 1px solid #000;
    padding: 6px;
}

.page-break {
    page-break-before: always;
}
.no-break {
    page-break-inside: avoid;
}
</style>
</head>
<body>


<div class="header">
    <table width="100%" style="border:none;">
        <tr>
            <td style="width:120px; text-align:right; border:none;">
                <img src="<?php echo e(public_path('storage/logo.png')); ?>" style="width:90px;">
            </td>
            <td style="text-align:center; border:none;">
                <h1>الجمهورية التونسية</h1>
                <h2>وزارة الشباب و الرياضة</h2>
                <h3>طلب الإعفاء</h3>
            </td>
            <td style="width:120px; border:none;"></td>
        </tr>
    </table>
</div>


<div class="section row">
    <div class="field">
        <span class="label">وضعية الطلب</span>
        <span class="value">
            <?php if($document->id_statut == 1): ?> مقبول
            <?php elseif($document->id_statut == 3): ?> مرفوض
            <?php elseif($document->id_statut == 4): ?> قبول مشروط
            <?php else: ?> في الانتظار
            <?php endif; ?>
        </span>
    </div>
</div>


<h4>هوية الباعث</h4>
<div class="section row">
    <div class="field">
        <span class="label">الاسم</span>
        <span class="value"><?php echo e($document->utilisateur->nom_prenom ?? '-'); ?></span>
    </div>
    <div class="field">
        <span class="label">الهاتف</span>
        <span class="value"><?php echo e($document->utilisateur->tel ?? '-'); ?></span>
    </div>
    <div class="field">
        <span class="label">البريد الإلكتروني</span>
        <span class="value"><?php echo e($document->utilisateur->email ?? '-'); ?></span>
    </div>
</div>


<h4>المشروع</h4>
<div class="section row">
    <div class="field">
        <span class="label">اسم المشروع</span>
        <span class="value"><?php echo e($document->nom_projet ?? '-'); ?></span>
    </div>
    <div class="field">
        <span class="label">عنوان المشروع</span>
        <span class="value"><?php echo e($document->adresse_projet ?? '-'); ?></span>
    </div>
</div>

<!--h4><?php echo e(__('site.exoneration.documents.title')); ?></h4>
<div class="section">
    <?php
        $files = [
            'copie_cahier_des_charges',
            'copie_originale',
            'facture',
            'contrat',
            'fichier_arrivage',
            'fichier_colisage',
            'copie_registre_fiscal',
            'copie_registre_national_institutions',
            'copie_certificat_propriete',
            'engagement',
            'exemple_projet'
        ];
    ?>

    <table>
        <thead>
            <tr>
                <th>الوثيقة</th>
                <th>عرض الملف</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e(__('site.exoneration_label.documents.labels.' . $file)); ?></td>
                <td>
                    <?php if(!empty($document->$file)): ?>
                        <a href="<?php echo e(url(route('exoneration.pdf', [$document->id_doc, $file], false))); ?>">عرض الملف</a>
                    <?php else: ?>
                        -
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div-->

</body>
</html>
<?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/investissement/gestion_exoneration/pdf.blade.php ENDPATH**/ ?>