<!doctype html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>إشعار بخصوص الاستثمار في المؤسسات الخاصة بالشباب والأطفال</title>
</head>
<body>
    <div class="email-wrapper" style="font-family: Arial, sans-serif; direction: rtl; text-align: right; max-width: 600px; margin: 20px auto; border: 1px solid #ddd; padding: 20px; border-radius: 10px;">

        <div class="header" style="font-size: 20px; font-weight: bold; margin-bottom: 20px; text-align: center;">
            إشعار حول طلب الاستثمار في المؤسسات الخاصة بالشباب والأطفال
        </div>

        <div class="content" style="line-height: 1.6; color: #222;">

            @if(isset($type) && $type === 'accepted')
                <p>مرحباً <strong>{{ $user->nom_prenom ?? 'مستخدم' }}</strong>،</p>
                <p>
                    يسرّنا إعلامكم بأنه تمت <strong>الموافقة</strong> على مشروعكم المتعلق
                    <strong>بالإستثمار في المؤسسات الخاصة بالشباب والأطفال</strong>.
                </p>
                <p>
                    نتمنى لكم التوفيق والنجاح في إنجاز مشروعكم.
                </p>

            @elseif(isset($type) && $type === 'rejected')
                <p>مرحباً <strong>{{ $user->nom_prenom ?? 'مستخدم' }}</strong>،</p>
                <p>
                    نأسف لإعلامكم بأنه تم <strong>رفض</strong> طلبكم المتعلق
                    <strong>بالإستثمار في المؤسسات الخاصة بالشباب والأطفال</strong>.
                </p>
                @if(!empty($motif))
                    <p><strong>سبب الرفض:</strong> {{ $motif }}</p>
                @endif

            @elseif(isset($type) && $type === 'incomplete')
                <p>مرحباً <strong>{{ $user->nom_prenom ?? 'مستخدم' }}</strong>،</p>
                <p>
                    نعلمكم أن طلبكم المتعلق
                    <strong>بالإستثمار في المؤسسات الخاصة بالشباب والأطفال</strong>
                    مصنّف كـ <strong>ملف غير مكتمل</strong>.
                </p>
                <p>يرجى استكمال الوثائق أو المعطيات التالية:</p>
                @if(!empty($motif))
                    <div style="margin-top:10px;">{{ $motif }}</div>
                @endif

            @elseif(isset($type) && $type === 'deferred')
                <p>مرحباً <strong>{{ $user->nom_prenom ?? 'مستخدم' }}</strong>،</p>
                <p>
                    نعلمكم أنه تم <strong>إرجاء البتّ</strong> في طلبكم المتعلق
                    <strong>بالإستثمار في المؤسسات الخاصة بالشباب والأطفال</strong>
                    لمزيد من الدراسة.
                </p>
                @if(!empty($motif))
                    <p><strong>ملاحظة:</strong><br>{{ $motif }}</p>
                @endif

            @else
                <p>
                    تم تحديث حالة طلبكم المتعلق
                    <strong>بالإستثمار في المؤسسات الخاصة بالشباب والأطفال</strong>.
                    يرجى التحقق من حسابكم للاطلاع على مزيد من التفاصيل.
                </p>
            @endif

        <p style="margin-top: 20px;">
                نشكركم على تعاونكم واهتمامكم.<br>
            </p>
        </div>

        <hr style="margin: 20px 0; border: none; border-top: 1px solid #eee;">

        <div class="footer" style="text-align: center; font-size: 12px; color: #555;">
            <div class="app-name">وزارة الشباب والرياضة</div>
        </div>
    </div>
</body>
</html>
