@extends('backoffice.dashboard')

@section('title', 'قائمة الأخبار')

@section('content')

@if(Auth::check())
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0 shadow-sm rounded-3 border-0">       
				<div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
                    <h2 class="widget-title m-0"> قائمة التتويجات الرياضية</h2>
                    <a class="btn btn-success btn-sm px-3" href="{{ route('trophee_sportif.create') }}">
                        <i class="la la-plus me-1"></i> إضافة تتويج رياضي
                    </a>
                </div>
				<div class="block-card-header px-4 border-bottom-0 pb-3">
					<form method="GET" action="{{ route('trophee_sportif.index') }}">
						<div class="form-row align-items-center" style="direction: rtl;">
							<div class="col-auto" style="width: 250px;">
								<input 
									type="text" 
									class="form-control" 
									name="search" 
									placeholder="بحث بالعربية أو الإنجليزية أو الفرنسية" 
									value="{{ request('search') }}"
								>
							</div>

							<div class="col d-flex">
								<button type="submit" class="btn bg-rgb-primary1 font-weight-medium" style="width: 105px;">
									بحث
								</button>
								<a href="{{ route('trophee_sportif.index') }}"
								   class="btn bg-rgb-primary1 font-weight-medium d-flex align-items-center justify-content-center"
								   style="width: 45px; height: 38px; margin-right: 5px; padding: 0;">
									<i class="fa-solid fa-rotate-right"></i>
								</a>
							</div>
						</div>
					</form>
				</div>

								   <div class="block-card-body">          
				   @if(session('success'))            
					   <div class="alert alert-success alert-dismissible fade show" role="alert">        
                              {{ session('success') }}             
                               <button type="button" class="btn-close" data-bs-dismiss="alert"></button>      
                                  </div>          
                                  @endif         
                        <div class="my-table table-responsive" style="direction: rtl; text-align: right;">        
                        <table class="table align-items-center table-flush mb-0 table-hover" style="direction: rtl; text-align: right;">           
                                   <thead class="thead-light">          
                                 <tr>                     
                                   <th>المعرف</th>
                                    <th style="width: 25%">تمت الإضافة بواسطة</th>
                                    <th style="width: 25%">العنوان</th>
                                    <th style="width: 20%">الصورة / YouTube</th>
                                    <th style="width: 10%">منشور</th>
                                    <th style="width: 15%">التاريخ</th>
                                    <th style="width: 20%">الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($trophee_sportif as $item)
                                    <tr>
                                        <td>{{ $item->id_sport }}</td>
                                        <td>{{ $item->utilisateur ? $item->utilisateur->nom_prenom : 'غير محدد' }}</td>
                                        <td class="text-end">
                                            <p
                                               class="text-decoration-none text-primary fw-bold" 
                                               style="direction: ltr; display: inline-block;">
                                                {{ $item->title }}
                                            </p>
                                        </td>

                                       <td>
    @if(!empty($item->imageSrc))
        <img src="{{ $item->imageSrc }}"
            alt="صورة الخبر"
            class="rounded shadow-sm border"
            style="width: 80px; height: 60px; object-fit: cover;">
    @elseif($item->youtube_url)
        @php
            if (preg_match('/(youtu\.be\/|v=)([A-Za-z0-9_\-]+)/', $item->youtube_url, $m)) {
                $youtubeId = $m[2];
            } else {
                $youtubeId = null;
            }
        @endphp

        @if($youtubeId)
            <a href="https://www.youtube.com/watch?v={{ $youtubeId }}" target="_blank">
                <img src="https://img.youtube.com/vi/{{ $youtubeId }}/hqdefault.jpg"
                    alt="معاينة الفيديو"
                    class="rounded shadow-sm border"
                    style="width: 80px; height: 60px; object-fit: cover;">
            </a>
        @else
            <span class="badge bg-danger"><i class="la la-youtube"></i> YouTube</span>
        @endif
    @else
        {{-- Aucun média --}}
        <span class="text-muted">—</span>
    @endif
</td>



                                        <td>
                                            <span class="status-badge 
                                                {{ $item->published ? 'status-badge--success' : 'status-badge--danger' }}">
                                                {{ $item->published ? 'نعم' : 'لا' }}
                                            </span>
                                        </td>


                                        <td>{{ $item->date }}</td>

                                        <td>
                                            <div class="d-flex justify-content-center gap-2">
                                                <button type="button"
                                                          class="btn-icon btn-icon--warning"
														  onclick="window.location='{{ route('trophee_sportif.edit', $item) }}'"
                                                        
                                                        title="تعديل">
                                                    <i class="la la-edit"></i>
                                                </button>

                                                <form action="{{ route('trophee_sportif.destroy', $item) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="button"
                                                            onclick="return confirmAction('هل تريد حذف هذا التتويج الرياضي', null, this.closest('form'))"
                                                            class="btn-icon btn-icon--danger"                                                            title="حذف">
                                                        <i class="la la-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="py-4 text-muted">لا توجد أخبار حالياً.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                 
					 {{-- Pagination --}}
                  					 <div class="d-flex justify-content-between align-items-center mt-3">
                      {{ $trophee_sportif->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- ======= SweetAlert Confirm ======= --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: 'تأكيد',
        text: message,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            if (url) {
                window.location.href = url;
            } else if (form) {
                form.submit();
            }
        }
    });
    return false;
}
</script>

<style>
.table-trophee_sportif th, 
.table-trophee_sportif td {
    vertical-align: middle;
    text-align: center;
}

.table-trophee_sportif th:nth-child(2),
.table-trophee_sportif td:nth-child(2) {
    text-align: right !important;
    direction: rtl;
}

.status-badge {
    display: inline-block;
    padding: 6px 12px;
    border-radius: 12px;
    font-size: 14px;
    font-weight: 600;
    color: #fff;
    min-width: 60px;
    text-align: center;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.status-badge--success {
    background-color: #e8f9ee; 
    color: #27ae60;           
}

.status-badge--danger {
    background-color: #fde8ea; 
    color: #e74c3c;            
}


</style>

@else
<script>window.location.href = "{{ route('admin') }}";</script>
@endif

@endsection
