@extends('backoffice.dashboard')

@section('content')

@if(Auth::check())
<section class="add-listing-area section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">
                <div class="block-card mb-4">
                    <div class="block-card-header">
                        <h2 class="widget-title">عرض المستخدم</h2>
                    </div>

                    <div class="card-body">

                        <div class="input-box mb-3">
                            <label class="label-text">الاسم و اللقب</label>
                            <input type="text" class="form-control pl-3 bg-white" value="{{ $utilisateur->nom_prenom }}" readonly>
                        </div>

                        <div class="input-box mb-3">
                            <label class="label-text">رقم بطاقة التعريف</label>
                            <input type="text" class="form-control pl-3 bg-white" value="{{ $utilisateur->cin }}" readonly>
                        </div>

                        <div class="input-box mb-3">
                            <label class="label-text">البريد الإلكتروني</label>
                            <input type="email" class="form-control pl-3 bg-white" value="{{ $utilisateur->email }}" readonly>
                        </div>

                        <div class="input-box mb-3">
                            <label class="label-text">الهاتف</label>
                            <input type="text" class="form-control pl-3 bg-white" value="{{ $utilisateur->tel }}" readonly>
                        </div>

                        <div class="input-box mb-3">
                            <label class="label-text">العنوان</label>
                            <input type="text" class="form-control pl-3 bg-white" value="{{ $utilisateur->adresse }}" readonly>
                        </div>

                        

                        <div class="input-box mb-3">
                            <label class="label-text">فئة المستخدم</label>
                            <select class="form-control bg-white" disabled>
                                <option>
                                    {{ $utilisateur->roles->pluck('nom_ar')->first() ?? '-- غير محدد --' }}
                                </option>
                            </select>
                        </div>
						<div class="input-box mb-3" id="aubergeBox" style="display: none;">
							<label class="label-text">المراكز</label>
							<select class="form-control bg-white" disabled>
								<option>
									{{ $utilisateur->auberge->nom_ar ?? '-- غير مرتبط بأي مركز --' }}
								</option>
							</select>
						</div>

						<div class="input-box mb-3" id="gouvBox" style="display: none;">
							<label class="label-text">الولاية</label>
							<select class="form-control bg-white" disabled>
								<option>
									{{ $utilisateur->gouvernorat->nom_ar ?? '-- غير مرتبط بأي ولاية --' }}
								</option>
							</select>
						</div>


                        <a href="{{ route('utilisateurs.index') }}" class="btn bg-rgb-primary1 font-weight-medium mt-3">
                            <i class="la la-arrow-left mr-1"></i> رجوع
                        </a>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!--script>
    document.addEventListener('DOMContentLoaded', function () {
        let roleId = {{ $utilisateur->roles->pluck('id_roles')->first() ?? 'null' }};

        if (roleId == 7) {
            document.getElementById('aubergeBox').style.display = 'block';
        }
    });
</script-->
<script>
	document.addEventListener('DOMContentLoaded', function () {
		let roleId = {{ $utilisateur->roles->pluck('id_roles')->first() ?? 'null' }};

		if (roleId == 7) {
			document.getElementById('aubergeBox').style.display = 'block';
		}

		if (roleId == 8) {
			document.getElementById('gouvBox').style.display = 'block';
		}
	});
</script>

@else
    <script>
        window.location.href = "{{ route('admin') }}";
    </script>
@endif
@endsection
