@extends('backoffice.dashboard')

@section('content')


@if(Auth::check())
<div class="container-fluid dashboard-inner-body-container">
  <div class="row">
    <div class="col-lg-12">
      <div class="block-card dashboard-card mb-4 px-0">
        <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
          <h2 class="widget-title pb-0">المستخدمون</h2>
          <a class="btn btn-success font-weight-medium" href="{{ route('utilisateurs.create') }}">
            <i class="la la-plus mr-1"></i> إضافة مستخدم
          </a>
        </div>

<div class="block-card-header px-4 border-bottom-0 pb-0"> 
    <form method="GET" action="{{ route('utilisateurs.index') }}">
        <div class="form-row align-items-center">
            <div class="col-auto" style="width: 250px;">
                <select id="search-option" class="form-control" name="search_option" onchange="showSearchInput(this.value)">
                    <option value="">اختر</option>
                    <option value="cin" {{ request('search_option') == 'cin' ? 'selected' : '' }}>رقم بطاقة التعريف</option>
                    <option value="role" {{ request('search_option') == 'role' ? 'selected' : '' }}>فئة المستخدم</option>
                </select>
            </div>

            <div class="col" id="searchByCIN" style="display: none; width: 250px;">
                <input type="text" class="form-control" name="cin" placeholder="أدخل رقم بطاقة التعريف" value="{{ request('cin') }}">
            </div>

            <div class="col" id="searchByRole" style="display: none; width: 250px;">
                <select name="role_id" class="form-control">
                    <option value="">-- فئة المستخدم --</option>
                    @foreach($roles as $role)
                        <option value="{{ $role->id_roles }}" {{ request('role_id') == $role->id_roles ? 'selected' : '' }}>
                            {{ $role->nom_ar }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="col d-flex">
                <button type="submit" class="btn bg-rgb-primary1 font-weight-medium" style="width: 105px;">بحث</button>
                <a href="{{ route('utilisateurs.index') }}" class="btn bg-rgb-primary1 font-weight-medium" style="width: 105px;">إعادة تعيين</a>
            </div>
        </div>
    </form>
</div>

         <div class="block-card-body">
          @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
              {{ session('success') }}
              <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
          @endif

          <div class="my-table table-responsive" style="direction: rtl; text-align: right;">
            <table class="table align-items-center table-flush mb-0 table-hover" style="direction: rtl; text-align: right;">
                <thead class="thead-light">
                    <tr>
                  
                  <th width="15%">الاسم</th>
                  
                  <th width="20%">البريد الإلكتروني</th>
                  <th width="10%">فئة المستخدم</th>
                  <th width="10%">الحالة</th>
                  
                  <th width="30%"></th>
                </tr>
              </thead>
              <tbody>
                @forelse($utilisateurs as $u)
                  <tr>
                    <td>{{ $u->nom_prenom }}</td>
                    <td>{{ $u->email }}</td>
                    <td>
                     
                      @if($u->roles->isNotEmpty())
                          <span class="status-badge status-badge-info">{{ $u->roles->first()->nom_ar }}</span>
                      @else
                          <span class="status-badge status-badge-secondary">بدون دور</span>
                      @endif
                    </td>
                    <td>
                      <span class="status-badge  {{ $u->est_active ? 'status-badge--success' : 'status-badge--danger' }}">
                        {{ $u->est_active ? 'مفعل' : 'غير مفعل' }}
                      </span>
                    </td>
					
                    
                     <td class="text-center">
                            <div class="d-flex flex-wrap gap-2 justify-content-center">
                      <a class="btn-icon btn-icon--info" title="عرض" href="{{ route('utilisateurs.show', $u) }}">
                        <i class="la la-eye"></i> 
                      </a>

                      

                      <button type="button"
                        class="btn-icon btn-icon--warning" 
						onclick="window.location='{{ route('utilisateurs.edit', $u) }}'"
						
                          title="تعديل">
                          <i class="la la-edit"></i>
                      </button>

                      <form action="{{ route('utilisateurs.activation', $u) }}" method="POST" class="mr-2" style="display:inline;">
                        @csrf
                        @method('PATCH')
                        <button type="submit"    title="تغيير الحالة" aria-label="تغيير الحالة" class="btn btn-sm {{ $u->est_active ? 'btn-outline-secondary' : 'btn-success-custom' }}">
                          <i class="la la-toggle-{{ $u->est_active ? 'off' : 'on' }}"></i>
                         
                        </button>
						
                      </form>

                      <form action="{{ route('utilisateurs.destroy', $u->id) }}" 
                          method="POST" 
                          onsubmit="return confirm('هل تريد حقًا حذف هذه الاستمارة؟');">
                        @csrf
                        @method('DELETE')
                        <button type="button" 
                                onclick="return confirmAction('هل تريد حقًا حذف هذا المستخدم؟', null, this.closest('form'))" 
                                  class="btn-icon btn-icon--danger"
                                          title="حذف">
                            <i class="la la-trash"> </i>
                        </button>
                    </form>
</div>
                    </td>
                  </tr>
                @empty
                  <tr><td colspan="8" class="text-center">لا يوجد مستخدمون.</td></tr>
                @endforelse
              </tbody>
            </table>
          </div>

         
		  <div class="d-flex justify-content-between align-items-center mt-3">
                      {{ $utilisateurs->links('pagination::bootstrap-5') }}
                    </div>
		  
        </div>

      </div>
    </div>
  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: 'تأكيد',
        text: message,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            if (url) {
                window.location.href = url;
            } else if (form) {
                form.submit();
            }
        }
    });
    return false;
}
</script>


@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
@endsection
