@extends('backoffice.dashboard')

@section('content')

@if(Auth::check())
<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0">
                <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
                    <h2 class="widget-title pb-0"> الأدوار </h2>
                    <a class="btn btn-success font-weight-medium" href="{{ route('roles.create') }}">
                        <i class="la la-plus mr-1"> إضافة دور</i>
                    </a>
                </div>

               <div class="block-card-body">
          @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
              {{ session('success') }}
              <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
          @endif

          <div class="my-table table-responsive" style="direction: rtl; text-align: right;">
            <table class="table align-items-center table-flush mb-0 table-hover" style="direction: rtl; text-align: right;">
                <thead class="thead-light">
                    <tr>
                                    <th width="30%">المعرف</th>
                                    <th width="40%">الاسم (ar)</th>
                                    <th width="40%">إجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($roles as $role)
                                    <tr>
                                        <td>{{ $role->id_roles }}</td>
                                        <td>{{ $role->nom_ar }}</td>
   <td class="text-center">
                            <div class="d-flex flex-wrap gap-2 justify-content-center">
                                         
                                              <a href="{{ route('roles.edit', $role->id_roles) }}"
												class="btn-icon btn-icon--warning" title="تعديل">
												  <i class="la la-edit"></i> 
											  </a>
                                            <a class="btn-icon btn-icon--secondary"
                                            href="{{ route('admin.roles.permissions.edit', $role->id_roles) }}"   title="الصلاحيات">
                                                <i class="la la-key"> </i>
                                            </a>

                                            <form action="{{ route('roles.destroy', $role->id_roles) }}"
                                                method="POST"
                                                style="display:inline;">
                                                @csrf
                                                @method('DELETE')
                                               
												  <button type="submit"
                                          class="btn-icon btn-icon--danger"
                                          title="حذف"
                                          onclick="return confirmAction('هل تريد حقًا حذف هذا الدور ؟', null, this.closest('form'))">
                                          <i class="la la-trash"></i> 
                                      </button>
                                            </form>
</div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="3" class="text-center">لا يوجد أدوار.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    {{-- pagination --}}
                   
					<div class="d-flex justify-content-between align-items-center mt-3">
                      {{ $roles->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="back-to-top">
    <i class="la la-arrow-up" title="Go top"></i>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: 'تأكيد',
        text: message,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            if (url) {
                window.location.href = url;
            } else if (form) {
                form.submit();
            }
        }
    });
    return false;
}
</script>
@else
    <script>
        window.location.href = "{{ route('admin') }}";
    </script>
@endif
@endsection
