@extends('backoffice.dashboard')

@section('content') 

@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif

@if(Auth::check())
<section class="add-listing-area section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">                
                <form action="{{ route('roles.update', $role->id_roles) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="block-card mb-4">
                        <div class="block-card-header">
                            <h2 class="widget-title">تعديل الدور</h2>
                            <div class="stroke-shape"></div>
                        </div>

                        <div class="block-card-body">
                            <div class="form-group">
                                <label for="nom_ar" class="label-text">الاسم (عربي)</label>
                                <input type="text" 
                                       class="form-control pl-3 @error('nom_ar') is-invalid @enderror" 
                                       id="nom_ar" 
                                       name="nom_ar" 
                                       value="{{ old('nom_ar', $role->nom_ar) }}" 
                                       required>
                                @error('nom_ar')
                                    <span class="invalid-feedback"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="nom_fr" class="label-text">الاسم (Fr)</label>
                                <input type="text" 
                                       class="form-control pl-3 @error('nom_fr') is-invalid @enderror" 
                                       id="nom_fr" 
                                       name="nom_fr" 
                                       value="{{ old('nom_fr', $role->nom_fr) }}">
                                @error('nom_fr')
                                    <span class="invalid-feedback"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="nom_en" class="label-text">الاسم (En)</label>
                                <input type="text" 
                                       class="form-control pl-3 @error('nom_en') is-invalid @enderror" 
                                       id="nom_en" 
                                       name="nom_en" 
                                       value="{{ old('nom_en', $role->nom_en) }}">
                                @error('nom_en')
                                    <span class="invalid-feedback"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="guard_name" class="label-text">Guard Name</label>
                                <input type="text" 
                                       class="form-control pl-3 @error('guard_name') is-invalid @enderror" 
                                       id="guard_name" 
                                       name="guard_name" 
                                       value="{{ old('guard_name', $role->guard_name ?? 'web') }}">
                                @error('guard_name')
                                    <span class="invalid-feedback"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>
                        </div>

                        <div class="block-card-footer d-flex justify-content-start px-3 pb-3">
                            <button type="submit" class="btn bg-rgb-primary1 font-weight-medium mr-2"> 
                                <i class="la la-save mr-1"></i> حفظ
                            </button>                    
                            <a href="{{ route('roles.index') }}" class="btn bg-rgb-primary1 font-weight-medium">
                                <i class="la la-times mr-1"></i> الغاء
                            </a>
                        </div>
                    </div>
                </form>                
            </div>
        </div>
    </div>
</section>
@else
    <script>
        window.location.href = "{{ route('admin') }}";
    </script>
@endif
@endsection
