@extends('backoffice.dashboard')

@section('content')

@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif

@if(Auth::check())
<section class="add-listing-area section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">
                <form action="{{ route('admin.roles.permissions.update', $role->id_roles) }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="block-card mb-4">
                        <div class="block-card-header">
                            <h2 class="widget-title">صلاحيات الدور: {{ $role->nom_ar }}</h2>
                            <div class="stroke-shape"></div>
                        </div>

                        <div class="block-card-body">
                            <div class="form-group row">
                                @foreach($permissions as $perm)
                                    <div class="col-md-6 mb-2">
                                        <div class="form-check">
                                            <input class="form-check-input"
                                                   type="checkbox"
                                                   name="permissions[]"
                                                   value="{{ $perm->id_perm }}"
                                                   id="perm{{ $perm->id_perm }}"
                                                   {{ in_array($perm->id_perm, $rolePermissions) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="perm{{ $perm->id_perm }}">
                                                {{ $perm->nom_ar }}
                                            </label>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>

                        <div class="block-card-footer d-flex justify-content-start px-3 pb-3">
                            <button type="submit" class="btn bg-rgb-primary1 font-weight-medium mr-2">
                                <i class="la la-save mr-1"></i> حفظ الصلاحيات
                            </button>
                            <a href="{{ route('roles.index') }}" class="btn bg-rgb-primary1 font-weight-medium">
                                <i class="la la-times mr-1"></i> إلغاء
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>
@else
    <script>
        window.location.href = "{{ route('admin') }}";
    </script>
@endif
@endsection
