<!DOCTYPE html>
<html lang="{{ $lang }}" dir="{{ $direction }}">
<head>
<meta charset="utf-8">

<style>
body {
    font-family: DejaVu Sans;
    font-size: 12px;
    direction: {{ $direction }};
    text-align: {{ $direction == 'rtl' ? 'right' : 'left' }};
    color: #222;
    line-height: 1.6;
}

/* HEADER */
.header {
    border-bottom: 3px solid #c62828;
    margin-bottom: 20px;
    padding-bottom: 10px;
}

.header h3 {
    margin: 0;
    font-size: 17px;
    font-weight: bold;
}

/* TITRES */
h4 {
    margin: 25px 0 8px;
    padding-bottom: 4px;
    font-size: 14px;
    border-bottom: 2px solid #c62828;
    color: #000;
}

/* SECTIONS */
.section {
    background-color: #ffffff;
    border: 1px solid #ddd;
    border-{{ $direction == 'rtl' ? 'right' : 'left' }}: 5px solid #c62828;
    padding: 12px 14px;
    margin-bottom: 15px;
}

/* ROWS */
.row {
    display: flex;
    flex-wrap: wrap;
    margin-bottom: 8px;
}

.field {
    width: 48%;
    margin-bottom: 8px;
}

/* LABEL + VALUE */
.label {
    font-size: 11px;
    color: #555;
    margin-bottom: 2px;
}

.value {
    font-size: 12px;
    font-weight: 500;
    padding: 4px 0;
    border-bottom: 1px dotted #999;
    min-height: 18px;
}

/* TABLE */
table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 10px;
    font-size: 11.5px;
}

th {
    background-color: #f2f2f2;
    border: 1px solid #000;
    padding: 6px;
    font-weight: bold;
}

td {
    border: 1px solid #000;
    padding: 6px;
}

/* REMARQUES */
.remarks-block {
    margin-top: 10px;
    padding: 10px;
    border: 1.5px solid #000;
    min-height: 70px;
}
</style>
</head>

<body>

<div class="header">
    <table width="100%" style="border: none;">
        <tr>
            <td style="width:80px; text-align:right; border:none;">
                <img src="{{ public_path('storage/logo.png') }}" style="width:70px; height:auto;">
            </td>
            <td style="text-align:center; border:none;">
                <h3>مطلب في تنظيم أشخاص طبيعيين أو معنويين لتظاهرة رياضية وطنية بالبلاد التونسية</h3>
            </td>
            <td style="width:120px; border:none;"></td>
        </tr>
    </table>
</div>


<h4>جذاذة تعريفية بالأشخاص الطبيعيين أو المعنويين غير الهياكل الرياضية</h4> <div class="section"> <div class="row"> 
    <div class="field"> 
        <span class="label">اسم الهيكل غير الرياضي</span> 
    <span class="value">{{ old('org.nom', $org->nom ?? '') }}</span> </div> <div class="field"> 
        <span class="label">عدد التاشيرة</span>
         <span class="value">{{ $org->num_visa ?? '' }}</span> </div> <div class="field">
             <span class="label">تاريخ التسجيل س.و.م</span>
             <span class="value">{{ $org->date_enregistrement ?? '' }}</span> 
            </div> <div class="field"> <span class="label">المعرف الجبائي</span> 
            <span class="value">{{ $org->identifiant_fiscal ?? '' }}</span> </div> <div class="field">
                
            <span class="label">رقم الحساب البنكي</span> 
            <span class="value">{{ $org->num_compte_bancaire ?? '' }}</span> </div> <div class="field">
                 <span class="label">العنوان</span> 
                 <span class="value">{{ $org->adresse ?? '' }}</span> </div> <div class="field">
                     <span class="label">رقم الهاتف</span> 
                     <span class="value">{{ $org->tel ?? '' }}</span> </div> <div class="field"> 
                        <span class="label">رقم الفاكس</span>
                         <span class="value">{{ $org->fax ?? '' }}</span> </div> </div> </div>

<h4 style="margin-top:30px;">
    ملف التامين الخاص
</h4>

<div class="section">
    <div class="row">

        <div class="field">
            <span class="label">
                نسخة من ملف التأمين الخاص بالتظاهرة الرياضية
            </span>

            
        </div>

        @if($demande->assuranceFile)
                            <p>
                                الملف الحالي :
                                <a href="{{ route('manifestation.attachment.show', $demande->assuranceFile->id_attach) }}"
                                target="_blank">
                                    عرض الملف
                                </a>
                            </p>
                        @else
                            <p class="text-muted">لا يوجد</p>
                        @endif

    </div>
</div>
 @php
            $evenement = $demande->evenementSportifs->first(); // On prend le premier événement lié
        @endphp

    <input type="hidden" name="id_formulaire" value="{{ $formulaire3->id_type }}">

     <h4 style="margin-top:30px;">
   
   {{ $formulaire3->type_ar }}
</h4>
          <br>
<div class="section">
    <div class="row">
        <div class="field">
            <span class="label">
               اسم التظاهرة
            </span>

            <span class="value">
                {{ $evenement->nom_even ?? '' }}
            </span>
        </div>

        <div class="field">
            <span class="label">
              الهدف من تنظيم التظاهرة و آثارها الرياضية و الأبعاد الاقتصادية والاجتماعية: 
            </span>

            <span class="value">
                {{ old('objectifs', $evenement->objectifs ?? '') }}
            </span>
        </div>

        <div class="field">
            <span class="label">
             محتوى التظاهرة و الاختصاصات الرياضية المستهدفة : 
            </span>

            <span class="value">
                {{ old('contenus', $evenement->contenus ?? '') }}
            </span>
        </div>
		
		<div class="field">
            <span class="label">
              تاريخ تنظيم التظاهرة : 
            </span>

            <span class="value">
                {{ $evenement->date ?? '' }}
            </span>
        </div>
		
		<div class="field">
            <span class="label">
              
توقيت تنظيم التظاهرة : 
            </span>

            <span class="value">
                {{ isset($evenement->heure) ? \Carbon\Carbon::parse($evenement->heure)->format('H:i') : '' }}
            </span>
        </div>
		
		<div class="field">
            <span class="label">
              الولاية
            </span>

            <span class="value">
                {{ optional($gouvernorats->firstWhere('id_gouver', $evenement->gouvernorat_id))->nom_ar ?? '' }}
            </span>
        </div>
		
		<div class="field">
            <span class="label">
             البلدية
            </span>

            <span class="value">
               {{ optional($delegations->firstWhere('id_delegation', $evenement->delegation_id))->nom_ar ?? '' }}
            </span>
        </div>
		
		<div class="field">
            <span class="label">
              المنشئات الرياضية التي ستستغل : 
            </span>

            <span class="value">
                {{ old('instalation_sportives', $evenement->instalation_sportives ?? '') }}
            </span>
        </div>
		
		<div class="field">
            <span class="label">
              الجامعة الرياضية مرجع الاختصاص : 
            </span>

            <span class="value">
                {{ $evenement->reference ?? '' }}
            </span>
        </div>
		
		<div class="field">
            <span class="label">
              المداخيل التقديرية الجملية : 
            </span>

            <span class="value">
                {{ $evenement->estimation_evenement ?? '' }}
            </span>
        </div>
		
		<div class="field">
            <span class="label">
             
المصاريف التقديرية الجملية :
            </span>

            <span class="value">
                {{ $evenement->cout_total_evenement ?? '' }}
            </span>
        </div>
		
		<div class="field">
            <span class="label">
             الفارق التقديري : 
            </span>

            <span class="value">
                {{ $evenement->difference_estimee ?? '' }}
            </span>
        </div>
		
		<div class="field">
            <span class="label">
             بيان الجوائز : 
            </span>

            <span class="value">
                {{ $evenement->recompense ?? '' }}
            </span>
        </div>
		<input type="hidden" name="user_id" value="{{ Auth::user()->id }}">
    </div>
</div>
<input type="hidden" name="id_formulaire" value="{{ $formulaire4->id_type }}">
           
<h4 style="margin-top:30px;">
  {{ $formulaire4->type_ar }}
</h4>
          <br>



<div class="section">
    <div class="section-title">
    قائمة عناصر فريق التنظيم 
    </div>

    @php
        $membres = $evenement && $evenement->membres
            ? $evenement->membres->where('type_membre_id', 1)
            : collect();
    @endphp

    <table>
        <thead>
            <tr>
                <th>الاسم واللقب</th>
                <th>الصفة</th>
                <th>الجنسية</th>
            </tr>
        </thead>
        <tbody>
            @if($membres->count())
                @foreach($membres as $membre)
                    <tr>
                        <td>{{ $membre->nom_prenom ?? '-' }}</td>
                        <td>{{ $membre->role ?? '-' }}</td>
                        <td>{{ $membre->nationalite ?? '-' }}</td>
                    </tr>
                @endforeach
            @else
                <tr>
                    <td>-</td>
                    <td>-</td>
                    <td>-</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>


<div class="section">
    <div class="section-title">
        الشخصيات الرسمية المدعوة
    </div>

    @php
        $invites = $evenement && $evenement->membres
            ? $evenement->membres->where('type_membre_id', 2)
            : collect();
    @endphp

    <table>
        <thead>
            <tr>
                <th>الاسم واللقب</th>
                <th>الصفة</th>
                <th>الجنسية</th>
            </tr>
        </thead>
        <tbody>
            @if($invites->count())
                @foreach($invites as $invite)
                    <tr>
                        <td>{{ $invite->nom_prenom ?? '-' }}</td>
                        <td>{{ $invite->role ?? '-' }}</td>
                        <td>{{ $invite->nationalite ?? '-' }}</td>
                    </tr>
                @endforeach
            @else
                <tr>
                    <td>-</td>
                    <td>-</td>
                    <td>-</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>

<input type="hidden" name="id_formulaire" value="{{ $formulaire5->id_type }}">
<h4 style="margin-top:30px;">
   {{ $formulaire5->type_ar }}
</h4>
          <br>

 <div class="section">
    <div class="row">
        <div class="field">
            <span class="label">
                الجمعيات المشاركة
            </span>
			
		</div>
		
		
		@php
        $assocParticipantes = collect();
        if ($demande->evenementSportifs && $demande->evenementSportifs->first()) {
            $assocParticipantes = $demande->evenementSportifs->first()->assocParticipantes ?? collect();
        }
    @endphp

    <table>
        <thead>
            <tr>
                <th rowspan="2" style="width:5%">
                    ع/ر
                </th>
                <th rowspan="2" style="width:25%">
                    الجمعيات المشاركة
                </th>
                <th colspan="2" style="width:30%">
                    عدد الرياضيين
                </th>
                <th rowspan="2" style="width:15%">
                    المرافقون
                </th>
                <th rowspan="2" style="width:15%">
                   المجموع
                </th>
            </tr>
            <tr>
                <th>ذكور</th>
                <th>إناث</th>
            </tr>
        </thead>

        <tbody>
            @if($assocParticipantes->count())
                @foreach($assocParticipantes as $index => $assoc)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ $assoc->nom ?? '-' }}</td>
                        <td>{{ $assoc->num_athlete_h ?? 0 }}</td>
                        <td>{{ $assoc->num_athlete_f ?? 0 }}</td>
                        <td>{{ $assoc->accompagnants ?? 0 }}</td>
                        <td><strong>{{ $assoc->total ?? 0 }}</strong></td>
                    </tr>
                @endforeach
            @else
                <tr>
                    <td>1</td>
                    <td>-</td>
                    <td>0</td>
                    <td>0</td>
                    <td>0</td>
                    <td><strong>0</strong></td>
                </tr>
            @endif
        </tbody>

        <tfoot>
            <tr>
                <th colspan="2">
                   المجموع العام
                </th>
                <th>{{ $assocParticipantes->sum('num_athlete_h') }}</th>
                <th>{{ $assocParticipantes->sum('num_athlete_f') }}</th>
                <th>{{ $assocParticipantes->sum('accompagnants') }}</th>
                <th><strong>{{ $assocParticipantes->sum('total') }}</strong></th>
            </tr>
        </tfoot>
    </table>
	</div>
</div>
                    
  
<input type="hidden" name="id_formulaire" value="{{ $formulaire6->id_type }}">
<h4 style="margin-top:30px;">
  {{ $formulaire6->type_ar }}
</h4>
<br> 
  
<div class="section">
    <div class="row">
        <div class="field">
            <span class="label">
                الرياضيين المشاركين بصفة فردية
            </span>
			
		</div>
		
		@php
        $athletes = collect();
        if ($demande->evenementSportifs && $demande->evenementSportifs->first()) {
            $athletes = $demande->evenementSportifs->first()->athletesIndividuels ?? collect();
        }
    @endphp

    <table>
        <thead>
            <tr>
                <th rowspan="2" style="width:5%">
                ع/ر
                </th>
                <th rowspan="2" style="width:30%">
                    اسم و لقب الرياضي المشارك
                </th>
                <th colspan="2" style="width:25%">
                    عدد الرياضيين
                </th>
                <th rowspan="2" style="width:15%">
                    المرافقون
                </th>
                <th rowspan="2" style="width:15%">
                   المجموع
                </th>
            </tr>
            <tr>
                <th>ذكور</th>
                <th>إناث</th>
            </tr>
        </thead>

        <tbody>
            @if($athletes->count())
                @foreach($athletes as $index => $athlete)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ $athlete->nom_prenom_sportif ?? '-' }}</td>
                        <td>{{ $athlete->num_athlete_h ?? 0 }}</td>
                        <td>{{ $athlete->num_athlete_f ?? 0 }}</td>
                        <td>{{ $athlete->accompagnants ?? 0 }}</td>
                        <td><strong>{{ $athlete->total ?? 0 }}</strong></td>
                    </tr>
                @endforeach
            @else
                <tr>
                    <td>1</td>
                    <td>-</td>
                    <td>0</td>
                    <td>0</td>
                    <td>0</td>
                    <td><strong>0</strong></td>
                </tr>
            @endif
        </tbody>

        <tfoot>
            <tr>
                <th colspan="2">
                    المجموع العام
                </th>
                <th>{{ $athletes->sum('num_athlete_h') }}</th>
                <th>{{ $athletes->sum('num_athlete_f') }}</th>
                <th>{{ $athletes->sum('accompagnants') }}</th>
                <th><strong>{{ $athletes->sum('total') }}</strong></th>
            </tr>
        </tfoot>
    </table>
	</div>
</div>	

<input type="hidden" name="id_formulaire" value="{{ $formulaire7->id_type }}">
<h4 style="margin-top:30px;">
   {{ $formulaire7->type_ar }}
</h4>
<br> 
  
<div class="section">
    <div class="row">
        <div class="field">
            <span class="label">
                الرياضيين المشاركين
            </span>
			
		</div>
		
		@php
        $sportifs = collect();
        if ($demande->evenementSportifs && $demande->evenementSportifs->first()) {
            $sportifs = $demande->evenementSportifs->first()->sportifs ?? collect();
        }
    @endphp

    <table>
        <thead>
            <tr>
                <th>اسم و لقب الرياضي المشارك</th>
                <th>الصنف العمري</th>
                <th>تاريخ الولادة</th>
                <th>رقم بطاقة التعريف</th>
            </tr>
        </thead>
        <tbody>
            @if($sportifs->count())
                @foreach($sportifs as $sportif)
                    <tr>
                        <td>{{ $sportif->nom_prenom ?? '-' }}</td>
                        <td>{{ $sportif->tranch_age ?? '-' }}</td>
                        <td>{{ $sportif->date_naissance ?? '-' }}</td>
                        <td>{{ $sportif->num_cin ?? '-' }}</td>
                    </tr>
                @endforeach
            @else
                <tr>
                    <td colspan="4">
                        لا يوجد
                    </td>
                </tr>
            @endif
        </tbody>
    </table>
		
	</div>
</div>
<h4 style="margin-top:30px;">
   موافقة مبدئية
</h4>
<br> 
  
<div class="section">
    <div class="row">
        <div class="field">
            <span class="label">
                 موافقة مبدئية كتابية لاستغلال مكان إقامة التظاهرة الرياضية من المصالح المختصة
            </span>

            
        </div>

        @if($demande->accordFile)
                            <p>
                                الملف الحالي :
                                <a href="{{ route('manifestation.attachment.show', $demande->accordFile->id_attach) }}"
                                target="_blank">
                                  عرض الملف
                                </a>
                            </p>
                        @else
                            <p class="text-muted">لا يوجد</p>
                        @endif

    </div>
</div>


<h4 style="margin-top:30px;">
الملف الفني
</h4>
 <br> 
  
<div class="section">
    <div class="row">
        <div class="field">
            <span class="label">
              الملف الفني للتظاهرة
            </span>

            
        </div>

        @if($demande->techniqueFile)
                            <p>
                                الملف الحالي :
                                <a href="{{ route('manifestation.attachment.show', $demande->techniqueFile->id_attach) }}"
                                target="_blank">
                                    عرض الملف
                                </a>
                            </p>
                        @else
                            <p class="text-muted">لا يوجد</p>
                        @endif

    </div>
</div>           


<h4 style="margin-top:30px;">
 مطلب في إقامة تظاهرة رياضية وطنية بالبلاد التونسية
</h4>
 <br> 
  
<div class="section">
    <div class="row">
        <div class="field">
            <span class="label">
                المطلب
            </span>

            
        </div>

        @if($demande->demandeFile)
                            <p>
                                الملف الحالي :
                                <a href="{{ route('manifestation.attachment.show', $demande->demandeFile->id_attach) }}"
                                target="_blank">
                                     عرض الملف
                                </a>
                            </p>
                        @else
                            <p class="text-muted">لا يوجد</p>
                        @endif

    </div>
</div> 


                

           
</body>
</html>
