@extends('backoffice.dashboard')

@section('content')
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<div class="container-fluid dashboard-inner-body-container">
  <div class="row">
    <div class="col-lg-12">
      <div class="block-card dashboard-card mb-4 px-0">



        <div class="block-card-header px-4 pb-3 border-bottom-0">
            <div class="d-flex flex-wrap align-items-center justify-content-between">
                <h2 class="widget-title mb-0">
                    طلبات قاعات الرياضة
                </h2>
                <div class="d-flex align-items-center gap-2 action-buttons">
                    <a href="{{ route('salle-sport.export.excel') }}"
                        class="btn btn-outline-primary btn-icon btn-icon-excel d-flex align-items-center justify-content-center"
                        title="Excel">
                            <i class="fa-solid fa-file-excel"></i>
                        </a>

                    <a href="{{ route('salle-sport.export.pdf') }}" target="_blank"
                        class="btn btn-outline-danger btn-icon btn-icon-pdf d-flex align-items-center justify-content-center"
                        title="PDF">
                            <i class="fa-solid fa-file-pdf"></i>
                        </a>
                    <!--<a href="{{ route('salle-sport.create') }}"
                    class="btn btn-success d-flex align-items-center justify-content-center">
                        <i class="la la-plus me-1"></i>
                        إضافة طلب
                    </a>-->
                    <style>
                        .action-buttons .btn {
                            height: 42px;       
                            min-width: 42px;       
                            padding: 0 14px;
                        }

                        .btn-icon-excel {
                            background-color: #fff !important;
                            border: 1px solid #0d6efd !important;   
                            color: #0d6efd !important;               
                        }

                        .btn-icon-excel:hover {
                            background-color: #e3f2fd !important;   
                            color: #0d6efd !important;                
                            border-color: #0d6efd !important;
                        }

                        .btn-icon-excel i {
                            color: inherit !important;
                        }


                        .btn-icon-pdf {
                            background-color: #fff !important;
                            border: 1px solid #e74c3c !important;   
                            color: #e74c3c!important;               
                        }

                        .btn-icon-pdf:hover {
                            background-color: #fde8ea !important;  
                            color: #e74c3c!important;               
                            border-color: #e74c3c !important;
                        }

                        .btn-icon-pdf i {
                            color: inherit !important;
                        }

                </style> 
                </div>
            </div>
        </div>




        <div class="block-card-header px-4 border-bottom-0 pb-0">
            <form method="GET" action="{{ route('salle-sport.index') }}">
                <div class="form-row align-items-center">
                    <div class="col-auto" style="width: 200px;">
                        <select id="search-option" class="form-control" name="search_option" onchange="showSearchInput2(this.value)">
                            <option value="">اختر نوع البحث</option>
                            <option value="date" {{ request('search_option') == 'date' ? 'selected' : '' }}>تاريخ الإيداع</option>
                            <option value="type_identite" {{ request('search_option') == 'type_identite' ? 'selected' : '' }}>نوع الهوية</option>
                        </select>
                    </div>
                    <div class="col-auto" id="searchByDate" style="display:none; width: 180px;">
                        <input type="date" class="form-control" name="date" value="{{ request('date') }}">
                    </div>
                    <div class="col-auto" id="searchByTypeIdentite" style="display:none; width: 200px;">
                        <select id="type_identite_select" class="form-control" name="type_identite" onchange="showIdentityInput2(this.value)">
                            <option value="">-- اختر نوع الهوية --</option>
                            @foreach($typesIdentite as $type)
                                <option value="{{ $type->id_type }}" {{ request('type_identite') == $type->id_type ? 'selected' : '' }}>
                                    {{ $type->type_ar }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-auto" id="inputCIN" style="display:none; width: 250px;">
                        <input type="text" class="form-control" name="cin" placeholder="أدخل رقم بطاقة التعريف" value="{{ request('cin') }}">
                    </div>
                    <div class="col-auto" id="inputPassport" style="display:none; width: 250px;">
                        <input type="text" class="form-control" name="passport" placeholder="أدخل رقم جواز السفر" value="{{ request('passport') }}">
                    </div>
                    <div class="col-auto" id="inputFiscal" style="display:none; width: 250px;">
                        <input type="text" class="form-control" name="num_fiscal" placeholder="أدخل الرقم الجبائي" value="{{ request('num_fiscal') }}">
                    </div>
                    <div class="col d-flex">
                        <button type="submit" 
                                class="btn bg-rgb-primary1 font-weight-medium d-flex align-items-center justify-content-center"
                                style="width: 105px;">
                            بحث
                        </button>
                        <a href="{{ route('salle-sport.index') }}"
                        class="btn bg-rgb-primary1 font-weight-medium d-flex align-items-center justify-content-center"
                        style="width: 45px; height: 38px; margin-right: 5px; padding: 0;">
                            <i class="fa-solid fa-rotate-right" style="font-size: 16px;"></i>
                        </a>
                    </div>
                </div>
            </form>
        </div>

         <div class="block-card-body">
          @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
              {{ session('success') }}
              <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
          @endif

          <div class="my-table table-responsive" style="direction: rtl; text-align: right;">
            <table class="table align-items-center table-flush mb-0 table-hover" style="direction: rtl; text-align: right;">
                <thead class="thead-light">
                    <tr>
							<th width="8%">المعرف</th>
							<th width="18%">تاريخ الإيداع</th>
							<th width="15%">إسم مقدم الطلب</th>
							<th width="8%">وضعية الطلب</th>
							<th width="18%">إجراءات</th>
							
						</tr>
					</thead>

        <tbody>
            @forelse($salles as $salle)
                <tr>
                    <td>{{ $salle->id_imm }}</td>
                    <td>{{ $salle->created_at->format('Y-m-d H:i') }}</td>
                    <td>{{ $salle->utilisateur->nom_prenom ?? '---' }}</td>
                    <td>
                        <span class="status-badge 
                            {{ $salle->statut->statut_ar == 'قبول' ? 'status-badge--success' : 
                            ($salle->statut->statut_ar == 'رفض' ? 'status-badge--danger' : 'status-badge--pending') }}">
                            {{ $salle->statut->statut_ar ?? 'في الانتظار' }}
                        </span>
                    </td>
                <td class="text-center">
                            <div class="d-flex flex-wrap gap-2 justify-content-center">
                          <!-- Afficher -->
                          <a href="{{ route('salle-sport.show', $salle->id_imm) }}"
                            class="btn-icon btn-icon--primary"
                            title="عرض" aria-label="عرض">
                              <i class="la la-eye"></i>
                          </a>

                         @if($salle->id_statut == 2 || $salle->id_statut == 4 || $salle->id_statut == 5)
                              <!-- Modifier -->
                              <button type="button"
                                      class="btn-icon btn-icon--warning"
									  onclick="window.location='{{ route('salle-sport.edit', $salle->id_imm) }}'"
                                      title="تعديل" aria-label="تعديل">
                                  <i class="la la-edit"></i>
                              </button>

                              <!-- Changer statut -->
                              <form action="{{ route('salle-sport.acceptation', $salle->id_imm) }}" method="POST" class="d-inline">
                                  @csrf
                                  @method('PATCH')
                         
								  
								 <button type="button" onclick="confirmStatusChange2(this.closest('form'), '{{ $salle->statut?->statut_ar }}')" class="btn-icon btn-icon--secondary" title="تغيير الحالة">
                                     <i class="la la-toggle-on"></i>
                                  </button>
                              </form>

                              <!-- Supprimer -->
                              <form action="{{ route('salle-sport.destroy', $salle->id_imm) }}" method="POST" class="d-inline">
                                  @csrf
                                  @method('DELETE')
                                  <button type="button"
                                          onclick="return confirmAction('هل تريد حقًا حذف هذه الاستمارة؟', null, this.closest('form'))"
                                          class="btn-icon btn-icon--danger"
                                          title="حذف" aria-label="حذف">
                                      <i class="la la-trash"></i>
                                  </button>
                              </form>
                          @endif
                      </div>
                  </td>


                    <!--td>
    @if($salle->id_statut == 1)
        @if(is_null($salle->debutActivite) || optional($salle->debutActivite)->etat_formulaire === 'non_remplir')
            <button type="button" class="btn-modern btn-modern--success"
                    onclick="openDebutActivite2Form({{ $salle->id_imm }})">
                <i class="la la-plus me-1"></i> إعلام ببداية النشاط
            </button>

        @elseif(optional($salle->debutActivite)->etat_formulaire === 'remplir')
            <button type="button" class="btn-modern btn-modern--warning"
                    onclick="openEditActivite2Form({{ optional($salle->debutActivite)->id_debut }})">
                <i class="la la-edit me-1"></i> تعديل الطلب
            </button>

        @elseif(optional($salle->debutActivite)->etat_formulaire === 'reponse')
            <button type="button" class="btn-modern btn-modern--info"
                    onclick="openConsulterActivite2Form({{ optional($salle->debutActivite)->id_debut }})">
                <i class="la la-eye me-1"></i> اطلاع على الطلب
            </button>
        @endif
    @endif
</td>

                    <td class="text-center">
    @php
        $doc = $salle->documentsFormulaires ? $salle->documentsFormulaires->first() : null;
        $etat1 = $doc->etat_formulaire ?? null;
    @endphp

    @if(optional($salle->debutActivite)->etat_formulaire === 'reponse' 
        && optional($salle->debutActivite)->id_statut == 1)

        <div class="d-flex justify-content-center">
            @if(is_null($doc) || $etat1 === 'non_remplir')
                {{-- Ajouter --}}
                <button type="button" class="btn-modern btn-modern--success"
                        onclick="openExonerationForm({{ $salle->id_imm }})">
                    <i class="la la-plus me-1"></i> إضافة إعفاء جبائي
                </button>

            @elseif($doc && $etat1 === 'remplir')
                {{-- Modifier --}}
                <button type="button" class="btn-modern btn-modern--warning"
                        onclick="editExonerationForm({{ $doc->id_doc }})">
                    <i class="la la-edit me-1"></i> تعديل الطلب
                </button>

            @elseif($doc && $etat1 === 'reponse')
                {{-- Consulter --}}
                <button type="button" class="btn-modern btn-modern--info"
                        onclick="viewExonerationForm({{ $doc->id_doc }})">
                    <i class="la la-eye me-1"></i> اطلاع على الطلب
                </button>
            @endif
        </div>
    @endif
</td-->


                </tr>
            @empty
                <tr>
                    <td colspan="7" class="text-center">لا توجد طلبات قاعات الرياضة.</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-between align-items-center mt-3">
                      {{ $salles->links('pagination::bootstrap-5') }}
                    </div>

<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script src="{{ asset('assets/js/index.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
function openDebutActivite2Form(immobilierId) {
    const url = `{{ route('admin.debut_activite.create') }}?immobilier_id=${immobilierId}`;
    window.location.href = url;
}

function openEditActivite2Form(immobilierId) {
    const url = `{{ route('admin.debut_activite.edit', ':id') }}`.replace(':id', immobilierId);
    window.location.href = url;
}

function openConsulterActivite2Form(immobilierId) {
    const url = `{{ route('debut_activite.show', ':id') }}`.replace(':id', immobilierId);
    window.location.href = url;
}

function openExonerationForm(idImm) {
        window.location.href = `/mjs/back/public/admin/investissement/salle-sport/${idImm}/exoneration/create`;
    }

    function editExonerationForm(docId) {
        window.location.href = `/mjs/back/public/admin/investissement/salle-sport/exoneration/${docId}/edit`;
    }


    function viewExonerationForm(docId) {
        window.location.href = `/mjs/back/public/admin/investissement/salle-sport/exoneration/${docId}/show`;
    }
</script>




         
        </div>

      </div>
    </div>
  </div>
</div>
@else


<script> window.location.href = "{{ route('admin') }}"; </script>
@endif
@endsection
