<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<style>
body {
    font-family: DejaVu Sans;
    font-size: 12px;
    direction: rtl;
    text-align: right;
    color: #222;
    line-height: 1.6;
}

/* HEADER */
.header {
    border-bottom: 3px solid #c62828;
    margin-bottom: 20px;
    padding-bottom: 10px;
}
.header h1,h2,h3 {
    margin: 0;
    text-align: center;
}

/* SECTIONS */
.section {
    background-color: #ffffff;
    border: 1px solid #ddd;
    border-right: 5px solid #c62828;
    padding: 12px 14px;
    margin-bottom: 15px;
}

/* ROWS */
.row {
    display: flex;
    flex-wrap: wrap;
    margin-bottom: 8px;
}

.field {
    width: 48%;
    margin-bottom: 8px;
}

/* LABEL + VALUE */
.label {
    font-size: 11px;
    color: #555;
    margin-bottom: 2px;
    display: block;
}

.value {
    font-size: 12px;
    font-weight: 500;
    padding: 4px 0;
    border-bottom: 1px dotted #999;
    min-height: 18px;
}

/* TABLE */
table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 10px;
    font-size: 11.5px;
}
th {
    background-color: #f2f2f2;
    border: 1px solid #000;
    padding: 6px;
    font-weight: bold;
}
td {
    border: 1px solid #000;
    padding: 6px;
}

.page-break {
    page-break-before: always;
}

.no-break {
    page-break-inside: avoid;
}

/* Type de formule */
.formula-type {
    background-color: #f0f8ff;
    border: 1px solid #4a90e2;
    padding: 8px;
    margin-bottom: 15px;
    border-radius: 4px;
    font-weight: bold;
    color: #2c3e50;
}
</style>
</head>
<body>

{{-- HEADER --}}
<div class="header">
    <table width="100%" style="border:none;">
        <tr>
            <td style="width:120px; text-align:right; border:none;">
                @if(file_exists(public_path('storage/logo.png')))
                    <img src="{{ public_path('storage/logo.png') }}" style="width:90px;">
                @else
                    <!-- Logo par défaut ou vide -->
                    <div style="width:90px; height:90px; background:#f0f0f0;"></div>
                @endif
            </td>
            <td style="text-align:center; border:none;">
                <h1>الجمهورية التونسية</h1>
                <h2>وزارة الشباب و الرياضة</h2>
                <h3>استمارة الإعلام ببداية النشاط</h3>
            </td>
            <td style="width:120px; border:none;"></td>
        </tr>
    </table>
</div>

{{-- TYPE DE FORMULE --}}
<!--div class="formula-type">
    نوع الاستمارة: 
    @if($debutActivite->id_projet_debut)
        مشروع ترفيهي للطفل والشباب
    @elseif($debutActivite->id_activite_jeune_enfant)
        نشاط طفل وشباب
    @elseif($debutActivite->immobilier_id)
        عقاري
    @elseif($debutActivite->id_insts)
        مؤسسة خاصة للشباب
    @elseif($debutActivite->id_inv_sport_debut)
        استثمار رياضي
    @else
        غير محدد
    @endif
</div-->

{{-- ÉTAT DU DOCUMENT --}}
<div class="section row">
    <div class="field">
        <span class="label">حالة الطلب</span>
        <span class="value">
            @if($debutActivite->id_statut == 1)
                مقبول
            @elseif($debutActivite->id_statut == 3)
                مرفوض
            @else
                في الانتظار
            @endif
        </span>
    </div>
    <!--div class="field">
        <span class="label">رقم الاستمارة</span>
        <span class="value">{{ $debutActivite->id_debut }}</span>
    </div-->
    @if($debutActivite->id_statut == 3 && $debutActivite->commentaire_motif)
    <div class="field" style="width:100%;">
        <span class="label">سبب الرفض</span>
        <span class="value">{{ $debutActivite->commentaire_motif }}</span>
    </div>
    @endif
</div>

{{-- IDENTITÉ DU PORTEUR --}}
<h4>هوية الباعث</h4>
<div class="section row">
    <div class="field">
        <span class="label">الاسم و اللقب أو الاسم التجاري</span>
        <span class="value">{{ $utilisateur ? $utilisateur->nom_prenom : '-' }}</span>
    </div>
    <div class="field">
        <span class="label">رقم الهوية</span>
        <span class="value">
            {{ $utilisateur ? ($utilisateur->cin ?? $utilisateur->passport ?? $utilisateur->num_fiscal ?? '-') : '-' }}
        </span>
    </div>
    <div class="field">
        <span class="label">الهاتف</span>
        <span class="value">{{ $utilisateur ? $utilisateur->tel : '-' }}</span>
    </div>
    <div class="field">
        <span class="label">البريد الإلكتروني</label>
        <span class="value">{{ $utilisateur ? $utilisateur->email : '-' }}</span>
    </div>
    @if($utilisateur && $utilisateur->adresse)
    <div class="field" style="width:100%;">
        <span class="label">العنوان</span>
        <span class="value">{{ $utilisateur->adresse }}</span>
    </div>
    @endif
</div>

{{-- GOUVERNORAT --}}
@if($gouvernorat)
<h4>المندوبية الجهوية</h4>
<div class="section row">
    <div class="field">
        <span class="label">المندوبية الجهوية للشباب و الرياضة</span>
        <span class="value">{{ $gouvernorat->nom_ar }}</span>
    </div>
</div>
@endif

{{-- DATE DE DÉBUT --}}
<h4>تاريخ بداية النشاط</h4>
<div class="section row">
    <div class="field">
        <span class="label">تاريخ البداية</span>
        <span class="value">
            {{ $debutActivite->date_debut_activite ? $debutActivite->date_debut_activite->format('d/m/Y') : '-' }}
        </span>
    </div>
</div>

{{-- DOCUMENTS --}}
<!--h4>الوثائق المرفقة</h4>
<div class="section">
    @php
        $docs = [
            'preuve_propriete_location' => 'نسخة من شهادة الملكية أو عقد الكراء',
            'plan_architectural' => 'مخطط معماري',
            'declaration_investissement' => 'شهادة تصريح بالاستثمار',
            'identification' => 'بطاقة تعريف / جواز سفر',
            'extrait_registre_national_entreprise' => 'السجل الوطني للمؤسسات',
            'certificat_prevention' => 'شهادة الوقاية',
            'contrat_assurance' => 'عقد التأمين',
            'approbation_autorite_minicipale' => 'اعتماد السلطة المحلية'
        ];
    @endphp

    <table>
        <thead>
            <tr>
                <th style="width:70%;">الوثيقة</th>
                <th style="width:30%;">الحالة</th>
            </tr>
        </thead>
        <tbody>
            @foreach($docs as $field => $label)
            <tr>
                <td>{{ $label }}</td>
                <td style="text-align:center;">
                    @if(!empty($debutActivite->$field))
                        ✓ مرفقة
                    @else
                        ✗ غير مرفقة
                    @endif
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>

{{-- SIGNATURES --}}
<div class="page-break"></div>
<h4>التوقيعات</h4>
<div class="section row" style="margin-top: 50px;">
    <div class="field" style="width:100%; text-align:center; margin-top: 100px;">
        <span class="label">توقيع صاحب الطلب</span>
        <div style="height: 50px; border-bottom: 1px solid #000; width: 300px; margin: 0 auto;"></div>
    </div>
</div>

<div class="section row" style="margin-top: 100px;">
    <div class="field" style="width:50%; text-align:center;">
        <span class="label">توقيع المسؤول الإداري</span>
        <div style="height: 50px; border-bottom: 1px solid #000; width: 250px; margin: 0 auto;"></div>
    </div>
    <div class="field" style="width:50%; text-align:center;">
        <span class="label">الختم الرسمي</span>
        <div style="height: 50px; border-bottom: 1px solid #000; width: 250px; margin: 0 auto;"></div>
    </div>
</div-->

{{-- FOOTER --}}
<div style="position: fixed; bottom: 20px; right: 0; left: 0; text-align: center; font-size: 10px; color: #777;">
    تم إنشاء هذه الوثيقة في: {{ now()->format('d/m/Y H:i') }}
</div>

</body>
</html>