@extends('backoffice.dashboard')
@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">

@if(Auth::check())

<div class="container">
    <form action="{{ route('admin.jeune_enfant.update', $projet->id_projet) }}" method="POST" enctype="multipart/form-data" lang="ar">
    @csrf
    @method('PUT') {{-- Important pour update --}}
        <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
     

        <h3>{{ $formulaire->type_ar }}</h3>
		   <h4 class="title-request">اطلاع على المطلب</h4>
<br>
        <div>
            <div class="d-flex align-items-center mb-3">
                <h5 class="mb-0 fw-bold me-2">   الوضعية الحالية: </h5>
                @switch($projet->id_statut)
      @case(1)<span><strong> مقبول </strong></span>@break
      @case(3)<span><strong>مرفوض</strong></span>@break
      @case(4)<span><strong>موافقة شريطة</strong></span>@break
      @case(5)<span><strong>إرجاء لإبداء الرأي</strong></span>@break
      @case(2)<span><strong>في الانتظار</strong></span>@break
      @case(6)<span><strong>مسودّة</strong></span>@break
      @default <span><strong>غير محدد</strong></span>
    @endswitch
            </div>

            @if($projet->id_statut == 3 && !empty($projet->commentaire_motif))
                <div class="d-flex align-items-center mb-3">
                    <label class="fw-bold text-danger me-2 mb-0">سبب الرفض:</label>
                    <p class="mb-0 border p-2 rounded shadow-sm text-muted">{{ $projet->commentaire_motif }}</p>
                </div>
            @endif
        </div>
{{-- history card (compact) --}}
<div class="card shadow-lg border-0 mb-4 rounded-4">
  <div class="card-header bg-light py-2"><h5 class="mb-0 fw-bold">تاريخ تغيّر الوضعية</h5></div>

  <div class="card-body p-2" dir="rtl">
    @if( ! isset($projet->statutHistories) || $projet->statutHistories->isEmpty())
      <p class="text-muted mb-0">لا توجد تغييرات سابقة.</p>
    @else
      <div class="compact-timeline">
        @foreach($projet->statutHistories as $hist)
          @php
            $from = optional($hist->fromStatut)->statut_ar ?? optional($hist->fromStatut)->libelle_ar ?? '—';
            $to = optional($hist->toStatut)->statut_ar ?? optional($hist->toStatut)->libelle_ar ?? '—';
            $toId = optional($hist->toStatut)->id_statut;
            $badgeClass = $toId === 1 ? 'badge-success' : ($toId === 3 ? 'badge-danger' : 'badge-muted');
            $changer = optional($hist->changer)->nom_prenom ?? optional($hist->changer)->email ?? 'نظام';
          @endphp

          <div class="compact-item">
            <div class="compact-row d-flex align-items-center justify-content-between w-100">
              <div class="left-block text-end">
                <div class="small text-muted compact-date">{{ $hist->created_at->format('d/m/Y H:i') }}</div>
                <div class="very-small text-muted compact-user">بواسطة: {{ $changer }}</div>
              </div>

              <div class="right-block text-right flex-fill">
                <span class="compact-from small text-muted">{{ $from }}</span>
                <span class="compact-arrow" aria-hidden="true"> &larr; </span>
                <span class="compact-to small {{ $badgeClass }}">{{ $to }}</span>
              </div>
            </div>

            @if($hist->commentaire)
              <details class="compact-comment mt-1">
                <summary class="very-small text-danger">سبب / تعليق</summary>
                <div class="very-small text-muted mt-1">{{ $hist->commentaire }}</div>
              </details>
            @endif
          </div>
        @endforeach
      </div>
    @endif
  </div>
</div>

{{-- small CSS (reuse your existing styles) --}}
<style>
/* compact styles (same as earlier) */
.compact-timeline { display:flex; flex-direction:column; gap:6px; }
.compact-item { padding:6px 4px; border-bottom:1px solid rgba(0,0,0,0.06); }
.left-block { width:160px; min-width:120px; margin-left:12px; }
.compact-date { font-size:12px; color:#6c757d; }
.compact-user { font-size:11px; color:#8a8f94; margin-top:2px; }
.right-block { display:flex; align-items:center; gap:6px; justify-content:flex-start; }
.compact-from { color:#6c757d; font-size:13px; }
.compact-arrow { color:#6c757d; font-size:14px; margin:0 4px; }
.compact-to { font-size:13px; padding:3px 8px; border-radius:10px; }
.badge-success { background:#198754; color:#fff; }
.badge-danger  { background:#dc3545; color:#fff; }
.badge-muted   { background:#6c757d; color:#fff; }
.compact-comment summary { list-style:none; cursor:pointer; outline:none; padding:0; }
</style>
        <div class="form-section">
            <h4>المستثمر</h4>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <div class="form-control bg-white border-0">{{ $projet->investissements->first()?->utilisateur->nom_prenom ?? '-' }}</div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">مكان الولادة</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $projet->investissements->first()?->utilisateur->lieu_naissance ?? '-' }}
                    </div>
                </div>

                <label class="col-sm-2 col-form-label">تاريخ الولادة</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $projet->investissements->first()?->utilisateur->date_naissance ?? '-' }}
                    </div>
                </div>
            </div>

            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label">الهوية الشخصية</label>  
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $projet->investissements->first()?->utilisateur->typeIdentite->type_ar ?? '-' }}
                    </div>
                </div>

                @php
                    $typeIdentite = $projet->investissements->first()?->utilisateur->id_type_identite;
                @endphp

                @if($typeIdentite == 1)
                    <div class="col-sm-6">
                        <div class="form-control bg-white border-0">
                            {{ $projet->investissements->first()?->utilisateur->cin ?? '-' }}
                        </div>
                    </div>
                @elseif($typeIdentite == 2)
                    <div class="col-sm-6">
                        <div class="form-control bg-white border-0">
                            {{ $projet->investissements->first()?->utilisateur->passport ?? '-' }}
                        </div>
                    </div>
                @elseif($typeIdentite == 3)
                    <div class="col-sm-6">
                        <div class="form-control bg-white border-0">
                            {{ $projet->investissements->first()?->utilisateur->num_fiscal ?? '-' }}
                        </div>
                    </div>
                @endif
            </div>

            @php
                $user = $projet->investissements->first()?->utilisateur;
            @endphp

            @if($user && $user->id_type_identite == 1)
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">تاريخ إصدار البطاقة</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $user->date_delivrance_cin ?? '-' }}
                    </div>
                </div>

                <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $user->lieu_delivrance_cin ?? '-' }}
                    </div>
                </div>
            </div>
            @endif

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">العنوان الشخصي</label>
                <div class="col-sm-10">
                    <div class="form-control bg-white border-0">
                        {{ $user->adresse ?? '-' }}
                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">المستوى التعليمي</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $projet->niveau_etude_user ?? '-' }}
                    </div>
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $projet->dernier_diplome_user ?? '-' }}
                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاقدمية في تعاطي النشاط</label>
                <div class="col-sm-10">
                    <div class="form-control bg-white border-0">
                        {{ $projet->experience_user ?? '-' }}
                    </div>
                </div>
            </div>
        </div>

        
        <div class="form-section mt-4">
            <h4>خصائص المشروع الترفيهي</h4>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_spectacle" value="0"> 
                <input class="form-check-input me-2 bg-white" type="checkbox" id="espace_spectacle" name="espace_spectacle" value="1"
                    {{ $projet->espace_spectacle ? 'checked' : '' }} disabled>
                <label class="col-sm-6 col-form-label" for="espace_spectacle">
                    فضاءات ترفيهية و الهواء الطلق و العروض
                </label>
            </div>

            <div class="mt-3" id="caracteristique_group" style="display:{{ $projet->espace_spectacle ? 'block' : 'none' }};">
                <textarea class="form-control shadow-sm rounded-3 bg-white" readonly 
                        placeholder="خصوصياتها" rows="3">{{ $projet->caracteristique_spec }}</textarea>
            </div>


            {{-- Répéter pour les autres checkboxes et textareas --}}
            {{-- espace_sportif --}}
            <div class="form-check d-flex align-items-center">
                <input readonly type="hidden" name="espace_sportif" value="0"> 
                <input readonly class="form-check-input me-2 bg-white" type="checkbox" id="espace_sportif" name="espace_sportif" value="1" disabled
                       {{ old('espace_sportif', $projet->espace_sportif) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="espace_sportif">فضاءات ترفيهية رياضية</label>
            </div>
            <div class="mt-3" id="caracteristique_sportif_group" style="display:{{ $projet->espace_sportif ? 'block' : 'none' }};">
                <textarea readonly class="form-control shadow-sm rounded-3 bg-white" name="caracteristique_sportif" rows="3">{{ old('caracteristique_sportif', $projet->caracteristique_sportif) }}</textarea>
            </div>

            {{-- espace_activite_service --}}
            <div class="form-check d-flex align-items-center">
                <input readonly type="hidden" name="espace_activite_service" value="0"> 
                <input readonly class="form-check-input me-2 bg-white" type="checkbox" id="espace_activite_service" name="espace_activite_service" value="1" disabled
                       {{ old('espace_activite_service', $projet->espace_activite_service) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="espace_activite_service">فضاء الأنشطة الخدماتية</label>
            </div>
            <div class="mt-3" id="caracteristique_activite_serv_group" style="display:{{ $projet->espace_activite_service ? 'block' : 'none' }};">
                <textarea readonly class="form-control shadow-sm rounded-3 bg-white" name="caracteristique_activite_serv" rows="3">{{ old('caracteristique_activite_serv', $projet->caracteristique_activite_serv) }}</textarea>
            </div>

            {{-- espace_activite_culturelle --}}
            <div class="form-check d-flex align-items-center">
                <input readonly type="hidden" name="espace_activite_culturelle" value="0"> 
                <input readonly class="form-check-input me-2 bg-white" type="checkbox" id="espace_activite_culturelle" name="espace_activite_culturelle" value="1" disabled
                       {{ old('espace_activite_culturelle', $projet->espace_activite_culturelle) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="espace_activite_culturelle">فضاء الأنشطة القافية و الفنية و العلمية</label>
            </div>
            <div class="mt-3" id="caracteristique_activite_cult_group" style="display:{{ $projet->espace_activite_culturelle ? 'block' : 'none' }};">
                <textarea readonly class="form-control shadow-sm rounded-3 bg-white" name="caracteristique_activite_cult" rows="3">{{ old('caracteristique_activite_cult', $projet->caracteristique_activite_cult) }}</textarea>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4>طبيعة المشروع</h4>
            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label class="col-sm-10 col-form-label">الرجاء اختيار طبيعة المشروع</label>
                </div>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $projet->natureProjet->nature_ar ?? '-' }}
                    </div>
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4>عدد مواطن الشخل المؤملة</h4>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">من حاملي الشهادات العلمية</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $projet->nbr_diplome_universitaire ?? '-' }}
                    </div>
                </div>

                <label class="col-sm-2 col-form-label">اخرين</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $projet->nbr_autre ?? '-' }}
                    </div>
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4>مدير المؤسسة</h4>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <div class="form-control bg-white border-0">
                        {{ $projet->directeur->nom_prenom_d ?? '-' }}
                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">رقم بطاقة التعريف الوطنية</label>
                <div class="col-sm-10">
                    <div class="form-control bg-white border-0">
                        {{ $projet->directeur->num_cin ?? '-' }}
                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">تاريخ إصدار البطاقة</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $projet->directeur->date_delivrance ?? '-' }}
                    </div>
                </div>

                <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $projet->directeur->lieu_delivrance ?? '-' }}
                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">المستوى التعليمي</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $projet->directeur->niveau_etude ?? '-' }}
                    </div>
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $projet->directeur->dernier_diplome_obtenu ?? '-' }}
                    </div>
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4>بيانات عن الاستثمار و التمويل</h4>
            <table class="custom-table">
                <thead>
                    <tr>
                        <th>الإستثمار</th>
                        <th>المبلغ</th>
                        <th>مصادر التمويل</th>
                        <th>الملاحظات</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($projet->investissements as $inv)
                    <tr>
                        <td>{{ $inv->secteur_invest_id }}</td>
                        <td>{{ $inv->montant_inv }}</td>
                        <td>{{ $inv->source }}</td>
                        <td>{{ $inv->remarques }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <span class="text-muted">(*) اموال ذاتية, قروض طويلة المدى, قروض متوسطة المدى, قروض صغيرة المدى, منح, مواد اخرى.</span>

        <div class="mt-3">
            <h4>تصريح على الشرف</h4>
            <span>
                إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.
            </span>
        </div>

        <div class="remarques-block mt-3 p-3" style="border: 2px solid #000; border-radius: 5px;">
            <h4> ملاحظات خاصة بالمندوبية الجهوية للشباب و الرياضة و التربية البدنية :</h4>
            <textarea class="form-control mt-2 bg-white" name="remarques" readonly rows="6" placeholder="اكتب ملاحظاتك هنا...">{{ old('remarques', $projet->remarques) }}</textarea>
        </div> 

       
		<div class="form-group text-center mt-5">
            <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
                  <button type="button" onclick="window.open('{{ route('jeune_enfant.pdf', $projet->id_projet) }}', '_blank')" class="btn btn-success d-flex align-items-center justify-content-center gap-1 flex-fill">
                    <i class="bx bx-print"></i> طباعة
                </button>
                <a href="{{ route('admin.jeune_enfant.index') }}" class="btn btn-primary d-flex align-items-center justify-content-center gap-1 flex-fill">
                    <i class="bx bx-arrow-back" style="margin-right:5px;"></i> رجوع
                </a>
            </div>
        </div>
		<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    </form>
</div>

@else
<script>
    window.location.href = "{{ route('login') }}";
</script>
@endif
@endsection
