@extends('backoffice.dashboard')
@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())

<div class="container">
    <form action="{{ route('admin.exoneration.store') }}" method="POST" enctype="multipart/form-data" lang="ar">
    @csrf
        <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
        <h2>الجمهورية التونسية</h2>
        <h2>وزارة الشباب و الرياضة</h2>
        <h3 style="font-size:25px;">{{ $formulaire->type_ar }}</h3>
        <h4 style="text-align:center;padding-top:20px;">إستمارة تسجيل الإنتفاع بإعفاء جبائي</h4>
        <br>
        <div class="form-section">
            <h4>هوية صاحب المشروع</h4>

            <div class="form-group row mb-3"  style="padding-top:20px;">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="nom_prenom" placeholder="الاسم و اللقب" maxlength="50">
                </div>

                <label class="col-sm-2 col-form-label"> رقم الهاتف </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="tel">
                </div>
            </div>

            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label">الهوية الشخصية</label>  
                <div class="col-sm-4">
                    <select required class="form-control" id="id_type_identite" name="id_type_identite" onchange="showTypeIdentiteInput4()">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($typesIdentite as $type)
                            <option value="{{ $type->id_type }}">{{ $type->type_ar }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="col-sm-6" id="cin_input_wrapper" style="display:none;">
                    <input type="text" class="form-control" id="cin_input" name="cin" placeholder="أدخل رقم بطاقة التعريف" pattern="^\d{8}$" maxlength="8">
                </div>
                <div class="col-sm-6" id="passport_field" style="display:none;">
                    <input type="text" class="form-control" id="passport_input" name="passport" placeholder="أدخل رقم جواز السفر" pattern="^\d{8,12}$" minlength="8" maxlength="12">
                </div>
                <div class="col-sm-6" id="fiscal_field" style="display:none;">
                    <input type="text" class="form-control" id="num_fiscal_input" name="num_fiscal" placeholder="أدخل رقم المعرف الجبائي" pattern="^\d{12}$" maxlength="12">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> العنوان الشخصي </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="adresse" placeholder=" العنوان الشخصي " maxlength="50">
                </div>

                <label class="col-sm-2 col-form-label">  البريد الالكتروني </label>
                <div class="col-sm-4">
                    <input required type="email" class="form-control" name="email">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> عنوان المشروع  </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="nom_projet">
                </div>

                <label class="col-sm-2 col-form-label">  مكان المشروع </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="adresse_projet">
                </div>
            </div>

        </div>

        <div class="form-section mt-4">
            <h4> إضافة الوثائق المطلوبة </h4>
            <div class="form-group row mb-3">
                <label class="col-sm-6 col-form-label"> 1- نسخة من كراس الشروط  </label>
                <div class="col-sm-10">
                    <input type="file" class="form-control" id="copie_cahier_des_charges" name="copie_cahier_des_charges">
                </div>
            </div>
            <span> مؤشر عليها في جميع صفحاتها من قبل الباعث الخاص و مصحوبة بنسخة من وصل الإيداع او تحتوي على ختم المندوبية الجهوية للشباب و الرياضة مرجع النظر ترابيا لمكان تركيز المشروع</span>

            <div class="form-group row mb-3">
                <label class="col-sm-6 col-form-label">2- الاصل من شهادة ايداع التصريح</label>
                <div class="col-sm-10">
                    <input type="file" class="form-control" id="copie_originale" name="copie_originale">
                </div>
            </div>
            <span> مسلمة من قبل مصالح وكالة النهوض بالصناعة و التحديد مرجع النظر ترابيا لمكان تركيز المشروع على قائمة التجهيزات التي سيتم اقتنائها فعليا </span>

            <div class="form-group row mb-3">
                <label class="col-sm-6 col-form-label">3- فاتورة</label>
                <div class="col-sm-10">
                    <input type="file" class="form-control" id="facture" name="facture" >
                </div>
            </div>
            <span> فاتورة نهائية باللغة العربية او الفرنسية تحتوي حصرا على قائمة التجهيزات المزمن اقتنائها موضوع طلب الامتياز الجبائي و مطابقة للقائمة المضمنة بشهادة ايداع التصريح</span>

            <div class="form-group row mb-3">
                <label class="col-sm-6 col-form-label">4- عقد بين المشتري و المورد</label>
                <div class="col-sm-10">
                    <input type="file" class="form-control" id="contrat" name="contrat">
                </div>
            </div>
            <span> يحتوي على كل البيانات الافصال و الكمية و الثمن و العلامة التجارية للتجهيزات ممضى من قبل الطرفين</span>

            <div class="form-group row mb-3">
                <label class="col-sm-6 col-form-label">5- وثيقة الاعلام بالوصول</label>
                <div class="col-sm-10">
                    <input type="file" class="form-control" id="fichier_arrivage" name="fichier_arrivage">
                </div>      
            </div>
            <span>تسلم من قبل الناقل</span>
            

            <div class="form-group row mb-3">
                <label class="col-sm-6 col-form-label">6- وثيقة الشحن</label>
                <div class="col-sm-10">
                    <input type="file" class="form-control" id="fichier_colisage" name="fichier_colisage">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-6 col-form-label">7- نسخة من بطاقة التعريف الجبائي</label>
                <div class="col-sm-10">
                    <input type="file" class="form-control" id="copie_registre_fiscal" name="copie_registre_fiscal" >
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-6 col-form-label">8- نسخة من مضمون السجل الوطني للمؤسسات</label>
                <div class="col-sm-10">
                    <input type="file" class="form-control" id="copie_registre_national_institutions" name="copie_registre_national_institutions">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-6 col-form-label">9- نسخة من شهادة الملكية </label>
                <div class="col-sm-10">
                    <input type="file" class="form-control" id="copie_certificat_propriete" name="copie_certificat_propriete">
                </div>
            </div>
            <span> او نسخة منعقد بيع او هبة او كراء للعقار الموظف لتركيز المشروع ساري المفعول مسجل بالقباضة المالية</span>

            <div class="form-group row mb-3">
                <label class="col-sm-6 col-form-label">10- تعهد</label>
                <div class="col-sm-10">
                    <input type="file" class="form-control" id="engagement" name="engagement">
                </div>
            </div>
            <span>معرف بالامضاء بعدم التفويت في التجهيزات المقتناة لمدة 5 سنوات مع ذكر التجهيزات بالتفصيل</span>

            <div class="form-group row mb-3">
                <label class="col-sm-6 col-form-label">11- مثال هندسي للمشروع</label>
                <div class="col-sm-10">
                    <input type="file" class="form-control" id="exemple_projet" name="exemple_projet">
                </div>
            </div>
            <span> معد من قبل مهندس معماري يحتوي على مثال لتركيز التجهيزات و يحمل ختمه و امضاءه مع ادراج بيانات المشروع </span>

        </div>   

        <div class="form-group row text-center" style="padding-top:50px;">
            <div class="col-sm-4 mx-auto">
                <button type="submit" class="btn btn-success font-weight-medium" style="width:100px;margin-right:250px;">إرسال</button>
            </div>
            <div class="col-sm-4 mx-auto">
                <a href="" class="btn btn-primary" style="width:100px;margin-left:250px;">
                    <i class="bi bi-arrow-left"></i> رجوع
                </a>
            </div>
        </div>
    </form>
</div>

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
@endsection