<!DOCTYPE html>
<html lang="{{ $lang }}" dir="{{ $direction }}">
<head>
<meta charset="utf-8">
<style>
body {
    font-family: DejaVu Sans;
    font-size: 12px;
    direction: {{ $direction }};
    text-align: {{ $direction == 'rtl' ? 'right' : 'left' }};
    color: #222;
    line-height: 1.6;
}

/* HEADER */
.header {
    border-bottom: 3px solid #c62828;
    margin-bottom: 20px;
    padding-bottom: 10px;
}

.header h3 {
    margin: 0;
    font-size: 17px;
    font-weight: bold;
}

/* SECTION TITLES */
h4 {
    margin: 25px 0 8px;
    padding-bottom: 4px;
    font-size: 14px;
    border-bottom: 2px solid #c62828;
    color: #000;
}

/* SECTIONS */
.section {
    background-color: #ffffff;
    border: 1px solid #ddd;
    border-{{ $direction == 'rtl' ? 'right' : 'left' }}: 5px solid #c62828;
    padding: 12px 14px;
    margin-bottom: 15px;
}

/* ROWS */
.row {
    display: flex;
    flex-wrap: wrap;
    margin-bottom: 8px;
}

.field {
    width: 48%;
    margin-bottom: 8px;
}

/* LABEL + VALUE */
.label {
    font-size: 11px;
    color: #555;
    margin-bottom: 2px;
}

.value {
    font-size: 12px;
    font-weight: 500;
    padding: 4px 0;
    border-bottom: 1px dotted #999;
    min-height: 18px;
}

/* TABLE */
table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 10px;
    font-size: 11.5px;
}

th {
    background-color: #f2f2f2;
    border: 1px solid #000;
    padding: 6px;
    font-weight: bold;
}

td {
    border: 1px solid #000;
    padding: 6px;
}

/* REMARKS */
.remarks-block {
    margin-top: 10px;
    padding: 10px;
    border: 1.5px solid #000;
    min-height: 70px;
    background-color: #fff;
}

.page-break {
    page-break-before: always;
}

.no-break {
    page-break-inside: avoid;
}
</style>
</head>

<body>


<div class="header">
    <table width="100%" style="border: none;">
        <tr>
            <td style="width:120px; text-align:right; border:none;">
                <img src="{{ public_path('storage/logo.png') }}" style="width:90px; height:auto;">
            </td>
            <td style="text-align:center; border:none;">
                <h3></h3>
            </td>
            <td style="width:120px; border:none;"></td>
        </tr>
    </table>
</div>

@php 
    $status1 = $docList->id_statut1 ?? 2;
    $currentMotif = $docList->commentaire_motif1 ?? '';
@endphp

<input disabled type="hidden" name="id_association" value="{{ $association->id_association ?? '' }}">
<input disabled type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
<input disabled type="hidden" name="id_projet" value="{{ $id_projet ?? '' }}">

<h4 style="margin-top:30px;">
   اللجنة الفنية للنظر في مطالب التمويل العمومي
</h4>
         



<div class="section" style="margin-bottom:20px;">
    <div class="row" dir="rtl">
        <!-- Nom association -->
        <div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
                إسم الجمعية }}
            </span>
            <span class="value">
                {{ $docList->projet->demande->association->nom_association ?? '' }}
            </span>
        </div>

        <!-- Type de financement -->
        <div class="field" style="margin-bottom:10px;">
    <span class="label" style="font-weight:bold; display:block; margin-bottom:6px;">
        {{ $formulaire->type_ar }}
    </span>

    <span class="value">
        <table width="100%" cellpadding="2" cellspacing="0">
            <tr>
                @foreach($type_financement as $index => $type)
                    <td width="33%" style="vertical-align: top;">
                        <span style="font-size:14px;">
                            @if(in_array($type->id_type_fin, $selectedTypes))
                               ( نعم  )
                            @else
                              (  لا  ) 
                            @endif
                        </span>
                        <span style="margin-right:6px; color:black;">
                            {{ $type->type_ar }}
                        </span>
                    </td>

                    {{-- nouvelle ligne toutes les 3 colonnes --}}
                    @if(($index + 1) % 3 == 0)
                        </tr><tr>
                    @endif
                @endforeach
            </tr>
        </table>
    </span>
</div>

    </div>
</div>

<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
                المعطيات الخاصة بالجمعية
            </span>
</div>
  


<div class="section" style="margin-bottom:20px;">
    <div class="row" dir="rtl">
        <!-- Nom association -->
        <div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
                عنوان الجمعية
            </span>
            <span class="value">
                {{ old('adresse', $docList->projet->demande->association->adresse ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
               الترقيم البريدي
            </span>
            <span class="value">
                {{ old('code_postal', $docList->projet->demande->association->code_postal ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
               
الهاتف
            </span>
            <span class="value">
                {{ old('tel', $docList->projet->demande->association->tel ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
               الفاكس
            </span>
            <span class="value">
                {{ old('fax', $docList->projet->demande->association->fax ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
               تاريخ التأسيس
            </span>
            <span class="value">
                {{ old('date_creation', $docList->projet->demande->association->date_creation ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
               رقم التأشيرة
            </span>
            <span class="value">
                {{ old('num_visa', $docList->projet->demande->association->num_visa ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
            تاريخ التأشيرة
            </span>
            <span class="value">
                {{ old('date_visa', $docList->projet->demande->association->date_visa ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
               رقم المعرف الجبائي
            </span>
            <span class="value">
                {{ old('num_identification_fiscale', $docList->projet->demande->association->num_identification_fiscale ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
              رقم الحساب الجاري
            </span>
            <span class="value">
                {{ old('num_compte_courant', $docList->projet->demande->association->num_compte_courant ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
              البنك
            </span>
            <span class="value">
                {{ old('banque', $docList->projet->demande->association->banque ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
               البريد الإلكتروني
            </span>
            <span class="value">
                {{ old('adresse_mail', $docList->projet->demande->association->adresse_mail ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
               عنوان موقع الواب
            </span>
            <span class="value">
                {{ old('adresse_site_internet', $docList->projet->demande->association->adresse_site_internet ?? '') }}
            </span>
        </div>
		
		
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
              إسم رئيس الجمعية
            </span>
            <span class="value">
                {{ old('nom_president_association', $docList->projet->demande->association->nom_president_association ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
              الهاتف الشخصي
            </span>
            <span class="value">
                {{ old('tel_personnel', $docList->projet->demande->association->tel_personnel ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
              عدد أعضاء المكتب الوطني للجمعية
            </span>
            <span class="value">
                {{ old('num_membre_bureau_national_a', $docList->projet->demande->association->num_membre_bureau_national_a ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
              عدد المكاتب الجهوية ان وجدت
            </span>
            <span class="value">
                {{ old('num_bureaux_regionaux', $docList->projet->demande->association->num_bureaux_regionaux ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
              عدد المنخرطين الاجمالي
            </span>
            <span class="value">
                {{ old('num_total_membre', $docList->projet->demande->association->num_total_membre ?? '') }}
            </span>
        </div>		
	</div>
</div>
 <div class="page-break"></div>   
<input disabled type="hidden" name="id_formulaire" value="{{ $formulaire2->id_type }}">
<input disabled type="hidden" name="id_demande" value="{{ $demande_id }}">
<h4 style="margin-top:30px;">
مطلب للحصول على التمويل العمومي
</h4>
  
<div class="section" style="margin-bottom:20px;">
    <div class="row" dir="rtl">
        <div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
                المعطيات البيداغوجية
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
               اسم و لقب المشرف على التنفيذ
            </span>
            <span class="value">
                {{ old('nom_prenom_sup', $docList->projet->superviseur->nom_prenom_sup ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
              المهنة
            </span>
            <span class="value">
                {{ old('profession_sup', $docList->projet->superviseur->profession_sup ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
الصفة في الجمعية            </span>
            <span class="value">
                {{ old('role_sup', $docList->projet->superviseur->role_sup ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
الهاتف            </span>
            <span class="value">
                {{ old('tel_sup', $docList->projet->superviseur->tel_sup ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
البريد الالكتروني            </span>
            <span class="value">
               {{ old('email_sup', $docList->projet->superviseur->email_sup ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
اسم المشروع / التظاهرة / النشاط            </span>
            <span class="value">
               {{ old('nom_projet', $docList->projet->nom_projet ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
مبررات الانجاز            </span>
            <span class="value">
               {{ old('justification_realisation', $docList->projet->justification_realisation ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
الأهداف            </span>
            <span class="value">
               {{ old('objectives', $docList->projet->objectives ?? '') }}
            </span>
        </div>
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
وصف الفقرات او المراحل            </span>
            
        </div>
		
<div class="section" style="direction: rtl; text-align: right;">
    <table>
        <thead>
            <tr>
                <th style="width:5%">رقم</th>
                <th style="width:35%">اهم الفقرات او المراحل</th>
                <th style="width:20%">تاريخ الانجاز</th>
                <th style="width:30%">مكان الإنجاز</th>
            </tr>
        </thead>
        <tbody>
            @php
                $phases = $oldPhases ?? [];

                if (empty($phases) && isset($docList->projet->activites)) {
                    $phases = $docList->projet->activites->map(function($phase){
                        return [
                            'description' => $phase->description,
                            'completion_date' => $phase->completion_date,
                            'completion_location' => $phase->completion_location,
                        ];
                    })->toArray();
                }

                if (empty($phases)) {
                    $phases = [[
                        'description' => __('site.financement.messages.no_value'),
                        'completion_date' => __('site.financement.messages.no_value'),
                        'completion_location' => __('site.financement.messages.no_value'),
                    ]];
                }
            @endphp

            @foreach($phases as $i => $p)
                <tr>
                    <td>{{ $i + 1 }}</td>
                    <td>{{ $p['description'] }}</td>
                    <td>{{ $p['completion_date'] }}</td>
                    <td>{{ $p['completion_location'] }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>

<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
الجمهور المستفيد            </span>
            <span class="value">
               {{ old('public', $docList->projet->public ?? '') }}
            </span>
        </div>
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
العدد التقريبي للجمهور            </span>
            <span class="value">
               {{ old('nombre_spectateur', $docList->projet->nombre_spectateur ?? '') }}
            </span>
        </div>

		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
الشريحة العمرية المستهدفة            </span>
            <span class="value">
               {{ old('tranch_age_min', $docList->projet->tranch_age_min ?? '') }}
            </span>
        </div>

		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
              إلى
            </span>
            <span class="value">
               {{ old('tranch_age_max', $docList->projet->tranch_age_max ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
الأطراف المشاركة في الإنجاز            </span>
            <span class="value">
               {{ old('parties_realisation', $docList->projet->parties_realisation ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
النتائج المرتقب تحقيقها            </span>
            
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
1- النتائج الكمية            </span>
            <span class="value">
               {{ old('resultat_quantitatif', $docList->projet->resultat_quantitatif ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
2- النتائج النوعية            </span>
            <span class="value">
              {{ old('resultat_qualitatif', $docList->projet->resultat_qualitatif ?? '') }}
            </span>
        </div>
		
		<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
الآفاق المنتظرة            </span>
            <span class="value">
             {{ old('perspectives', $docList->projet->perspectives ?? '') }}
            </span>
        </div>
		<div class="page-break"></div>
		<div class="field" style="margin-bottom:10px;">
		<h4>الموازنة المالية</h4>
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
الميزانية التقديرية            </span>
            
        </div>
		
		<div class="section" style="direction: rtl; text-align: right;">
    <table>
        <thead>
            <tr>
                <th rowspan="2">الكلفة الجملية التقديرية
<br>(المبلغ بالدينار التونسي)</th>
                <th colspan="2">حجم التمويل الذاتي</th>
                <th colspan="2">حجم الدعم المطلوب من الوزارة</th>
            </tr>
            <tr>
                <th>النسبة المائوية</th>
                <th>المبلغ بالدينار</th>
                <th>المبلغ بالدينار</th>
                <th>النسبة المائوية</th>
            </tr>
        </thead>
        <tbody>
            @php
                $budgets = $docList->projet->estimationBudget ?? [];
            @endphp

            @if(!empty($budgets) && count($budgets) > 0)
                @foreach($budgets as $budget)
                    <tr>
                        <td>{{ $budget->cout_total_estime ?? __('site.financement.messages.no_value') }}</td>
                        <td>{{ $budget->financement_propre_pourcentage ?? __('site.financement.messages.no_value') }}{{ $budget->financement_propre_pourcentage ? '%' : '' }}</td>
                        <td>{{ $budget->financement_propre_montant ?? __('site.financement.messages.no_value') }}</td>
                        <td>{{ $budget->aide_ministere_montant ?? __('site.financement.messages.no_value') }}</td>
                        <td>{{ $budget->aide_ministere_pourcentage ?? __('site.financement.messages.no_value') }}{{ $budget->aide_ministere_pourcentage ? '%' : '' }}</td>
                    </tr>
                @endforeach
            @else
                <tr>
                    <td>-</td>
                    <td>-</td>
                    <td>-</td>
                    <td>-</td>
                    <td>-</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>

			<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
			الأطراف المساهمة في الدعم
            </span>
            
        </div>

<div class="section" style="direction: rtl; text-align: right;">
    <table>
        <thead>
            <tr>
                <th colspan="4" style="font-weight: bold;">الأطراف المساهمة في الدعم</th>
            </tr>
            <tr>
                <th style="width:5%">ع/ر</th>
                <th style="width:40%">الطرف المساهم</th>
                <th style="width:25%">المبلغ بالدينار</th>
                <th style="width:30%">النسبة المائوية</th>
            </tr>
        </thead>
        <tbody>
            @foreach($docList->projet->estimationBudget as $budget)
                @php
                    $supporters = $budget->contributeurs->toArray() ?? [];
                    if (!is_array($supporters) || count($supporters) === 0) {
                        $supporters = [
                            [
                                'name' => __('site.financement.messages.no_value'),
                                'amount' => __('site.financement.messages.no_value'),
                                'percent' => __('site.financement.messages.no_value'),
                            ]
                        ];
                    }
                @endphp

                @foreach($supporters as $i => $supporter)
                    <tr>
                        <td>{{ $i + 1 }}</td>
                        <td>{{ $supporter['name'] ?? $supporter['nom'] ?? __('site.financement.messages.no_value') }}</td>
                        <td>{{ $supporter['amount'] ?? $supporter['montant'] ?? __('site.financement.messages.no_value') }}</td>
                        <td>
                            {{ $supporter['percent'] ?? $supporter['pourcentage'] ?? __('site.financement.messages.no_value') }}
                            @if(isset($supporter['percent']) || isset($supporter['pourcentage']))%
                            @endif
                        </td>
                    </tr>
                @endforeach
            @endforeach
        </tbody>
    </table>
</div>

<div class="field" style="margin-bottom:10px;">
            <span class="label" style="font-weight:bold; display:block; margin-bottom:3px;">
			ابواب صرف الميزانية
            </span>
            
        </div>

<div class="section" style="direction: rtl; text-align: right;">
    <table>
        <thead>
            <tr>
                <th>ع/ر</th>
                <th>الفقرات</th>
                <th>مستلزمات الفقرات</th>
                <th>التكلفة (د)</th>
            </tr>
        </thead>
        <tbody>
            @foreach($docList->projet->estimationBudget as $budget)
                @php
                    $postes = $budget->postesDepense->count() 
                        ? $budget->postesDepense 
                        : [[
                            'libelle_depense' => '-',
                            'description' => '-',
                            'cout' => '-'
                        ]];
                @endphp

                @foreach($postes as $depenseIndex => $depense)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $depense->libelle_depense ?? $depense['libelle_depense'] ?? '' }}</td>
                        <td>{{ $depense->description ?? $depense['description'] ?? '' }}</td>
                        <td>{{ $depense->cout ?? $depense['cout'] ?? '' }}</td>
                    </tr>
                @endforeach
            @endforeach
        </tbody>
    </table>
</div>


		
	</div>
</div>
<div class="page-break"></div>
@php
            $form1_complete = $form1_complete ?? false;
            $form2_complete = $form2_complete ?? false;
        @endphp

        <input disabled type="hidden" name="id_formulaire" value="{{ $formulaire3->id_type }}">
        <input disabled type="hidden" name="id_projet" value="{{ $id_projet }}">

                                
<h4 style="margin-top:30px;">
   
</h4>
         




        <div class="section" style="direction: rtl; text-align: right;">
    <table>
        <thead>
            <tr>
                <th></th>
                <th>الوثائق حسب الامر عدد 5183</th>
                <th>الوثائق</th>
            </tr>
        </thead>
        <tbody>
            @foreach($typedocum as $index => $doc)
                @php
                    $existing = $documents->firstWhere('id_doc', $doc->id_type_doc);
                    $hasFile = $existing && $existing->file;
                @endphp
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $doc->type_ar }}</td>
                    <td>
                        @if(in_array($doc->id_type_doc, [15, 17]))
                            @if($doc->id_type_doc == 15)
                                 ✅ هذا الملف متوفر بالفعل
                            @elseif($doc->id_type_doc == 17)
                                 ✅ هذا الملف متوفر بالفعل
                            @endif
                        @else
                            @if($hasFile)
                                                                            <a href="{{ route('documents_financement.file', $existing->id_doc_fin) }}"
                                               target="_blank" class="btn btn-sm btn-info">
                                                عرض الملف
                                            </a>
                            @else
                              لا يوجد ملف
                            @endif
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>

		
		



          

           
          
  
</body>
</html>
