@extends('backoffice.dashboard')

@section('title', 'إدارة وصف الولايات')

@section('content')

@if(Auth::check())
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0 shadow-sm rounded-3 border-0">

                {{-- Header --}}
                <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
                    <h2 class="widget-title m-0">قائمة وصف الولايات</h2>
                    <a class="btn btn-success btn-sm px-3" href="{{ route('desc_gouvr.create') }}">
                        <i class="la la-plus me-1"></i> إضافة وصف ولاية
                    </a>
                </div>

                {{-- Search --}}
                <div class="block-card-header px-4 border-bottom-0 pb-3">
                    <form method="GET" action="{{ route('desc_gouvr.index') }}">
                        <div class="form-row align-items-center" style="direction: rtl;">
                            <div class="col-auto" style="width: 250px;">
                                <input 
                                    type="text" 
                                    name="q" 
                                    class="form-control" 
                                    placeholder="بحث باسم الولاية بالعربية، الفرنسية أو الإنجليزية" 
                                    value="{{ $search ?? '' }}"
                                >
                            </div>
                            <div class="col d-flex">
                                <button type="submit" class="btn bg-rgb-primary1 font-weight-medium" style="width: 105px;">
                                    بحث
                                </button>
                                <a href="{{ route('desc_gouvr.index') }}"
                                   class="btn bg-rgb-primary1 font-weight-medium d-flex align-items-center justify-content-center"
                                   style="width: 45px; height: 38px; margin-right: 5px; padding: 0;">
                                    <i class="fa-solid fa-rotate-right"></i>
                                </a>
                            </div>
                        </div>
                    </form>
                </div>

                {{-- Body --}}
                <div class="block-card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    <div class="my-table table-responsive" style="direction: rtl; text-align: right;">
                        <table class="table align-items-center table-flush mb-0 table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th>المعرف</th>
                                    <th>المستخدم</th>
                                    <th>الولاية</th>
                                    <th>الصورة الرئيسية</th>
                                    <th>إجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($desc_gouvr as $item)
                                    <tr>
                                        <td>{{ $item->id_desc }}</td>
                                        <td>{{ $item->utilisateur?->nom_prenom ?? 'غير محدد' }}</td>
                                        <td>{{ $item->gouvernorat?->nom_ar ?? 'غير محدد' }}</td>
                                        <td>
                                          @if(!empty($item->image_gouvSrc))
											<img src="{{ $item->image_gouvSrc }}"
												 alt="صورة الولاية"
												 class="rounded shadow-sm border"
												 style="width: 80px; height: 60px; object-fit: cover;">
										@else
											<span class="text-muted">—</span>
										@endif

                                        </td>
                                        <td>
                                            <div class="d-flex justify-content-center gap-2">
                                                <a href="{{ route('desc_gouvr.edit', $item) }}" class="btn-icon btn-icon--warning" title="تعديل">
                                                    <i class="la la-edit"></i>
                                                </a>

                                                <form action="{{ route('desc_gouvr.destroy', $item) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="button"
                                                            onclick="return confirmAction('هل تريد حذف هذا الوصف؟', null, this.closest('form'))"
                                                            class="btn-icon btn-icon--danger"
                                                            title="حذف">
                                                        <i class="la la-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="py-4 text-center text-muted">لا توجد وصف حالياً</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    {{-- Pagination --}}
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        {{ $desc_gouvr->links('pagination::bootstrap-5') }}
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

{{-- SweetAlert Confirm --}}
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: 'تأكيد',
        text: message,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            if (url) {
                window.location.href = url;
            } else if (form) {
                form.submit();
            }
        }
    });
    return false;
}
</script>

<style>
.table-hover th, 
.table-hover td {
    vertical-align: middle;
    text-align: center;
}

.table-hover th:nth-child(2),
.table-hover td:nth-child(2),
.table-hover th:nth-child(3),
.table-hover td:nth-child(3) {
    text-align: right !important;
    direction: rtl;
}

.btn-icon {
    width: 30px;
    height: 30px;
    border-radius: 6px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    border: none;
    cursor: pointer;
    background-color: #f8f9fa;
    font-size: 16px;
    transition: 0.2s;
}

.btn-icon--warning { background-color: #fff3cd; color: #856404; }
.btn-icon--danger { background-color: #f8d7da; color: #dc3545; }
</style>

@else
<script>window.location.href = "{{ route('admin') }}";</script>
@endif

@endsection
