@extends('backoffice.dashboard')

@section('content')
<div class="container py-4">
  <div class="row justify-content-center">
    <div class="col-xl-10">
      <div class="card shadow-sm">
        <div class="card-header d-flex justify-content-between align-items-center" style="direction:rtl;">
          <div>
            <h4 class="mb-0">{{ $concours->titre }}</h4>
            <small class="text-muted">الحالة: {{ $concours->etat_label }} — الفترة: {{ optional($concours->date_debut)->format('Y-m-d') ?? '—' }} إلى {{ optional($concours->date_fin)->format('Y-m-d') ?? '—' }}</small>
          </div>
          <div class="d-flex gap-2">
            <a href="{{ route('concours.edit', $concours) }}" class="btn btn-sm btn-outline-secondary">تعديل</a>
            <a href="{{ route('concours.index') }}" class="btn btn-sm btn-outline-secondary">العودة</a>
          </div>
        </div>

        <div class="card-body">
          <h6 class="mb-2">الحقول المرتبطة</h6>
          <div class="mb-4">
            @if($concours->fields->isEmpty())
              <div class="text-muted">لا توجد حقول مرتبطة.</div>
            @else
              <ul class="list-inline">
                @foreach($concours->fields as $f)
                  <li class="list-inline-item badge bg-light text-dark border">{{ $f->label }} ({{ $f->input_type }})</li>
                @endforeach
              </ul>
            @endif
          </div>

          <h6 class="mb-2">المترشحون ({{ $candidates->total() }})</h6>
          <div class="table-responsive">
            <table class="table table-sm table-hover text-end">
              <thead class="table-light">
                <tr><th>الاسم</th><th>CIN</th><th>البريد</th><th>الحالة</th><th>عرض</th></tr>
              </thead>
              <tbody>
                @forelse($candidates as $cand)
                  <tr>
                    <td>{{ $cand->nom }} {{ $cand->prenom }}</td>
                    <td>{{ $cand->cin ?? '—' }}</td>
                    <td>{{ $cand->email ?? '—' }}</td>
                    <td><span class="badge {{ $cand->etat === 'acceptation_definitif' ? 'bg-success' : ($cand->etat === 'acceptation_primaire' ? 'bg-info text-dark' : 'bg-warning text-dark') }}">{{ $cand->etat_label }}</span></td>
                    <td><a href="{{ route('concours_ext.show', $cand) }}" class="btn btn-sm btn-outline-primary">عرض</a></td>
                  </tr>
                @empty
                  <tr><td colspan="5" class="text-center py-3">لا يوجد مترشحون.</td></tr>
                @endforelse
              </tbody>
            </table>
          </div>

          <div class="mt-3">
            {{ $candidates->links('pagination::bootstrap-5') }}
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection
