@extends('backoffice.dashboard')

@section('content')

@if(Auth::check())

<div class="container-fluid dashboard-inner-body-container">
  <div class="row">
    <div class="col-lg-12">
      <div class="block-card dashboard-card mb-4 px-0">

        <!-- Header -->
        <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
          <h2 class="widget-title pb-0">   قائمة الصفحات الجديدة  </h2>
       
          <a class="btn btn-success font-weight-medium" href="{{ route('builder.create') }}">
            <i class="la la-plus mr-1"></i> إضافة صفحة
          </a>
        </div>

        <!-- Recherche -->
        <div class="block-card-header px-4 border-bottom-0 pb-0">
          <form method="GET" action="{{ route('builder.index') }}">
            <div class="form-row align-items-center">
              <div class="col-auto" style="width: 250px;">
                <input type="text" class="form-control" name="search" placeholder="بحث بالعربية" value="{{ request('search') }}">
              </div>
              
			  
			  <div class="col d-flex">
                <button type="submit" class="btn bg-rgb-primary1 font-weight-medium" style="width: 105px;">بحث</button>
                <a href="{{ route('builder.index') }}"
                        class="btn bg-rgb-primary1 font-weight-medium d-flex align-items-center justify-content-center"
                        style="width: 45px; height: 38px; margin-right: 5px; padding: 0;">
                            <i class="fa-solid fa-rotate-right" style="font-size: 16px;"></i>
                </a>
				<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
				<!--a href="{{ route('builder.index') }}" class="btn bg-rgb-primary1 font-weight-medium" style="width: 105px; margin-right: 5px;">إعادة تعيين</a-->
            </div>
            </div>
          </form>
        </div>

        <!-- Body -->
        <div class="block-card-body">
          @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
              {{ session('success') }}
              <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
          @endif

          <div class="my-table table-responsive" style="direction: rtl; text-align: right;">
            <table class="table align-items-center table-flush mb-0">
              <thead class="thead-light">
                <tr>
                  <th width="2%"></th>
                  <th>المستخدم</th>
                  <th>العنوان بالعربية</th>
                  <th>تاريخ الإنشاء</th>
                  <th width="18%">إجراءات</th>
                </tr>
              </thead>
              <tbody>
                @forelse($builders as $i => $builder)
                  <tr>
                    <td>{{ $builders->firstItem() + $i }}</td>
                    <td>{{ $builder->utilisateur->nom_prenom ?? '-' }}</td>
                    <td>{{ $builder->titre_ar }}</td>
                    <td>{{ \Carbon\Carbon::parse($builder->created_at)->format('d-m-Y') }}</td>
                    <td class="text-center" style="white-space: nowrap;">
                      <div class="actions-cell d-inline-flex gap-2 flex-wrap justify-content-center">
                        <!-- Modifier -->
                        <a href="{{ route('builder.edit', $builder->id_builder) }}" class="btn-icon btn-icon--warning" title="تعديل">
                          <i class="la la-edit"></i>
                        </a>

                        <!-- Supprimer -->
                        <form action="{{ route('builder.destroy', $builder->id_builder) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من الحذف؟');">
                          @csrf
                          @method('DELETE')
                          <button type="button"
                                  onclick="confirmAction('هل تريد حذف هذه الصفحة؟', null, this.closest('form'))"
                                  class="btn-icon btn-icon--danger" 
                                  title="حذف">
                              <i class="la la-trash"></i>
                          </button>

                        </form>

                        
                      </div>
                    </td>
                  </tr>
                @empty
                  <tr>
                    <td colspan="5" class="text-center"> لا توجد صفحات.</td>
                  </tr>
                @endforelse
              </tbody>
            </table>
          </div>

          <!-- Pagination -->
          <div class="mt-3">
            {{ $builders->links('pagination::bootstrap-5') }}
          </div>
        </div>

      </div>
    </div>
  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
  function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: 'تأكيد',
        text: message,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            if (url) {
                window.location.href = url;
            } else if (form) {
                form.submit();
            }
        }
    });
}

</script>

@else
<script> window.location.href = "{{ route('admin') }}"; </script>
@endif

<style>
.my-table table {
    width: 100%;
    border-collapse: separate;
    border-spacing: 0;
    border-radius: 10px;
    overflow: hidden;
    background-color: #fff;
    box-shadow: 0 1px 4px rgba(0, 0, 0, 0.1);
}
.my-table th, .my-table td {
    vertical-align: middle;
    text-align: center;
    padding: 10px 6px;
    border-bottom: 1px solid #e9ecef;
}

/* ==== ACTIONS ==== */
.actions-cell {
    display: flex;
    justify-content: center;
    align-items: center;
    flex-wrap: nowrap;
    gap: 6px;
}

/* Bouton icône compact */
.btn-icon {
    width: 30px;
    height: 30px;
    border-radius: 6px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    font-size: 15px;
    transition: all 0.2s ease;
    border: none;
    background-color: #f8f9fa;
    cursor: pointer;
}
.btn-icon:hover { transform: translateY(-1px); box-shadow: 0 2px 5px rgba(0,0,0,0.15); }
.btn-icon--warning { background-color: #fff3cd; color: #ffc107; }
.btn-icon--danger { background-color: #f8d7da; color: #dc3545; }
</style>

<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
@endsection