@extends('backoffice.dashboard')

@section('content')
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<style>
    body[dir="rtl"] .select2-container--default .select2-selection--single {
        direction: rtl;
        text-align: right;
    }
    
    .reservation-details {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    }
    
    .details-section {
        background: white;
        border-radius: 12px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.08);
        padding: 25px;
        margin-bottom: 25px;
        border-left: 4px solid #b51414;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    
    .details-section:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(0,0,0,0.1);
    }
    
    .section-title {
        color: #2c3e50;
        font-weight: 700;
        font-size: 1.25rem;
        margin-bottom: 20px;
        padding-bottom: 12px;
        border-bottom: 2px solid #f1f3f4;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .section-title i {
        color: #b51414; 
    }
    
    .form-label {
        font-weight: 600;
        color: #34495e;
        margin-bottom: 8px;
        font-size: 0.95rem;
    }
    
    .info-value {
        padding: 10px 15px;
        border: 2px solid #e9ecef;
        border-radius: 8px;
        background-color: #f8f9fa;
        font-size: 0.95rem;
        min-height: 42px;
        display: flex;
        align-items: center;
    }
    
    .tarif-table {
        border-radius: 10px;
        overflow: hidden;
        border: 1px solid #e9ecef;
    }
    
    .tarif-table th {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        color: black;
        border: none;
        padding: 15px;
        font-weight: 600;
    }
    
    .tarif-table td {
        padding: 12px;
        vertical-align: middle;
    }
    
    .resto-card {
        border-radius: 10px;
        border: 2px solid #e9ecef;
        padding: 20px;
        background: white;
        margin-bottom: 15px;
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }
    
    .resto-card::before {
        content: '';
        position: absolute;
        left: 0;
        top: 0;
        height: 100%;
        width: 4px;
        background: #b51414;
    }
    
    .resto-card:hover {
        transform: translateX(5px);
        border-color: #b51414;
        box-shadow: 0 5px 15px rgba(40, 167, 69, 0.1);
    }
    
    .resto-card .resto-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 10px;
    }
    
    .resto-card .resto-name {
        font-weight: 700;
        font-size: 1.1rem;
        color: #2c3e50;
    }
    
    .resto-card .resto-price {
        font-weight: 700;
        font-size: 1.1rem;
        color: #b51414;
    }
    
    .resto-card .resto-desc {
        color: #6c757d;
        font-size: 0.95rem;
        line-height: 1.5;
        margin-top: 8px;
    }

    .resto-card .resto-details {
        font-size: 0.85rem;
        border-top: 1px dashed #eee;
        padding-top: 8px;
        margin-top: 8px;
        color: #6c757d;
    }
    
    .empty-placeholder {
        text-align: center;
        padding: 40px;
        color: #6c757d;
        font-size: 1rem;
        background: #f8f9fa;
        border-radius: 8px;
        border: 2px dashed #dee2e6;
    }
    
    .summary-card {
        border-radius: 12px;
        box-shadow: 0 8px 25px rgba(0,0,0,0.1);
        padding: 25px;
        background: white;
        position: sticky;
        top: 20px;
    }
    
    .summary-card h5 {
        color: #2c3e50;
        font-weight: 700;
        margin-bottom: 20px;
        padding-bottom: 15px;
        border-bottom: 2px solid #f1f3f4;
    }
    
    .summary-item {
        display: flex;
        justify-content: space-between;
        margin-bottom: 12px;
        padding: 8px 0;
        border-bottom: 1px dashed #e9ecef;
    }
    
    .summary-item:last-child {
        border-bottom: none;
    }
    
    .summary-label {
        color: #6c757d;
    }
    
    .summary-value {
        font-weight: 600;
        color: #2c3e50;
    }
    
    .summary-total {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        color: black;
        padding: 20px;
        border-radius: 10px;
        margin-top: 20px;
        text-align: center;
    }
    
    .summary-total .amount {
        font-size: 2rem;
        font-weight: 700;
        margin: 10px 0;
    }
    
    /* Status badges */
    .status-badge {
        padding: 8px 16px;
        border-radius: 20px;
        font-weight: 600;
        font-size: 0.9rem;
        display: inline-block;
        text-align: center;
        min-width: 80px;
    }
    
    .status-badge--pending {
        background-color: #fff3cd;
        color: #856404;
        border: 1px solid #ffeaa7;
    }
    
    .status-badge--success {
        background-color: #d4edda;
        color: #155724;
        border: 1px solid #c3e6cb;
    }
    
    .status-badge--danger {
        background-color: #f8d7da;
        color: #721c24;
        border: 1px solid #f5c6cb;
    }
    
    .rejection-reason {
        background-color: #f8f9fa;
        border-left: 4px solid #dc3545;
        padding: 15px;
        border-radius: 8px;
        margin-top: 15px;
    }
    
    .rejection-reason strong {
        color: #dc3545;
        font-size: 0.95rem;
        display: block;
        margin-bottom: 8px;
    }
    
    .notes-box {
        background-color: #f8f9fa;
        border: 2px solid #e9ecef;
        border-radius: 8px;
        padding: 15px;
        min-height: 120px;
        white-space: pre-wrap;
        line-height: 1.6;
        font-size: 0.95rem;
    }
    
    .back-button {
        background: linear-gradient(135deg, #cf9090 0%, #bb2323 100%);
        border: none;
        padding: 15px 40px;
        font-size: 1.1rem;
        font-weight: 600;
        border-radius: 10px;
        transition: all 0.3s ease;
        width: 100%;
        margin-top: 20px;
        color: white;
        text-decoration: none;
        display: block;
        text-align: center;
    }
    
    .back-button:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(40, 167, 69, 0.3);
        color: white;
    }
    
    .status-form-card {
        background: white;
        border-radius: 12px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.08);
        padding: 25px;
        margin-bottom: 25px;
        border-left: 4px solid #1a237e;
    }
    
    .status-form-card .form-control {
        padding: 10px 15px;
        border: 2px solid #e9ecef;
        border-radius: 8px;
    }
    
    .status-form-card .btn-submit {
        background: linear-gradient(135deg, #1a237e 0%, #283593 100%);
        border: none;
        padding: 12px;
        font-weight: 600;
        border-radius: 8px;
        color: white;
        width: 100%;
        transition: all 0.3s ease;
    }
    
    .status-form-card .btn-submit:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 15px rgba(26, 35, 126, 0.3);
    }
    
    @media (max-width: 768px) {
        .details-section {
            padding: 20px 15px;
        }
        
        .summary-card {
            position: static;
            margin-top: 30px;
        }
        
        .tarif-table {
            font-size: 0.85rem;
        }
        
        .tarif-table th,
        .tarif-table td {
            padding: 8px 5px;
        }
    }

    .calc-info {
        background-color: #f8f9fa;
        border-left: 4px solid #b51414;
        padding: 10px 15px;
        margin-bottom: 15px;
        border-radius: 5px;
        font-size: 0.9rem;
    }
</style>

@php
    // Calculer le nombre de nuits
    $nights = 0;
    if ($reservation->date_arrive && $reservation->date_depart) {
        try {
            $nights = \Carbon\Carbon::parse($reservation->date_arrive)
                ->diffInDays(\Carbon\Carbon::parse($reservation->date_depart));
        } catch (Exception $e) {
            $nights = 0;
        }
    }

    // Fonction pour gérer la pluralisation en arabe pour les nuits
    function getNightsTextArabic($nights) {
        if ($nights === 1) {
            return 'ليلة';
        } else if ($nights === 2) {
            return 'ليلتين';
        } else if ($nights >= 3 && $nights <= 10) {
            return 'ليالي';
        } else {
            return 'ليلة';
        }
    }

    // Fonction pour gérer la pluralisation en arabe pour les personnes
    function getPersonsTextArabic($persons) {
        if ($persons === 1) {
            return 'شخص';
        } else if ($persons === 2) {
            return 'شخصين';
        } else if ($persons >= 3 && $persons <= 10) {
            return 'أشخاص';
        } else {
            return 'شخص';
        }
    }
@endphp

<div class="container mt-4" dir="rtl">
    <div class="card p-4 shadow-sm">
      
        <div class="text-center mb-5">
            <h1 class="mb-3" style="color: #d82b2a;">
                تفاصيل الحجز
            </h1>
        </div>
        
        <div class="row">
            <div class="col-lg-8">
                <!-- Section Informations Personnelles -->
                <div class="details-section">
                    <h4 class="section-title">
                        <i class="bi bi-person-circle"></i>
                        المعلومات الشخصية
                    </h4>
                    <div class="row">
                        <div class="col-md-6 mb-4">
                            <label class="form-label">الإسم و اللقب</label>
                            <div class="info-value">
                                {{ $reservation->user->nom_prenom ?? '-' }}
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-4">
                            <label class="form-label">البريد الإلكتروني</label>
                            <div class="info-value">
                                {{ $reservation->user->email ?? '-' }}
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-4">
                            <label class="form-label">رقم الهاتف</label>
                            <div class="info-value">
                                {{ $reservation->user->tel ?? '-' }}
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-4">
                            <label class="form-label">العنوان</label>
                            <div class="info-value">
                                {{ $reservation->user->adresse ?? '-' }}
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Section Dates de Séjour -->
                <div class="details-section">
                    <h4 class="section-title">
                        <i class="bi bi-calendar-check"></i>
                        تواريخ الإقامة
                    </h4>
                    <div class="row">
                        <div class="col-md-6 mb-4">
                            <label class="form-label">تاريخ الوصول</label>
                            <div class="info-value">
                                {{ $reservation->date_arrive ?? '-' }}
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-4">
                            <label class="form-label">تاريخ المغادرة</label>
                            <div class="info-value">
                                {{ $reservation->date_depart ?? '-' }}
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-4">
                            <label class="form-label">عدد الليالي</label>
                            <div class="info-value">
                                {{ $nights }} {{ getNightsTextArabic($nights) }}
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-4">
                            <label class="form-label">عدد النزلاء</label>
                            <div class="info-value">
                                {{ $reservation->nbr_personnes ?? 0 }} {{ getPersonsTextArabic($reservation->nbr_personnes ?? 0) }}
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Section Détails des Personnes -->
                <div class="details-section">
                    <h4 class="section-title">
                        <i class="bi bi-people-fill"></i>
                        تفاصيل الأشخاص
                    </h4>
                    <div class="row mb-4">
                        <div class="col-md-4 mb-3">
                            <label class="form-label">إجمالي الرجال</label>
                            <div class="info-value text-center">
                                {{ $reservation->nbr_h ?? 0 }}
                            </div>
                        </div>
                        
                        <div class="col-md-4 mb-3">
                            <label class="form-label">إجمالي النساء</label>
                            <div class="info-value text-center">
                                {{ $reservation->nbr_f ?? 0 }}
                            </div>
                        </div>
                        
                        <div class="col-md-4 mb-3">
                            <label class="form-label">إجمالي الأشخاص</label>
                            <div class="info-value text-center">
                                {{ $reservation->nbr_personnes ?? 0 }}
                            </div>
                        </div>
                    </div>
                    
                    @if($reservation->reservationPersons && $reservation->reservationPersons->count() > 0)
                        <h6 class="mb-3">التفاصيل حسب النوع</h6>
                        
                        <div class="table-responsive">
                            <table class="table tarif-table">
                                <thead>
                                    <tr>
                                        <th>نوع الوفد</th>
                                        <th>نوع الإقامة</th>
                                        <th>رجال</th>
                                        <th>نساء</th>
                                        <th>التعريفة للفرد</th>
                                        <th>المجموع الفرعي</th>
                                        <th>إجمالي الأشخاص</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($reservation->reservationPersons as $person)
                                        @php
                                            $totalPersonnes = ($person->nbr_hommes ?? 0) + ($person->nbr_femmes ?? 0);
                                            
                                            if (!isset($person->tarif) || $person->tarif == 0) {
                                                if ($person->typeTarif) {
                                                    $person->tarif = $person->typeTarif->tarif_chambre ?? 0;
                                                }
                                            }
                                            
                                            if (!isset($person->subtotal) || $person->subtotal == 0) {
                                                $person->subtotal = ($person->tarif ?? 0) * $totalPersonnes;
                                            }
                                        @endphp
                                        <tr>
                                            <td>
                                                @if($person->typeTarif ?? false)
                                                    @php
                                                        $typeName = $person->typeTarif->type_ar ?? $person->typeTarif->type_fr ?? $person->typeTarif->type_en ?? '';
                                                        $type = $person->typeTarif->type ?? '';
                                                    @endphp
                                                    
                                                    {{ $typeName }}
                                                    @if($type == 'groupe')
                                                        (مجموعة)
                                                    @else
                                                        (فردي)
                                                    @endif
                                                @else
                                                    لا توجد قيمة
                                                @endif
                                            </td>
                                            <td>
                                                غرفة
                                            </td>
                                            <td>{{ $person->nbr_hommes ?? 0 }}</td>
                                            <td>{{ $person->nbr_femmes ?? 0 }}</td>
                                            <td>{{ number_format($person->tarif ?? 0, 3) }} د</td>
                                            <td>{{ number_format($person->subtotal ?? 0, 3) }} د</td>
                                            <td>{{ $totalPersonnes }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="empty-placeholder">
                            لم يتم إدخال تفاصيل الأشخاص بعد
                        </div>
                    @endif
                </div>
                
                <!-- Section Services Restauration -->
                <div class="details-section">
                    <h4 class="section-title">
                        <i class="bi bi-cup-hot"></i>
                        خدمات الطعام
                    </h4>
                    
                    <div class="calc-info">
                        <i class="bi bi-info-circle"></i>
                        خدمات الطعام تحسب لكل شخص ولكل ليلة
                    </div>
                    
                    @php
                        $selectedIds = $reservation->restaurations->pluck('id_rest')->toArray();
                        $nbrPersons = $reservation->nbr_personnes ?? 0;
                    @endphp
                    
                    @if($nights > 0 && $nbrPersons > 0)
                        <div class="alert alert-info mb-3 py-2">
                            <small>
                                <i class="bi bi-calculator"></i>
                                الحساب: {{ $nbrPersons }} {{ getPersonsTextArabic($nbrPersons) }} × {{ $nights }} {{ getNightsTextArabic($nights) }}
                            </small>
                        </div>
                    @endif
                    
                    @foreach($restaurations as $res)
                        <div class="form-check mb-2">
                            <input class="form-check-input" type="checkbox"
                                id="resto_{{ $res->id_rest }}"
                                @if(in_array($res->id_rest, $selectedIds)) checked @endif
                                disabled>
                            <label class="form-check-label" for="resto_{{ $res->id_rest }}">
                                {{ $res->nom_ar }}
                                <small class="small-muted d-block">{{ number_format($res->tarif, 3) }} د (لكل شخص ولكل ليلة)</small>
                            </label>
                        </div>
                    @endforeach
                    
                    <div id="restoDetails" class="mt-3">
                        @if($reservation->restaurations->isEmpty())
                            <div class="empty-placeholder">لا توجد خدمات إضافية</div>
                        @else
                            @foreach($reservation->restaurations as $resto)
                                @php
                                    $prixUnitaire = $resto->pivot->tarif ?? $resto->tarif ?? 0;
                                    $totalResto = $prixUnitaire * $nbrPersons * $nights;
                                @endphp
                                <div class="resto-card">
                                    <div class="resto-header">
                                        <div class="resto-name">{{ $resto->nom_ar }}</div>
                                        <div class="resto-price">{{ number_format($totalResto, 3) }} د</div>
                                    </div>
                                    @if($resto->description_ar ?? false)
                                        <div class="resto-desc">{!! nl2br(e($resto->description_ar ?? '—')) !!}</div>
                                    @endif
                                    <div class="resto-details">
                                        <small>
                                            {{ number_format($prixUnitaire, 3) }} د × {{ $nbrPersons }} {{ getPersonsTextArabic($nbrPersons) }} × {{ $nights }} {{ getNightsTextArabic($nights) }}
                                        </small>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>
                
                <!-- Section Remarques -->
                <div class="details-section">
                    <h4 class="section-title">
                        <i class="bi bi-chat-left-text"></i>
                        الملاحظات
                    </h4>
                    <div class="notes-box">
                        {{ $reservation->remarque ?: '—' }}
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4">
                <div class="summary-card">
                    <h5 class="mb-4">
                        <i class="bi bi-receipt"></i>
                        ملخص الحجز
                    </h5>
                    
                    <div class="summary-item">
                        <span class="summary-label">المركز:</span>
                        <span class="summary-value">
                            @if($reservation->auberge)
                                {{ $reservation->auberge->nom_ar ?? '-' }}
                            @else
                                لا توجد قيمة
                            @endif
                        </span>
                    </div>
                    
                    <div class="summary-item">
                        <span class="summary-label">عدد الليالي:</span>
                        <span class="summary-value">
                            {{ $nights }} {{ getNightsTextArabic($nights) }}
                        </span>
                    </div>
                    
                    <div class="summary-item">
                        <span class="summary-label">عدد النزلاء:</span>
                        <span class="summary-value">
                            {{ $reservation->nbr_personnes ?? 0 }} {{ getPersonsTextArabic($reservation->nbr_personnes ?? 0) }}
                        </span>
                    </div>
                    
                    @php
                        // Calcul du total des services de restauration (prix × personnes × nuits)
                        $restoTotal = 0;
                        if ($reservation->restaurations && $reservation->restaurations->count() > 0) {
                            foreach ($reservation->restaurations as $resto) {
                                $prixUnitaire = $resto->pivot->tarif ?? $resto->tarif ?? 0;
                                $restoTotal += $prixUnitaire * $nbrPersons * $nights;
                            }
                        }
                    @endphp
                    
                    <div class="summary-item">
                        <span class="summary-label">خدمات الطعام:</span>
                        <span class="summary-value">
                            {{ number_format($restoTotal, 3) }} د
                        </span>
                    </div>
                    
                    <div class="summary-item">
                        <span class="summary-label">التعريفة لليلة:</span>
                        <span class="summary-value">
                            @php
                                $tarifNuit = 0;
                                if ($reservation->reservationPersons && $reservation->reservationPersons->count() > 0) {
                                    foreach ($reservation->reservationPersons as $person) {
                                        $tarifNuit += $person->subtotal ?? 0;
                                    }
                                }
                                
                                if ($tarifNuit == 0 && $reservation->total_price > 0 && $nights > 0) {
                                    $tarifNuit = ($reservation->total_price - $restoTotal) / $nights;
                                }
                                
                                if ($tarifNuit == 0 && $reservation->nbr_personnes > 0) {
                                    $prixMoyenParPersonne = 30;
                                    $tarifNuit = $reservation->nbr_personnes * $prixMoyenParPersonne;
                                }
                            @endphp
                            {{ number_format($tarifNuit, 3) }} د
                        </span>
                    </div>
                    
                    <div class="summary-item">
                        <span class="summary-label">إجمالي الإقامة:</span>
                        <span class="summary-value">
                            @php
                                $totalHebergement = $tarifNuit * $nights;
                            @endphp
                            {{ number_format($totalHebergement, 3) }} د
                        </span>
                    </div>
                    
                    <div class="summary-total">
                        <div class="summary-label">السعر الإجمالي</div>
                        <div class="amount">
                            @php
                                // Utiliser total_price s'il existe, sinon calculer
                                $totalFinal = $reservation->total_price ?? ($totalHebergement + $restoTotal);
                            @endphp
                            {{ number_format($totalFinal, 3) }} د
                        </div>
                    </div>
                    
                    <div class="mt-4">
                        <div class="summary-item">
                            <span class="summary-label">حالة الحجز:</span>
                            <span class="summary-value">
                                @php
                                    $statut = $reservation->statut?->statut_ar ?? 'في الانتظار';
                                    $badgeClass = 'status-badge--pending';
                                    
                                    if ($reservation->statut_id == 1) {
                                        $badgeClass = 'status-badge--success';
                                    } elseif ($reservation->statut_id == 3) {
                                        $badgeClass = 'status-badge--danger';
                                    }
                                @endphp
                                
                                <span class="status-badge {{ $badgeClass }}">
                                    {{ $statut }}
                                </span>
                            </span>
                        </div>
                        
                        @if($reservation->statut_id == 3 && !empty($reservation->commentaire_motif))
                            <div class="rejection-reason">
                                <strong>سبب الرفض:</strong>
                                <p class="mb-0">{{ $reservation->commentaire_motif }}</p>
                            </div>
                        @endif
                        
                        @if($reservation->statut_id == 1 && $reservation->date_acceptation)
                            <div class="summary-item">
                                <span class="summary-label">تاريخ القبول:</span>
                                <span class="summary-value">{{ $reservation->date_acceptation }}</span>
                            </div>
                        @endif
                    </div>
                    
                    <a href="{{ route('reservation.index') }}" class="back-button">
                        <i class="bi bi-arrow-left"></i>
                        رجوع إلى قائمة الحجوزات
                    </a>
                    
                    <br><br>
                    
                    @if($reservation->statut_id == 2)
                        @php
                            $currentStatus = old('statut_id', $reservation->statut_id ?? '');
                            $currentMotif  = old('commentaire_motif', $reservation->commentaire_motif ?? '');
                        @endphp

                        <div class="status-form-card">
                            <h5 class="mb-3 fw-bold">الوضعية الحالية</h5>
                            
                            <p class="text-muted mb-3">
                                يمكنك تعديل وضعية الحجز من هنا:
                            </p>
                            
                            <form action="{{ route('reservation.updateStatus', $reservation->id_reserv) }}" method="POST" id="statusForm">
                                @csrf
                                @method('PUT')
                                
                                <label class="form-label fw-bold">تغيير الوضعية</label>
                                <select class="form-control" id="statut_id" name="statut_id" onchange="toggleMotifInputReservation()">
                                    <option value="">اختر...</option>
                                    <option value="1" {{ $currentStatus == 1 ? 'selected' : '' }}>قبول</option>
                                    <option value="3" {{ $currentStatus == 3 ? 'selected' : '' }}>رفض</option>
                                </select>
                                
                                <div class="mt-3 d-none" id="motifDiv">
                                    <label class="form-label text-danger fw-bold">سبب الرفض</label>
                                    <textarea name="commentaire_motif" id="commentaire_motif_textarea" class="form-control border-danger" maxlength="150" rows="3">{{ $currentMotif }}</textarea>
                                    <small>
                                        <span id="count">0</span> / 150 
                                    </small>
                                </div>
                                
                                <button type="submit" class="btn-submit mt-3">
                                    تحديث الوضعية
                                </button>
                            </form>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
// Définir la fonction globalement
function toggleMotifInputReservation() {
    let status = document.getElementById("statut_id").value;
    let motifDiv = document.getElementById("motifDiv");
    let motifTextarea = document.getElementById("commentaire_motif_textarea");
    
    if (motifDiv) {
        if (status == 3) {
            motifDiv.classList.remove("d-none");
            if (motifTextarea) {
                motifTextarea.required = true;
            }
        } else {
            motifDiv.classList.add("d-none");
            if (motifTextarea) {
                motifTextarea.required = false;
            }
        }
    }
}

$(document).ready(function () {
    // Exécuter la fonction au chargement de la page
    toggleMotifInputReservation();
    
    // Compteur de caractères pour le motif de refus
    const textarea = document.getElementById('commentaire_motif_textarea');
    const count = document.getElementById('count');
    
    if (textarea && count) {
        count.textContent = textarea.value.length;
        
        textarea.addEventListener('input', () => {
            count.textContent = textarea.value.length;
        });
    }
    
    // Mettre en surbrillance la section actuelle
    $('.details-section').hover(
        function() {
            $(this).css('border-left-color', '#b51414');
        },
        function() {
            $(this).css('border-left-color', '#b51414');
        }
    );
    
    // Animation des cartes de restauration
    $('.resto-card').hover(
        function() {
            $(this).css('transform', 'translateX(5px)');
        },
        function() {
            $(this).css('transform', 'translateX(0)');
        }
    );
    
    // Validation côté client du formulaire
    $('form').on('submit', function(e) {
        let status = $('#statut_id').val();
        let motif = $('#commentaire_motif_textarea').val();
        
        if (status == 3 && (!motif || motif.trim() === '')) {
            e.preventDefault();
            alert('الرجاء إدخال سبب الرفض');
            $('#commentaire_motif_textarea').focus();
            return false;
        }
    });
});
</script>
@endsection