@extends('backoffice.dashboard')
@section('content')
<style>
    .btn-success-custom {
        background-color: green;
        color: white;
    }

    .btn-success-custom i { color: white; }

    .btn-orange {
        background-color: orange;
        color: white;
    }

    .btn-orange i { color: white; }



    .actions-cell {
    display: flex;
    justify-content: center;
    align-items: center;
    flex-wrap: nowrap; /* ❗ empêche le passage à la ligne */
    gap: 6px; /* espace entre boutons réduit */
}

/* Bouton icône compact */
.btn-icon {
    width: 30px;       /* plus petit */
    height: 30px;
    border-radius: 6px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    font-size: 15px;   /* icône plus fine */
    transition: all 0.2s ease;
    border: none;
    background-color: #f8f9fa;
    cursor: pointer;
}

/* Effet hover */
.btn-icon:hover {
    transform: translateY(-1px);
    box-shadow: 0 2px 5px rgba(0,0,0,0.15);
}

/* Couleurs pastel */
.btn-icon--primary {
    background-color: #e3f2fd;
    color: #0d6efd;
}
.btn-icon--warning {
    background-color: #fff3cd;
    color: #ffc107;
}
.btn-icon--danger {
    background-color: #f8d7da;
    color: #dc3545;
}
.btn-icon--secondary {
    background-color: #e2e3e5;
    color: #6c757d;
}
.btn-icon--info {
    background-color: #d1ecf1;
    color: #0c5460;
}

</style>

<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0">
                <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
                    <h2 class="widget-title pb-0"> إدارة المركبات و مراكز اقامة الشباب </h2>
                    <a class="btn btn-success font-weight-medium" href="{{ route('auberges.create') }}">
                        <i class="la la-plus mr-1"></i> إضافة
                    </a>
                </div>

                <div class="block-card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    <div class="my-table table-responsive">
                        <table class="table align-items-center table-flush mb-0">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th>الإسم</th>
                                    <th>الإسم واللقب المدير</th>
                                    <th>الولاية</th>
                                    <th>المعتمدية</th>
                                    <th>العنوان</th>
                                    <th>إجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($auberges as $index => $auberge)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $auberge->nom }}</td>
                                        <td>{{ $auberge->nom_directeur }}</td>
                                        <td>{{ $auberge->gouvernorat?->nom_ar ?? '-' }}</td>
                                        <td>{{ $auberge->delegation?->nom_ar ?? '-' }}</td>
                                        <td>{{ $auberge->adresse }}</td>
                                        <td class="btn-group">

                                            <a href="{{ route('auberges.show', $auberge->id) }}"
                                                class="btn-icon btn-icon--primary"
                                                title="عرض" aria-label="عرض">
                                                <i class="la la-eye"></i>
                                            </a>

                                            <button type="button"
                                                    class="btn-icon btn-icon--warning"
													onclick="window.location='{{ route('auberges.edit', $auberge->id) }}'"
                                                    title="تعديل" aria-label="تعديل">
                                                <i class="la la-edit"></i>
                                            </button>

                                            <form action="{{ route('auberges.destroy', $auberge->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="button"
                                                        onclick="return confirmAction('هل تريد حقًا حذف هذه المركز؟', null, this.closest('form'))"
                                                        class="btn-icon btn-icon--danger"
                                                        title="حذف" aria-label="حذف">
                                                    <i class="la la-trash"></i>
                                                </button>
                                            </form>

                                            <a href="{{ route('chambres.index', $auberge->id) }}"
                                            class="btn-icon btn-icon--info"
                                            title="الغرف" aria-label="الغرف">
                                                <i class="la la-bed"></i>
                                            </a>

                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center">لا توجد دور إقامة حاليا</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                  
					<div class="d-flex justify-content-between align-items-center mt-3">
						{{ $auberges->links('pagination::bootstrap-5') }} 
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<div id="back-to-top">
    <i class="la la-arrow-up" title="Go top"></i>
</div>

@endsection
