@extends('backoffice.dashboard')
@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">

@if(Auth::check())

<div class="container">
    <style>
        .numero-cadre {
            display: inline-block;
            width: 25px;
            height: 25px;
            line-height: 25px;
            margin-right: 5px;
            text-align: center;
            border-radius: 5px;
            font-family: Arial, sans-serif;
            font-weight: bold;
            font-size: 12px;
            color: #ffffff;
            background-color: #d82b2a;
            vertical-align: middle;
        }
    </style>
    
    <form action="{{ route('auberges.update', $auberge->id) }}" method="POST" enctype="multipart/form-data" lang="ar" class="needs-validation" novalidate>
        @csrf
        @method('PUT')  {{-- Important pour update --}}
        
        <h3 class="mb-4 text-center"> تعديل معلومات مركب أو مركز إقامة </h3>
        <h4 class="mt-3">المعطيات</h4>

        <div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label"> الإسم بالعربية<span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input name="nom_ar" type="text" class="form-control @error('nom_ar') is-invalid @enderror" maxlength="100" required
					   value="{{ old('nom_ar', $auberge->nom_ar) }}">
				@error('nom_ar')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label"> الإسم بالفرنسية<span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input name="nom_fr" type="text" class="form-control @error('nom_fr') is-invalid @enderror" maxlength="100" required
					   value="{{ old('nom_fr', $auberge->nom_fr) }}">
				@error('nom_fr')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label"> الإسم بالإنقليزية<span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input name="nom_en" type="text" class="form-control @error('nom_en') is-invalid @enderror" maxlength="100" required
					   value="{{ old('nom_en', $auberge->nom_en) }}">
				@error('nom_en')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label"> الصبغة <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select name="epa" class="form-control @error('epa') is-invalid @enderror" required>
					<option value="">-- اختر الصبغة --</option>
					<option value="EPA" {{ old('epa', $auberge->epa) == 'EPA' ? 'selected' : '' }}>EPA</option>
					<option value="Non EPA" {{ old('epa', $auberge->epa) == 'Non EPA' ? 'selected' : '' }}>Non EPA</option>
				</select>
				@error('epa')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>


        <div class="form-group mt-3">
			<label for="description_ar" class="col-sm-6 col-form-label">تعريف المركز بالعربية<span class="text-danger">*</span></label>
			<textarea name="description_ar" id="description_ar" maxlength="2000" required class="form-control @error('description_ar') is-invalid @enderror" rows="4">{{ old('description_ar', $auberge->description_ar ?? '') }}</textarea>
			@error('description_ar')
				<span class="text-danger small">{{ $message }}</span>
			@enderror
		</div>

		<div class="form-group mt-3">
			<label for="description_fr" class="col-sm-6 col-form-label">تعريف المركز بالفرنسية<span class="text-danger">*</span></label>
			<textarea name="description_fr" id="description_fr" maxlength="2000" required class="form-control @error('description_fr') is-invalid @enderror" rows="4">{{ old('description_fr', $auberge->description_fr ?? '') }}</textarea>
			@error('description_fr')
				<span class="text-danger small">{{ $message }}</span>
			@enderror
		</div>

		<div class="form-group mt-3">
			<label for="description_en" class="col-sm-6 col-form-label">تعريف المركز بالإنقليزية<span class="text-danger">*</span></label>
			<textarea name="description_en" id="description_en" maxlength="2000" required class="form-control @error('description_en') is-invalid @enderror" rows="4">{{ old('description_en', $auberge->description_en ?? '') }}</textarea>
			@error('description_en')
				<span class="text-danger small">{{ $message }}</span>
			@enderror
		</div>

		<!--div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">خط العرض (Latitude)<span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="latitude" class="form-control @error('latitude') is-invalid @enderror" required
					   value="{{ old('latitude', $auberge->latitude ?? '') }}"
					   placeholder="مثلاً: 36.8065"
					value="{{ old('latitude') }}" 
					 id="latitudeInput"
				>
				<span id="latitudeError" class="text-danger small"></span>
				@error('latitude')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label">خط الطول (Longitude)<span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="longitude" class="form-control @error('longitude') is-invalid @enderror" required
					   value="{{ old('longitude', $auberge->longitude ?? '') }}"
					   placeholder="مثلاً: 10.1815" id="longitudeInput"
				>
				<span id="longitudeError" class="text-danger small"></span>
				@error('longitude')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div-->

		<!--div class="row mt-3">
			<div class="col-12">
				<h5 class="text-end">تحديد موقع المركز على الخريطة</h5>
			</div>
		</div>
		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">X (خط العرض) تلقائي<span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="x"class="form-control @error('x') is-invalid @enderror" required placeholder="مثلاً: 36.8065"
					   value="{{ old('x', $auberge->x) }}" id="xInput"
				>
				<span id="xError" class="text-danger small"></span>
				@error('x')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
			<label class="col-sm-2 col-form-label">Y (خط الطول) تلقائي<span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="y" class="form-control @error('y') is-invalid @enderror" required
					   value="{{ old('y', $auberge->y ?? '') }}"
					   placeholder="مثلاً: 10.1815" id="yInput"
				>
				<span id="yError" class="text-danger small"></span>
				@error('y')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div-->
		
		
		
<div class="row mt-3">
    <div class="col-12">
        <h5 class="text-end">تحديد موقع المركز على الخريطة</h5>
    </div>
</div>
<div class="row mt-3 text-end">
    <div class="col-sm-12">
        <div class="mb-3">
            <label for="map_link" class="form-label fw-bold">رابط موقع المركز على Google Maps <span class="text-danger">*</span></label>
            <!--input type="url" 
                   id="map_link" 
                   name="map_link" 
                   class="form-control @error('map_link') is-invalid @enderror" 
                   placeholder="مثال: https://www.google.com/maps/place/..."
                   value="{{ old('map_link', $auberge->map_link ?? '') }}" 
                   required
                   maxlength="500"
                   pattern="^(https?:\/\/)?(www\.)?(google\.[a-z]{2,3}(\.[a-z]{2})?\/maps\/|maps\.google\.[a-z]{2,3}(\.[a-z]{2})?\/|goo\.gl\/maps\/|maps\.app\.goo\.gl\/).*"
                   title="يجب أن يكون رابط صحيح من Google Maps (مثال: https://www.google.com/maps/place/...)"
            -->
			
			<input type="url" 
       id="map_link" 
       name="map_link" 
       class="form-control @error('map_link') is-invalid @enderror" 
       placeholder="مثال: https://www.google.com/maps/place/... أو https://www.google.com/maps/embed?..."
       value="{{ old('map_link', $auberge->map_link ?? '') }}" 
       required
       maxlength="500"
       title="يجب أن يكون رابط صحيح من Google Maps (مثال: https://www.google.com/maps/place/... أو https://www.google.com/maps/embed?...)"
>
            <div class="d-flex justify-content-between align-items-center mt-1">
                <small class="form-text text-muted">
                    الرجاء نسخ الرابط الكامل من موقع المركز على Google Maps
                </small>
                <small id="charCount" class="text-muted">0/500</small>
            </div>
            <!-- Message d'erreur personnalisé -->
            <div id="map_link_error" class="invalid-feedback" style="display: none;">
                الرابط غير صحيح. يجب أن يكون رابط Google Maps مثل: 
                https://www.google.com/maps/place/... أو https://goo.gl/maps/...
            </div>
            @error('map_link')
                <div class="invalid-feedback d-block">
                    {{ $message }}
                </div>
            @enderror
        </div>
    </div>
</div>

<!-- Script de validation en temps réel amélioré -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const mapLinkInput = document.getElementById('map_link');
    const charCount = document.getElementById('charCount');
    const mapLinkError = document.getElementById('map_link_error');
    
    if (mapLinkInput) {
        // Fonction améliorée pour vérifier les liens Google Maps
        function isValidGoogleMapsLink(url) {
            url = url.trim().toLowerCase();
            
            // Liste des patterns Google Maps acceptés
            /*const googleMapsPatterns = [
                /^(https?:\/\/)?(www\.)?(google\.[a-z]{2,3}(\.[a-z]{2})?\/maps\/)/,
                
                /^(https?:\/\/)?(maps\.google\.[a-z]{2,3}(\.[a-z]{2})?\/)/,
                
                /^(https?:\/\/)?(goo\.gl\/maps\/)/,
                
                /^(https?:\/\/)?(maps\.app\.goo\.gl\/)/,
                
                /^(https?:\/\/)?(www\.)?(google\.[a-z]{2,3}(\.[a-z]{2})?\/maps\?q=)/,
                
                /^(https?:\/\/)?(www\.)?(google\.[a-z]{2,3}(\.[a-z]{2})?\/maps\/dir\/)/
            ];*/
			
			// Ajoutez ce pattern à la liste des patterns
			const googleMapsPatterns = [
				// Format standard: https://www.google.com/maps/place/...
				/^(https?:\/\/)?(www\.)?(google\.[a-z]{2,3}(\.[a-z]{2})?\/maps\/)/,
				
				// Format maps.google.com/...
				/^(https?:\/\/)?(maps\.google\.[a-z]{2,3}(\.[a-z]{2})?\/)/,
				
				// Format raccourci goo.gl/maps/...
				/^(https?:\/\/)?(goo\.gl\/maps\/)/,
				
				// Format maps.app.goo.gl/...
				/^(https?:\/\/)?(maps\.app\.goo\.gl\/)/,
				
				// Format avec paramètres ?q=...
				/^(https?:\/\/)?(www\.)?(google\.[a-z]{2,3}(\.[a-z]{2})?\/maps\?q=)/,
				
				// Format avec paramètres /dir/...
				/^(https?:\/\/)?(www\.)?(google\.[a-z]{2,3}(\.[a-z]{2})?\/maps\/dir\/)/,
				
				// ★ AJOUTEZ CE PATTERN POUR LES LIENS EMBED ★
				/^(https?:\/\/)?(www\.)?(maps\.)?google\.[a-z]{2,3}(\.[a-z]{2})?\/maps\/embed/
			];
            
            // Vérifier si l'URL correspond à l'un des patterns
            for (const pattern of googleMapsPatterns) {
                if (pattern.test(url)) {
                    return true;
                }
            }
            
            // Vérifier aussi si l'URL contient des mots-clés Google Maps
            const keywords = [
                'google.com/maps',
                'maps.google.com',
                'goo.gl/maps',
                'maps.app.goo.gl',
                'google.fr/maps',
                'google.tn/maps',
                'google.co.uk/maps',
                'google.de/maps',
                'google.es/maps',
                'google.it/maps',
                'google.ma/maps'
            ];
            
            for (const keyword of keywords) {
                if (url.includes(keyword)) {
                    return true;
                }
            }
            
            return false;
        }
        
        // Mettre à jour le compteur de caractères
        function updateCharCount() {
            if (charCount) {
                const length = mapLinkInput.value.length;
                charCount.textContent = `${length}/500`;
                
                if (length > 490) {
                    charCount.className = 'text-danger';
                } else if (length > 450) {
                    charCount.className = 'text-warning';
                } else {
                    charCount.className = 'text-muted';
                }
            }
        }
        
        // Limiter les caractères en temps réel
        mapLinkInput.addEventListener('input', function() {
            if (this.value.length > 500) {
                this.value = this.value.substring(0, 500);
            }
            updateCharCount();
            validateMapLink(this);
        });
        
        // Validation lors de la perte de focus
        mapLinkInput.addEventListener('blur', function() {
            validateMapLink(this);
        });
        
        // Validation lors du focus
        mapLinkInput.addEventListener('focus', function() {
            updateCharCount();
        });
        
        function validateMapLink(input) {
            const value = input.value.trim();
            
            if (value === '') {
                input.classList.remove('is-valid', 'is-invalid');
                if (mapLinkError) mapLinkError.style.display = 'none';
                return;
            }
            
            // Vérifier la longueur
            if (value.length > 500) {
                input.classList.remove('is-valid');
                input.classList.add('is-invalid');
                if (mapLinkError) {
                    mapLinkError.textContent = 'الرابط طويل جدًا (الحد الأقصى 500 حرف)';
                    mapLinkError.style.display = 'block';
                }
                return;
            }
            
            // Vérifier si c'est une URL valide
            try {
                if (value && !value.startsWith('http://') && !value.startsWith('https://')) {
                    new URL('https://' + value);
                } else {
                    new URL(value);
                }
            } catch (err) {
                input.classList.remove('is-valid');
                input.classList.add('is-invalid');
                if (mapLinkError) {
                    mapLinkError.textContent = 'الرابط غير صحيح. الرجاء التأكد من صيغة الرابط (ابدأ بـ http:// أو https://)';
                    mapLinkError.style.display = 'block';
                }
                return;
            }
            
            // Vérifier le format Google Maps
            if (isValidGoogleMapsLink(value)) {
                input.classList.remove('is-invalid');
                input.classList.add('is-valid');
                if (mapLinkError) mapLinkError.style.display = 'none';
            } else {
                input.classList.remove('is-valid');
                input.classList.add('is-invalid');
                if (mapLinkError) {
                    mapLinkError.innerHTML = 'الرابط يجب أن يكون من Google Maps.<br>' +
                                           'مثال: https://www.google.com/maps/place/...<br>' +
                                           'أو: https://goo.gl/maps/...<br>' +
                                           'أو: https://www.google.fr/maps/place/...';
                    mapLinkError.style.display = 'block';
                }
            }
        }
        
        // Éviter la validation HTML5 par défaut
        mapLinkInput.addEventListener('invalid', function(e) {
            e.preventDefault();
            validateMapLink(this);
        });
        
        // Pré-validation si le champ a déjà une valeur
        if (mapLinkInput.value) {
            updateCharCount();
            validateMapLink(mapLinkInput);
        }
        
        // Validation avant soumission
        const form = mapLinkInput.closest('form');
        if (form) {
            form.addEventListener('submit', function(e) {
                const value = mapLinkInput.value.trim();
                
                if (!value) {
                    e.preventDefault();
                    showAlert('error', 'الرجاء إدخال رابط Google Maps.');
                    mapLinkInput.focus();
                    return;
                }
                
                if (value.length > 500) {
                    e.preventDefault();
                    showAlert('error', 'رابط Google Maps يجب ألا يتجاوز 500 حرف.');
                    mapLinkInput.focus();
                    return;
                }
                
                if (!isValidGoogleMapsLink(value)) {
                    e.preventDefault();
                    showAlert('error', 'الرابط غير صحيح. يجب أن يكون رابط Google Maps مثل:\nhttps://www.google.com/maps/place/\nأو https://goo.gl/maps/\nأو https://www.google.fr/maps/place/');
                    mapLinkInput.focus();
                    return;
                }
                
                // Vérifier que c'est une URL valide
                try {
                    if (value && !value.startsWith('http://') && !value.startsWith('https://')) {
                        new URL('https://' + value);
                    } else {
                        new URL(value);
                    }
                } catch (err) {
                    e.preventDefault();
                    showAlert('error', 'الرابط غير صحيح. الرجاء التأكد من صحة الرابط.');
                    mapLinkInput.focus();
                    return;
                }
            });
        }
        
        // Fonction pour afficher des alertes personnalisées
        function showAlert(type, message) {
            // Utiliser SweetAlert2 si disponible, sinon alert() natif
            if (typeof Swal !== 'undefined') {
                Swal.fire({
                    icon: type,
                    title: type === 'error' ? 'خطأ' : 'تنبيه',
                    text: message,
                    confirmButtonText: 'حسنًا',
                    confirmButtonColor: '#dc3545'
                });
            } else {
                alert(message);
            }
        }
        
        // Afficher un exemple quand on clique sur le placeholder
        mapLinkInput.addEventListener('click', function() {
            if (!this.value) {
                this.value = 'https://www.google.com/maps/place/...';
                updateCharCount();
                validateMapLink(this);
                setTimeout(() => this.select(), 100);
            }
        });
    }
});
</script>

<style>
/* Style pour le compteur de caractères */
#charCount {
    font-family: monospace;
    font-size: 0.85rem;
    padding: 2px 6px;
    border-radius: 3px;
    background-color: #f8f9fa;
}

/* Style pour l'état valide/invalide */
.form-control.is-valid {
    border-color: #198754;
    padding-right: calc(1.5em + 0.75rem);
    background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 8 8'%3e%3cpath fill='%23198754' d='M2.3 6.73L.6 4.53c-.4-1.04.46-1.4 1.1-.8l1.1 1.4 3.4-3.8c.6-.63 1.6-.27 1.2.7l-4 4.6c-.43.5-.8.4-1.1.1z'/%3e%3c/svg%3e");
    background-repeat: no-repeat;
    background-position: right calc(0.375em + 0.1875rem) center;
    background-size: calc(0.75em + 0.375rem) calc(0.75em + 0.375rem);
}

.form-control.is-invalid {
    border-color: #dc3545;
    padding-right: calc(1.5em + 0.75rem);
    background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 12 12' width='12' height='12' fill='none' stroke='%23dc3545'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3e%3ccircle cx='6' cy='8.2' r='.6' fill='%23dc3545' stroke='none'/%3e%3c/svg%3e");
    background-repeat: no-repeat;
    background-position: right calc(0.375em + 0.1875rem) center;
    background-size: calc(0.75em + 0.375rem) calc(0.75em + 0.375rem);
}

/* Style pour le message d'erreur personnalisé */
#map_link_error {
    background-color: #f8d7da;
    border: 1px solid #f5c6cb;
    border-radius: 0.25rem;
    padding: 0.75rem 1.25rem;
    margin-top: 0.5rem;
    color: #721c24;
    font-size: 0.875rem;
}
</style>


        <div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">الوسط الذي توجد به المؤسسة <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select name="id_milieu_auberge" class="form-control @error('id_milieu_auberge') is-invalid @enderror" required>
					<option value="">-- اختر الوسط --</option>
					@foreach($milieux as $milieu)
						<option value="{{ $milieu->id_type }}" {{ old('id_milieu_auberge', $auberge->id_milieu_auberge) == $milieu->id_type ? 'selected' : '' }}>
							{{ $milieu->type_ar }}
						</option>
					@endforeach
				</select>
				@error('id_milieu_auberge')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>

		
		
		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label"> العنوان بالعربية <span class="text-danger">*</span> </label>
			<div class="col-sm-4">
				<input type="text" name="adresse_ar" required
					   class="form-control @error('adresse_ar') is-invalid @enderror" maxlength="200"
					   value="{{ old('adresse_ar', $auberge->adresse_ar) }}">
				@error('adresse_ar')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label"> العنوان بالفرنسية <span class="text-danger">*</span> </label>
			<div class="col-sm-4">
				<input type="text" name="adresse_fr" required
					   class="form-control @error('adresse_fr') is-invalid @enderror" maxlength="200"
					   value="{{ old('adresse_fr', $auberge->adresse_fr) }}">
				@error('adresse_fr')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label"> العنوان بالإنجليزية <span class="text-danger">*</span> </label>
			<div class="col-sm-4">
				<input type="text" name="adresse_en" required
					   class="form-control @error('adresse_en') is-invalid @enderror" maxlength="200"
					   value="{{ old('adresse_en', $auberge->adresse_en) }}">
				@error('adresse_en')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label"> الترقيم البريدي <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="code_postal"  required  pattern="[0-9]{4}" maxlength="4" inputmode="numeric"
					   class="form-control @error('code_postal') is-invalid @enderror"
					   value="{{ old('code_postal', $auberge->code_postal) }}">
				@error('code_postal')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">الولاية <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select class="form-control @error('gouvernorat_id') is-invalid @enderror" required id="gouvernorat_id" name="gouvernorat_id">
					<option value="" disabled>اختر...</option>
					@foreach($gouvernorats as $gouv)
						<option value="{{ $gouv->id_gouver }}" {{ old('gouvernorat_id', $auberge->gouver_id) == $gouv->id_gouver ? 'selected' : '' }}>
							{{ $gouv->nom_ar }}
						</option>
					@endforeach
				</select>
				@error('gouvernorat_id')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label">المعتمدية <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select class="form-control @error('delegation_id') is-invalid @enderror" required id="delegation_id" name="delegation_id" {{ $auberge->delegation_id ? '' : 'disabled' }}>
					<option value="" disabled {{ old('delegation_id', $auberge->delegation_id ?? '') ? '' : 'selected' }}>اختر...</option>
					@if($auberge->delegation_id)
						@foreach($delegations as $del)
							<option value="{{ $del->id_delegation }}"
								{{ old('delegation_id', $auberge->delegation_id ?? '') == $del->id_delegation ? 'selected' : '' }}>
								{{ $del->nom_ar }}
							</option>
						@endforeach
					@endif
				</select>
				@error('delegation_id')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">الهاتف القار <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="contact_tel" class="form-control @error('contact_tel') is-invalid @enderror" required  pattern="[0-9]{8}" maxlength="8" inputmode="numeric"
					   value="{{ old('contact_tel', $auberge->contact_tel) }}">
				@error('contact_tel')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label">الفاكس <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="fax" class="form-control @error('fax') is-invalid @enderror" required pattern="[0-9]{8}" maxlength="8" inputmode="numeric"
					   value="{{ old('fax', $auberge->fax) }}">
				@error('fax')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>

		<div class="row mt-3 text-end align-items-start">
			<label class="col-sm-2 col-form-label">البريد الإلكتروني للمؤسسة <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="email" name="contact_email" class="form-control @error('contact_email') is-invalid @enderror" required id="contactEmail"
					   value="{{ old('contact_email', $auberge->contact_email ?? '') }}" maxlength="100"
       placeholder="exemple@email.com">
	   <span id="emailError" class="text-danger small"></span>
				@error('contact_email')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<!--label for="image" class="col-sm-2 col-form-label">صورة المركب <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="file" name="image" id="image" class="form-control @error('image') is-invalid @enderror"  accept="image/*">
				@error('image')
					<span class="text-danger small">{{ $message }}</span>
				@enderror

				@if(!empty($imageSrc))
					<div class="mt-2 text-center">
						<img src="{{ $imageSrc }}"
							 alt="الصورة الحالية"
							 style="max-width: 200px; max-height: 150px; border-radius: 8px; object-fit: cover; box-shadow: 0 2px 5px rgba(0,0,0,0.1);">
					</div>
				@endif

			</div-->
		</div>
<script>
document.addEventListener('DOMContentLoaded', function () {

    const emailInput = document.getElementById('contactEmail');
    const emailError = document.getElementById('emailError');

    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

    emailInput.addEventListener('input', () => {
        const val = emailInput.value;

        if (val.length > 100) {
            emailInput.classList.add('is-invalid');
            emailError.textContent = 'البريد الإلكتروني يجب ألا يتجاوز 100 حرف';
        }
        else if (!emailRegex.test(val)) {
            emailInput.classList.add('is-invalid');
            emailError.textContent = 'البريد الإلكتروني غير صالح';
        }
        else {
            emailInput.classList.remove('is-invalid');
            emailError.textContent = '';
        }
    });

});
</script>
        <!--div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">سعر الليلة (سرير) <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input hidden type="number" name="prix_lit" class="form-control" 
					value="{{ old('prix_lit', $auberge->prix_lit ?? '') }}" step="0.01" min="0">
				@error('prix_lit')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div-->
<input hidden type="number" name="prix_lit" class="form-control" value="{{ old('prix_lit', $auberge->prix_lit ?? '') }}" step="0.01" min="0">
		<h4 class="mt-3"> مدير المؤسسة </h4>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">  الإسم واللقب <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="nom_directeur" class="form-control" required
					value="{{ old('nom_directeur', $auberge->nom_directeur) }}" maxlength="100">
				@error('nom_directeur')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>

			<label class="col-sm-2 col-form-label"> الهاتف الجوال <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="tel_directeur" class="form-control" required  pattern="[0-9]{8}"  maxlength="8" inputmode="numeric"
					value="{{ old('tel_directeur', $auberge->tel_directeur) }}">
				@error('tel_directeur')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>

		<h4 class="mt-3"> الخدمات</h4>
		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label"> هل يوجد فضاء للمشروبات ؟ <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select name="espace_boisson" id="espace_boisson" class="form-control" required>
					<option value="" disabled {{ old('espace_boisson', $auberge->espace_boisson) === null ? 'selected' : '' }}>اختر...</option>
					<option value="1" {{ old('espace_boisson', $auberge->espace_boisson) == 1 ? 'selected' : '' }}>نعم</option>
					<option value="0" {{ old('espace_boisson', $auberge->espace_boisson) == 0 ? 'selected' : '' }}>لا</option>
				</select>
				@error('espace_boisson')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
			
			<label class="col-sm-2 col-form-label"> مسبح  <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select name="piscine" class="form-control" required>
					<option value="" disabled {{ old('piscine', $auberge->piscine) === null ? 'selected' : '' }}>اختر...</option>
					<option value="1" {{ old('piscine', $auberge->piscine) == 1 ? 'selected' : '' }}>نعم</option>
					<option value="0" {{ old('piscine', $auberge->piscine) == 0 ? 'selected' : '' }}>لا</option>
				</select>
				@error('piscine')
					<span class="text-danger small">{{ $message }}</span>
				@enderror
			</div>
		</div>













<div class="form-group row mt-4">

    <h5 class="text-center mb-3">تعريفات الإقامة</h5>

    <table id="tarifs-table" class="table table-bordered">
        <thead>
            <tr>
                
                <th>فرادى / مجموعات</th>
                <th>نوع الوفد المقيم</th>
                <th>بالمباني</th>
                <th>تحت الخيام</th>
                <th>ملاحظات</th>
                <th>إجراء</th>
            </tr>
        </thead>
            <tbody id="tarifs-body">
@forelse($auberge->tarifs as $index => $tarif)
<tr>
    <td>
        <select class="form-control" name="tarifs[{{ $index }}][type]" required>
            <option value="groupe" {{ $tarif->type == 'groupe' ? 'selected' : '' }}>مجموعات</option>
            <option value="single" {{ $tarif->type == 'single' ? 'selected' : '' }}>أفراد</option>
        </select>
    </td>

    <td>
        <select class="form-control" name="tarifs[{{ $index }}][id_type_tarif]" required>
            @foreach($typeTarif as $type)
                <option value="{{ $type->id_type }}"
                    {{ $tarif->id_type_tarif == $type->id_type ? 'selected' : '' }}>
                    {{ $type->type_ar }}
                </option>
            @endforeach
        </select>
    </td>

    <td>
        <div class="d-flex gap-2">
            <input type="text" step="0.001"
							min="0"
							max="9999999.999"
							inputmode="decimal"
                   name="tarifs[{{ $index }}][tarif_chambre]"
                   class="form-control"
                   value="{{ $tarif->tarif_chambre }}">
            
        </div>
    </td>

    <td>
        <div class="d-flex gap-2">
            
            <input type="text" step="0.001"
							min="0"
							max="9999999.999"
							inputmode="decimal"
                   name="tarifs[{{ $index }}][tarif_tente]"
                   class="form-control"
                   value="{{ $tarif->tarif_tente }}">
        </div>
    </td>

    <td>
        <input type="text"
               name="tarifs[{{ $index }}][remarque]" maxlength="150"
               class="form-control"
               value="{{ $tarif->remarque }}">
    </td>

    <td>
        <button type="button" class="btn btn-danger btn-sm"
                onclick="deleteTarifRow(this)">حذف</button>
    </td>
</tr>
@empty
<tr>
    <td colspan="5" class="text-center">لا توجد تعريفات</td>
</tr>
@endforelse
</tbody>

    </table>

    <button type="button" class="btn btn-success mt-2" onclick="addTarifRow()">إضافة تعريف جديد</button>
</div>

<div class="form-group row mt-4">

    <h5 class="text-center mb-3">وقف عربات التخييم داخل المركز (في اليوم الواحد) </h5>
    <div class="mb-4">
        <div class="d-inline-block ms-2" style="width:150px;">
            <input type="text"
       name="tarif_camping_cars"
       step="0.001"
       class="form-control"
       value="{{ old('tarif_camping_cars', $auberge->tarif_camping_cars) }}" laceholder="0.000"
       inputmode="decimal">
        </div>
        <div class="small-note mt-2">يمكن تعديل القيمة.</div>
    </div>

</div>

<!--script>
function updateTarifRowNumbers() {
    document.querySelectorAll("#tarifs-body .row-number").forEach((cell, index) => {
        cell.textContent = index + 1;
    });
}

function removeTarifRow(button) {
    button.closest("tr").remove();
    updateTarifRowNumbers();
}

function addTarifRow() {
    let tableBody = document.getElementById("tarifs-body");
    let index = tableBody.children.length;

    let row = `
        <tr>
            <td class="row-number">${index + 1}</td>

            <td>
                <select name="tarifs[${index}][categorie]" class="form-control">
                    <option>أفراد</option>
                    <option selected>مجموعات</option>
                </select>
            </td>

            <td>
                <select name="tarifs[${index}][type]" class="form-control">
				 <option> تونسيون من ذوي الإحتياجات الخاصة    </option>
					   <option> تونسيون طلبة و- تلاميذ   </option>
					    <option>  تونسيون  موظفون وغيرهم   </option>
						<option>  منخرطو مؤسسات الشباب من حاملي بطاقة شاب   </option>
						<option>  تونسيون منخرطون بالجمعية التونسية لمظائف وسياحة </option>
                    <option>المجموعات المنخرطة بمؤسسات الشباب</option>
                    <option>المجموعات الشبابية التابعة لجمعيات وهيئات وطنية</option>
                    <option>المجموعات الأجنبية (خارج إطار التبادل)</option>
                    <option>المجموعات الأجنبية (إطار التبادل)</option>
                    <option>المجموعات الأجنبية (الطرف الأجنبي يتحمل المعاليم)</option>
                </select>
            </td>

            <td><input type="number" name="tarifs[${index}][hotel]" class="form-control"></td>
            <td><input type="number" name="tarifs[${index}][tentes]" class="form-control"></td>

            <td><input type="text" name="tarifs[${index}][note]" class="form-control"></td>

            <td><button type="button" class="btn btn-danger btn-sm" onclick="removeTarifRow(this)">حذف</button></td>
        </tr>
    `;

    tableBody.insertAdjacentHTML('beforeend', row);
    updateTarifRowNumbers();
}
</!--script-->
<script>
document.addEventListener('DOMContentLoaded', () => {

    const input = document.querySelector('input[name="tarif_camping_cars"]');

    input.addEventListener('input', () => {
        input.value = input.value.replace(',', '.');

        const regex = /^\d{1,7}(\.\d{0,3})?$/;

        if (!regex.test(input.value)) {
            input.classList.add('is-invalid');
        } else {
            input.classList.remove('is-invalid');
        }
    });

});
</script>

<script>
document.addEventListener('DOMContentLoaded', () => {

    document.addEventListener('input', function (e) {

        // on cible uniquement les champs tarif
        if (!e.target.matches('input[name^="tarifs"][name$="[tarif_chambre]"], input[name^="tarifs"][name$="[tarif_tente]"]')) {
            return;
        }

        const input = e.target;

        // normalisation virgule → point
        input.value = input.value.replace(',', '.');

        const regex = /^\d{1,7}(\.\d{0,3})?$/;

        if (!regex.test(input.value)) {
            input.classList.add('is-invalid');
        } else {
            input.classList.remove('is-invalid');
        }
    });

});
</script>

<script>
let tarifIndex = {{ $auberge->tarifs->count() }};

function addTarifRow() {
    const body = document.getElementById('tarifs-body');

    const row = `
    <tr>
        <td>
            <select class="form-control" name="tarifs[${tarifIndex}][type]" required>
                <option value="groupe">مجموعات</option>
                <option value="single">أفراد</option>
            </select>
        </td>

        <td>
            <select class="form-control" name="tarifs[${tarifIndex}][id_type_tarif]" required>
                @foreach($typeTarif as $type)
                    <option value="{{ $type->id_type }}">{{ $type->type_ar }}</option>
                @endforeach
            </select>
        </td>

        <td>
            <div class="d-flex gap-2">
                <input type="text" step="0.001"
							min="0"
							max="9999999.999"
							inputmode="decimal"
                       name="tarifs[${tarifIndex}][tarif_chambre]"
                       class="form-control">
                
            </div>
        </td>

        <td>
            <div class="d-flex gap-2">
                
                <input type="text" step="0.001"
							min="0"
							max="9999999.999"
							inputmode="decimal"
                       name="tarifs[${tarifIndex}][tarif_tente]"
                       class="form-control">
            </div>
        </td>

        <td>
            <input type="text"
                   name="tarifs[${tarifIndex}][remarque]" maxlength="150"
                   class="form-control">
        </td>

        <td>
            <button type="button" class="btn btn-danger btn-sm"
                    onclick="deleteTarifRow(this)">حذف</button>
        </td>
    </tr>`;

    body.insertAdjacentHTML('beforeend', row);
    tarifIndex++;
}

function deleteTarifRow(btn) {
    btn.closest('tr').remove();
}
</script>

















        <div class="form-group row mt-4">
			<h5 class="text-center mb-3">الفضاءات المتوفرة</h5>

			<table id="espaces-table" class="table table-bordered">
				<thead>
					<tr>
						<th></th>
						<th>الإسم بالعربية</th>
						<th>الإسم بالفرنسية</th>
						<th>الإسم بالانقليزية</th>
						<th>إجراء</th>
					</tr>
				</thead>
				<tbody id="espaces-body">
					@php
						// On prend soit les anciennes valeurs après validation, soit les espaces existants
						$oldEspaces = old('espaces', $auberge->espaces->toArray());
						$espaceIndex = 0;
					@endphp

					@foreach($oldEspaces as $espace)
					<tr>
						<td class="row-number">{{ $loop->iteration }}</td>
						<td>
							<input type="hidden" name="espaces[{{ $espaceIndex }}][id_espace]" value="{{ $espace['id_espace'] ?? '' }}">
							<input type="text" name="espaces[{{ $espaceIndex }}][nom_ar]" maxlength="100" class="form-control" value="{{ $espace['nom_ar'] ?? '' }}" >
						</td>
						<td>
							<input type="text" name="espaces[{{ $espaceIndex }}][nom_fr]" maxlength="100" class="form-control" value="{{ $espace['nom_fr'] ?? '' }}" >
						</td>
						<td>
							<input type="text" name="espaces[{{ $espaceIndex }}][nom_en]" maxlength="100" class="form-control" value="{{ $espace['nom_en'] ?? '' }}" >
						</td>
						<td>
							<button type="button" class="btn btn-danger btn-sm" onclick="removeEspaceRow(this)">حذف</button>
						</td>
					</tr>
					@php $espaceIndex++; @endphp
					@endforeach
				</tbody>
			</table>

			<button type="button" class="btn btn-success mt-2" onclick="addEspaceRow()">إضافة فضاء جديد</button>
		</div>


        <div class="form-group row mt-4">
			<h5 class="text-center mb-3">الغرف <span class="text-danger">*</span></h5>
			<table id="chambres-table" class="custom-table">
				<thead>
					<tr>
						<th></th>
						<th>نوع الغرفة</th>
						<th>الطاقة الاستيعابية</th>
						<th>رقم الغرفة</th>
						<th>إجراء</th>
					</tr>
				</thead>

				<tbody id="chambres-body">
					@php
						$oldChambres = old('chambres', isset($auberge) ? $auberge->chambres->toArray() : []);
					@endphp

					@foreach($oldChambres as $index => $c)
					<tr>
						<td class="row-number">{{ $index + 1 }}</td>

						{{-- Type de chambre --}}
						<td>
							<select name="chambres[{{ $index }}][type_chambre_id]" class="form-control type-chambre" required>
								<option value="">-- اختر --</option>
								@foreach($typesChambres as $t)
									<option value="{{ $t->id_type }}" 
										{{ ($c['type_chambre_id'] ?? '') == $t->id_type ? 'selected' : '' }}>
										{{ $t->type_ar }}
									</option>
								@endforeach
							</select>
							<input type="hidden" name="chambres[{{ $index }}][id_chambre_tente]" value="{{ $c['id_chambre_tente'] ?? '' }}" required>
							@error("chambres.$index.type_chambre_id")
								<span class="text-danger small">{{ $message }}</span>
							@enderror
						</td>

						{{-- Capacité --}}
						<td>
							<input type="number" name="chambres[{{ $index }}][capacite]" max=999 class="form-control nb-lits" required value="{{ $c['capacite'] ?? '' }}">
							@error("chambres.$index.capacite")
								<span class="text-danger small">{{ $message }}</span>
							@enderror
						</td>

						{{-- Numéro de chambre --}}
						<td>
							<input type="text" name="chambres[{{ $index }}][num_chambre]" maxlength="5" class="form-control" required value="{{ $c['num_chambre'] ?? '' }}">
							@error("chambres.$index.num_chambre")
								<span class="text-danger small">{{ $message }}</span>
							@enderror
						</td>

						<td>
							<button type="button" class="btn btn-danger btn-sm" onclick="removeChambreRow(this)">حذف</button>
						</td>
					</tr>
					@endforeach
				</tbody>
			</table>

			<button type="button" class="btn btn-success mt-2" onclick="addChambreRow()">إضافة غرفة</button>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">طاقة الإستيعاب تحت المباني <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="number" name="capacite_batiment" id="capacite_batiment" class="form-control" 
					value="{{ old('capacite_batiment', $auberge->capacite_batiment ?? 0) }}" readonly>
			</div>

			<label class="col-sm-2 col-form-label">عدد الغرف <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="number" name="nb_chambres" id="nb_chambres" class="form-control" 
					value="{{ old('nb_chambres', $auberge->nb_chambres ?? 0) }}" readonly>
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">عدد الغرف الفردية</label>
			<div class="col-sm-4">
				<input type="number" name="nb_chambres_single" id="nb_chambres_single" class="form-control" 
					value="{{ old('nb_chambres_single', $auberge->nb_chambres_single ?? 0) }}" readonly>
			</div>

			<label class="col-sm-2 col-form-label">عدد الغرف ثنائي</label>
			<div class="col-sm-4">
				<input type="number" name="nb_chambres_double" id="nb_chambres_double" class="form-control" 
					value="{{ old('nb_chambres_double', $auberge->nb_chambres_double ?? 0) }}" readonly>
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">عدد الغرف ثلاثي</label>
			<div class="col-sm-4">
				<input type="number" name="nb_chambres_triple" id="nb_chambres_triple" class="form-control" 
					value="{{ old('nb_chambres_triple', $auberge->nb_chambres_triple ?? 0) }}" readonly>
			</div>

			<label class="col-sm-2 col-form-label">عدد الغرف رباعي</label>
			<div class="col-sm-4">
				<input type="number" name="nb_chambres_quadra" id="nb_chambres_quadra" class="form-control" 
					value="{{ old('nb_chambres_quadra', $auberge->nb_chambres_quadra ?? 0) }}" readonly>
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">عدد الغرف أكثر من رباعي</label>
			<div class="col-sm-4">
				<input type="number" name="nb_chambres_plus" id="nb_chambres_plus" class="form-control" 
					value="{{ old('nb_chambres_plus', $auberge->nb_chambres_plus ?? 0) }}" readonly>
			</div>

			<label class="col-sm-2 col-form-label">عدد الوحدات الصحية داخل الغرف</label>
			<div class="col-sm-4">
				<input type="number" name="nb_salles_de_bain" id="nb_salles_de_bain" class="form-control"  max=999
					value="{{ old('nb_salles_de_bain', $auberge->nb_salles_de_bain ?? 0) }}">
			</div>
		</div>




        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
            عدد الوحدات الصحية المشتركة</label>
            <div class="col-sm-4">
                <input type="number" name="nb_salles_de_bain_comm" class="form-control" max=999
                    value="{{ old('nb_salles_de_bain_comm', $auberge->nb_salles_de_bain_comm) }}">
            </div>
            <label class="col-sm-2 col-form-label">
            عدد الغرف التي تحتوي على تلفاز</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_tv" class="form-control" max=999
                    value="{{ old('nb_chambres_tv', $auberge->nb_chambres_tv) }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
            عدد الغرف المكيفة</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_clim" class="form-control" max=999
                    value="{{ old('nb_chambres_clim', $auberge->nb_chambres_clim) }}">
            </div>
            <label class="col-sm-2 col-form-label">
            عدد الغرف التي تحتوي على ثلاجة</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_frigo" class="form-control" max=999
                    value="{{ old('nb_chambres_frigo', $auberge->nb_chambres_frigo) }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
            طاقة الإستيعاب تحت الخيام إن وجدت</label>
            <div class="col-sm-4">
                <input type="number" name="capacite_tentes" class="form-control" max=999
                    value="{{ old('capacite_tentes', $auberge->capacite_tentes) }}">
            </div>
            <label for="cuisine_fonctionnelle" class="col-sm-2 col-form-label">المطبخ وظيفي</label>
            <div class="col-sm-4">
                <select name="cuisine_fonctionnelle" id="cuisine_fonctionnelle" class="form-control">
                    <option value="" disabled>اختر...</option>
                    <option value="1" {{ old('cuisine_fonctionnelle', $auberge->cuisine_fonctionnelle) == '1' ? 'selected' : '' }}>نعم</option>
                    <option value="0" {{ old('cuisine_fonctionnelle', $auberge->cuisine_fonctionnelle) == '0' ? 'selected' : '' }}>لا</option>
                </select>
            </div>
        </div>


       

                <div class="form-group row mt-4">
    <h5 class="text-center mb-3">الملاعب الرياضية</h5>

    <table id="terrains-table" class="table table-bordered">
        <thead>
            <tr>
                <th></th>
                <th>الإسم بالعربية</th>
                <th>الإسم بالفرنسية</th>
                <th>الإسم بالانقليزية</th>
                <th>إجراء</th>
            </tr>
        </thead>
        <tbody id="terrains-body">
            @php
                $oldterrains = old('terrains', $auberge->terrains->toArray());
                $terrainsIndex = 0;
            @endphp

            @foreach($oldterrains as $terrain)
            <tr>
                <td class="row-number">{{ $loop->iteration }}</td>
                <td>
                    <input type="hidden" name="terrains[{{ $terrainsIndex }}][id_terrain]" value="{{ $terrain['id_terrain'] ?? '' }}">
                    <input type="text" name="terrains[{{ $terrainsIndex }}][nom_ar]" class="form-control" maxlength="150" value="{{ $terrain['nom_ar'] ?? '' }}" >
                </td>
                <td>
                    <input type="text" name="terrains[{{ $terrainsIndex }}][nom_fr]" class="form-control" maxlength="150" value="{{ $terrain['nom_fr'] ?? '' }}" >
                </td>
                <td>
                    <input type="text" name="terrains[{{ $terrainsIndex }}][nom_en]" class="form-control" maxlength="150" value="{{ $terrain['nom_en'] ?? '' }}" >
                </td>
                <td>
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeterrainsRow(this)">حذف</button>
                </td>
            </tr>
            @php $terrainsIndex++; @endphp
            @endforeach
        </tbody>
    </table>

    <button type="button" class="btn btn-success mt-2" onclick="addterrainsRow()">إضافة فضاء جديد</button>
</div>

<script>
let terrainsIndex = {{ $terrainsIndex ?? 0 }};

function addterrainsRow() {
    let tableBody = document.getElementById('terrains-body');

    let newRow = `
        <tr>
            <td class="row-number">${terrainsIndex + 1}</td>
            <td>
                <input type="hidden" name="terrains[${terrainsIndex}][id_terrain]" value="">
                <input type="text" name="terrains[${terrainsIndex}][nom_ar]" maxlength="150" class="form-control" >
            </td>
            <td>
                <input type="text" name="terrains[${terrainsIndex}][nom_fr]" maxlength="150" class="form-control" >
            </td>
            <td>
                <input type="text" name="terrains[${terrainsIndex}][nom_en]" maxlength="150" class="form-control" >
            </td>
            <td>
                <button type="button" class="btn btn-danger btn-sm" onclick="removeterrainsRow(this)">حذف</button>
            </td>
        </tr>
    `;
    tableBody.insertAdjacentHTML('beforeend', newRow);
    terrainsIndex++;
    updateterrainsRowNumbers();
}

function removeterrainsRow(button) {
    button.closest('tr').remove();
    updateterrainsRowNumbers();
}

function updateterrainsRowNumbers() {
    document.querySelectorAll('#terrains-body .row-number')
        .forEach((cell, index) => cell.textContent = index + 1);
}
</script>

        


        <div class="form-group row mt-4">
    <h5 class="text-center mb-3">الخدمات المقدمة من طرف المؤسسة</h5>

    <table id="services_auberge-table" class="table table-bordered">
        <thead>
            <tr>
                <th></th>
                <th>الإسم بالعربية</th>
                <th>الإسم بالفرنسية</th>
                <th>الإسم بالانقليزية</th>
                <th>إجراء</th>
            </tr>
        </thead>
        <tbody id="services_auberge-body">
            @php
                $oldservices_auberge = old('services_auberge', $auberge->services_auberge->toArray());
                $services_aubergeIndex = 0;
            @endphp

            @foreach($oldservices_auberge as $services_auberge)
            <tr>
                <td class="row-number">{{ $loop->iteration }}</td>
                <td>
                    <input type="hidden" name="services_auberge[{{ $services_aubergeIndex }}][id_service]" value="{{ $services_auberge['id_service'] ?? '' }}">
                    <input type="text" name="services_auberge[{{ $services_aubergeIndex }}][nom_ar]" maxlength="150" class="form-control" value="{{ $services_auberge['nom_ar'] ?? '' }}" >
                </td>
                <td>
                    <input type="text" name="services_auberge[{{ $services_aubergeIndex }}][nom_fr]" maxlength="150" class="form-control" value="{{ $services_auberge['nom_fr'] ?? '' }}" >
                </td>
                <td>
                    <input type="text" name="services_auberge[{{ $services_aubergeIndex }}][nom_en]" maxlength="150" class="form-control" value="{{ $services_auberge['nom_en'] ?? '' }}" >
                </td>
                <td>
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeservices_aubergeRow(this)">حذف</button>
                </td>
            </tr>
            @php $services_aubergeIndex++; @endphp
            @endforeach
        </tbody>
    </table>

    <button type="button" class="btn btn-success mt-2" onclick="addservices_aubergeRow()">إضافة فضاء جديد</button>
</div>

<script>
let services_aubergeIndex = {{ $services_aubergeIndex ?? 0 }};

function addservices_aubergeRow() {
    let tableBody = document.getElementById('services_auberge-body');

    let newRow = `
        <tr>
            <td class="row-number">${services_aubergeIndex + 1}</td>
            <td>
                <input type="hidden" name="services_auberge[${services_aubergeIndex}][id_service]" value="">
                <input type="text" name="services_auberge[${services_aubergeIndex}][nom_ar]" maxlength="150" class="form-control" >
            </td>
            <td>
                <input type="text" name="services_auberge[${services_aubergeIndex}][nom_fr]" maxlength="150" class="form-control" >
            </td>
            <td>
                <input type="text" name="services_auberge[${services_aubergeIndex}][nom_en]" maxlength="150" class="form-control" >
            </td>
            <td>
                <button type="button" class="btn btn-danger btn-sm" onclick="removeservices_aubergeRow(this)">حذف</button>
            </td>
        </tr>
    `;
    tableBody.insertAdjacentHTML('beforeend', newRow);
    services_aubergeIndex++;
    updateservices_aubergeRowNumbers();
}

function removeservices_aubergeRow(button) {
    button.closest('tr').remove();
    updateservices_aubergeRowNumbers();
}

function updateservices_aubergeRowNumbers() {
    document.querySelectorAll('#services_auberge-body .row-number')
        .forEach((cell, index) => cell.textContent = index + 1);
}
</script>


    <div class="form-group row mt-4">
        <h5 class="text-center mb-3">🍽️ قسم خدمات المطعم</h5>
        <table id="restauration-table" class="custom-table">
            <thead>
                <tr>
                    <th></th>
                    <th>الإسم بالعربية</th>
                    <th>الإسم بالفرنسية</th>
                    <th>الإسم بالإنجليزية</th>
                    <th>الوصف بالعربية</th>
                    <th>الوصف بالفرنسية</th>
                    <th>الوصف بالإنجليزية</th>
                    <th>التعريفة (د.ت)</th>
                    <th>إجراء</th> 
                </tr>
            </thead>
            <tbody id="restauration-body">
                @foreach($auberge->restaurations as $i => $res)
                    <tr>
                        <td class="row-number"></td>
                        <td>
                            <input type="hidden" name="restaurations[{{ $i }}][id_rest]" value="{{ $res->id_rest }}">
                            <input type="text" name="restaurations[{{ $i }}][nom_ar]" value="{{ $res->nom_ar }}" maxlength="100" class="form-control"></td>
                        <td><input type="text" name="restaurations[{{ $i }}][nom_fr]" value="{{ $res->nom_fr }}" maxlength="100" class="form-control"></td>
                        <td><input type="text" name="restaurations[{{ $i }}][nom_en]" value="{{ $res->nom_en }}" maxlength="100" class="form-control"></td>
                        <td><textarea name="restaurations[{{ $i }}][description_ar]" maxlength="150" class="form-control">{{ $res->description_ar }}</textarea></td>
                        <td><textarea name="restaurations[{{ $i }}][description_fr]" maxlength="150" class="form-control">{{ $res->description_fr }}</textarea></td>
                        <td><textarea name="restaurations[{{ $i }}][description_en]" maxlength="150" class="form-control">{{ $res->description_en }}</textarea></td>
                        <td><input type="text" laceholder="0.00" inputmode="decimal" name="restaurations[{{ $i }}][tarif]" value="{{ $res->tarif }}" class="form-control"></td>
                        <td>
                            <button type="button" class="btn btn-danger btn-sm" onclick="removeRestaurationRow(this)">حذف</button>
                        </td>
                    </tr>
                @endforeach
            </tbody>

        </table>
        <button type="button" class="btn btn-success mt-2" onclick="addRestaurationRow()">إضافة خدمة جديدة</button>
    </div>

        

        <div class="form-group mt-3">
            <label for="lieux_culturels" class="col-sm-6 col-form-label">    المعالم الأثرية والمتاحف والفضاءات الثقافية المجاورة للمؤسسة بالعربية</label>
            <textarea name="lieux_culturels" id="lieux_culturels" maxlength="250" class="form-control" rows="4">{{ old('lieux_culturels', $auberge->lieux_culturels) }}</textarea>
        </div>

        <div class="form-group mt-3">
            <label for="lieux_culturels" class="col-sm-6 col-form-label">     المعالم الأثرية والمتاحف والفضاءات الثقافية المجاورة للمؤسسة بالفرنسية</label>
            <textarea name="lieux_culturels_fr" id="lieux_culturels" maxlength="250" class="form-control" rows="4">{{ old('lieux_culturels_fr', $auberge->lieux_culturels_fr) }}</textarea>
        </div>


        <div class="form-group mt-3">
            <label for="lieux_culturels" class="col-sm-6 col-form-label">   المعالم الأثرية والمتاحف والفضاءات الثقافية المجاورة للمؤسسة بالإنقليزية </label>
            <textarea name="lieux_culturels_en" id="lieux_culturels" maxlength="250" class="form-control" rows="4">{{ old('lieux_culturels_en', $auberge->lieux_culturels_en) }}</textarea>
        </div>


        <div class="form-group mt-3">
            <label for="autres_services" class="col-sm-6 col-form-label">     خدمات أخرى بالعربية</label>
            <textarea name="autres_services" maxlength="250" placeholder="أذكر الخدمات الإضافية إن وجدت..." id="autres_services" class="form-control" rows="4">{{ old('autres_services', $auberge->autres_services) }}</textarea>
        </div>



        <div class="form-group mt-3">
            <label for="autres_services" class="col-sm-6 col-form-label">    خدمات أخرى  بالفرنسية </label>
            <textarea name="autres_services_fr" maxlength="250" placeholder="أذكر الخدمات الإضافية إن وجدت..." id="autres_services" class="form-control" rows="4">{{ old('autres_services_fr', $auberge->autres_services_fr) }}</textarea>
        </div>

        <div class="form-group mt-3">
            <label for="autres_services" class="col-sm-6 col-form-label">  خدمات أخرى  بالإنقليزية</label>
            <textarea name="autres_services_en" maxlength="250" placeholder="أذكر الخدمات الإضافية إن وجدت..." id="autres_services" class="form-control" rows="4">{{ old('autres_services_en', $auberge->autres_services_en) }}</textarea>
        </div>





       

         <div class="block-card-footer mt-3 mb-3 text-center">
			<button type="submit" id="submitBtn" class="btn bg-rgb-primary1 font-weight-medium">
			<i class="la la-save mr-1"></i> حفظ
			</button>
			<a href="{{ route('auberges.index') }}" class="btn bg-rgb-primary1 font-weight-medium">
			<i class="la la-times mr-1"></i> إلغاء
			</a>
		</div>

    </form>
</div>

<script>
    let restaurationIndex = {{ count($auberge->restaurations) }};
    function addRestaurationRow() {
        let tableBody = document.getElementById('restauration-body');
        let newRow = `
            <tr>
                <td class="row-number"></td>

                <td><input type="text" name="restaurations[${restaurationIndex}][nom_ar]" maxlength="100" class="form-control" ></td>
                <td><input type="text" name="restaurations[${restaurationIndex}][nom_fr]" maxlength="100" class="form-control" ></td>
                <td><input type="text" name="restaurations[${restaurationIndex}][nom_en]" maxlength="100" class="form-control" ></td>

                <td><textarea name="restaurations[${restaurationIndex}][description_ar]" maxlength="150" class="form-control" rows="1"></textarea></td>
                <td><textarea name="restaurations[${restaurationIndex}][description_fr]" maxlength="150" class="form-control" rows="1"></textarea></td>
                <td><textarea name="restaurations[${restaurationIndex}][description_en]" maxlength="150" class="form-control" rows="1"></textarea></td>

                <td><input type="text" laceholder="0.00" inputmode="decimal" name="restaurations[${restaurationIndex}][tarif]" class="form-control" ></td>

                <td>
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeRestaurationRow(this)">حذف</button>
                </td>
            </tr>
        `;
        tableBody.insertAdjacentHTML('beforeend', newRow);
        restaurationIndex++;
        updateRowNumbers();
    }
    function removeRestaurationRow(button) {
        button.closest('tr').remove();
        updateRowNumbers();
    }
    function updateRowNumbers() {
        document.querySelectorAll('#restauration-body .row-number')
            .forEach((cell, index) => cell.textContent = index + 1);
    }
    updateRowNumbers();
</script>
<script>
document.addEventListener('DOMContentLoaded', () => {

    document.addEventListener('input', function (e) {

        if (!e.target.matches('input[name^="restaurations"][name$="[tarif]"]')) {
            return;
        }

        const input = e.target;

        // normaliser , → .
        input.value = input.value.replace(',', '.');

        const regex = /^\d{1,7}(\.\d{0,2})?$/;

        if (!regex.test(input.value)) {
            input.classList.add('is-invalid');
        } else {
            input.classList.remove('is-invalid');
        }
    });

});
</script>
<script>
document.addEventListener('DOMContentLoaded', function () {

    const form = document.querySelector('form');
    if (!form) return;

    const fields = [
        {
            input: document.getElementById('latitudeInput'),
            error: document.getElementById('latitudeError'),
            name: 'خط العرض',
            regex: /^-?\d{1,2}(\.\d{1,4})?$/,
            min: 0,
            max: 99,
            example: '36.8065'
        },
        {
            input: document.getElementById('longitudeInput'),
            error: document.getElementById('longitudeError'),
            name: 'خط الطول',
            regex: /^-?\d{1,3}(\.\d{1,4})?$/,
            min: 0,
            max: 99,
            example: '10.1815'
        },
        {
            input: document.getElementById('xInput'),
            error: document.getElementById('xError'),
            name: 'X (خط العرض)',
            regex: /^-?\d{1,2}(\.\d{1,4})?$/,
            min: 0,
            max: 99,
            example: '36.8065'
        },
        {
            input: document.getElementById('yInput'),
            error: document.getElementById('yError'),
            name: 'Y (خط الطول)',
            regex: /^-?\d{1,3}(\.\d{1,4})?$/,
            min: 0,
            max: 99,
            example: '10.1815'
        }
    ].filter(f => f.input && f.error); // ⬅️ حماية من null

    // Validation en temps réel
    fields.forEach(field => {
        field.input.addEventListener('input', () => {
            const value = field.input.value.trim();
            const val = parseFloat(value);

            if (
                value === '' ||
                !field.regex.test(value) ||
                isNaN(val) ||
                val < field.min ||
                val > field.max
            ) {
                field.input.classList.add('is-invalid');
                field.error.textContent =
                    `${field.name} غير صالح. مثال: ${field.example}`;
            } else {
                field.input.classList.remove('is-invalid');
                field.error.textContent = '';
            }
        });
    });

    // Validation à la soumission
    form.addEventListener('submit', function (e) {
        let valid = true;

        fields.forEach(field => {
            const value = field.input.value.trim();
            const val = parseFloat(value);

            if (
                value === '' ||
                !field.regex.test(value) ||
                isNaN(val) ||
                val < field.min ||
                val > field.max
            ) {
                field.input.classList.add('is-invalid');
                field.error.textContent =
                    `${field.name} غير صالح. مثال: ${field.example}`;

                if (valid) field.input.focus();
                valid = false;
            }
        });

        if (!valid) e.preventDefault();
    });

});
</script>

<script>
document.addEventListener("DOMContentLoaded", function () {

    const gouvSelect = document.getElementById('gouvernorat_id');
    const delSelect  = document.getElementById('delegation_id');

    gouvSelect.addEventListener('change', function () {

        let gouvId = this.value;

        delSelect.innerHTML = '';
        delSelect.disabled = true;

        delSelect.innerHTML = '<option disabled selected>تحميل...</option>';

        let url = "{{ route('delegations.get', ['gouvernoratId' => 'ID_PLACEHOLDER']) }}";
        url = url.replace("ID_PLACEHOLDER", gouvId);

        fetch(url)
            .then(response => response.json())
            .then(data => {

                
                delSelect.innerHTML = '<option disabled selected>اختر...</option>';

                
                data.forEach(d => {
                    let option = document.createElement('option');
                    option.value = d.id_delegation;
                    option.text  = d.nom_ar;
                    delSelect.appendChild(option);
                });

                delSelect.disabled = false;
            });
    });

});
</script>
<script>
let espaceIndex = {{ $espaceIndex ?? 0 }};

function addEspaceRow() {
    let tableBody = document.getElementById('espaces-body');

    let newRow = `
        <tr>
            <td class="row-number">${espaceIndex + 1}</td>
            <td>
                <input type="hidden" name="espaces[${espaceIndex}][id_espace]" value="">
                <input type="text" name="espaces[${espaceIndex}][nom_ar]" maxlength="100" class="form-control" >
            </td>
            <td>
                <input type="text" name="espaces[${espaceIndex}][nom_fr]" maxlength="100" class="form-control" >
            </td>
            <td>
                <input type="text" name="espaces[${espaceIndex}][nom_en]" maxlength="100" class="form-control" >
            </td>
            <td>
                <button type="button" class="btn btn-danger btn-sm" onclick="removeEspaceRow(this)">حذف</button>
            </td>
        </tr>
    `;
    tableBody.insertAdjacentHTML('beforeend', newRow);
    espaceIndex++;
    updateEspaceRowNumbers();
}

function removeEspaceRow(button) {
    button.closest('tr').remove();
    updateEspaceRowNumbers();
}

function updateEspaceRowNumbers() {
    document.querySelectorAll('#espaces-body .row-number')
        .forEach((cell, index) => cell.textContent = index + 1);
}
</script>

<script>
function updateRowNumbers() {
    document.querySelectorAll('#chambres-body tr .row-number').forEach((td, i) => td.textContent = i + 1);
}

function recalculer() {
    const rows = document.querySelectorAll('#chambres-body tr');
    let totalChambres = 0, capaciteTotale = 0;
    let nb_single = 0, nb_double = 0, nb_triple = 0, nb_quadra = 0, nb_plus = 0;

    rows.forEach(row => {
        const typeEl = row.querySelector('.type-chambre');
        const litsEl = row.querySelector('.nb-lits');

        if (!typeEl || !litsEl) return;

        const type = typeEl.value;
        const lits = parseInt(litsEl.value || 0);

        totalChambres++;
        capaciteTotale += lits;

        switch(type){
            case "1": nb_single++; break;
            case "2": nb_double++; break;
            case "3": nb_triple++; break;
            case "4": nb_quadra++; break;
            case "6": nb_plus++; break;
        }
    });

    document.getElementById('nb_chambres').value = totalChambres;
    document.getElementById('capacite_batiment').value = capaciteTotale;
    document.getElementById('nb_chambres_single').value = nb_single;
    document.getElementById('nb_chambres_double').value = nb_double;
    document.getElementById('nb_chambres_triple').value = nb_triple;
    document.getElementById('nb_chambres_quadra').value = nb_quadra;
    document.getElementById('nb_chambres_plus').value = nb_plus;
}

function addChambreRow() {
    const tbody = document.getElementById("chambres-body");
    const index = tbody.rows.length;

    const tr = document.createElement('tr');
    tr.innerHTML = `
        <td class="row-number">${index + 1}</td>
        <td>
            <select name="chambres[${index}][type_chambre_id]" class="form-control type-chambre" >
                <option value="">-- اختر --</option>
                @foreach($typesChambres as $t)
                <option value="{{ $t->id_type }}">{{ $t->type_ar }}</option>
                @endforeach
            </select>
            <input type="hidden" name="chambres[${index}][id_chambre_tente]" value="">
        </td>
        <td><input type="number" name="chambres[${index}][capacite]" max=999 class="form-control nb-lits" ></td>
        <td><input type="text" name="chambres[${index}][num_chambre]" maxlength="5" class="form-control" ></td>
        <td><button type="button" class="btn btn-danger btn-sm" onclick="removeChambreRow(this)">حذف</button></td>
    `;
    tbody.appendChild(tr);
    updateRowNumbers();
    recalculer();
}

function removeChambreRow(btn) {
    btn.closest("tr").remove();
    updateRowNumbers();
    recalculer();
}

document.addEventListener('input', e => {
    if (e.target.classList.contains('type-chambre') || e.target.classList.contains('nb-lits')) {
        recalculer();
    }
});
document.addEventListener('change', e => {
    if (e.target.classList.contains('type-chambre')) {
        recalculer();
    }
});
document.addEventListener('DOMContentLoaded', () => {
    updateRowNumbers();
    recalculer();
});
</script>

	<script>
(function () {
    'use strict';
    var forms = document.querySelectorAll('.needs-validation');
    Array.prototype.slice.call(forms).forEach(function (form) {
        form.addEventListener('submit', function (event) {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            form.classList.add('was-validated');
        }, false);
    });
})();
</script>

@endsection

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
