<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('projet_divertissement_jeune_enfant', function (Blueprint $table) {
            $table->unsignedBigInteger('id_formulaire')->nullable()->after('id_directeur');
            $table->unsignedBigInteger('id_statut')->nullable()->after('id_formulaire');

            $table->foreign('id_formulaire')
                  ->references('id_type')
                  ->on('tp_type_formulaire')
                  ->onDelete('set null');

            $table->foreign('id_statut')
                  ->references('id_statut')
                  ->on('tp_statut')
                  ->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::table('projet_divertissement_jeune_enfant', function (Blueprint $table) {
            $table->dropForeign(['id_formulaire']);
            $table->dropForeign(['id_statut']);
            $table->dropColumn(['id_formulaire', 'id_statut']);
        });
    }
};