<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('utilisateur', function (Blueprint $table) {
            $table->string('lieu_naissance', 100)->nullable();
            $table->date('date_naissance')->nullable();
            $table->string('niveau_etude', 100)->nullable();
            $table->string('dernier_diplome', 100)->nullable();
            $table->string('experience', 100)->nullable();
        });
    }

    public function down(): void
    {
        Schema::table('utilisateur', function (Blueprint $table) {
            $table->dropColumn([
                'lieu_naissance',
                'date_naissance',
                'niveau_etude',
                'dernier_diplome',
                'experience'
            ]);
        });
    }
};
