<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('immobilier', function (Blueprint $table) {
            $table->bigIncrements('id_imm');
            $table->string('usage_ar', 100);
            $table->unsignedBigInteger('user_id');
            $table->string('adresse_imm', 255);
            $table->unsignedBigInteger('gouvernorat_id');
            $table->unsignedBigInteger('delegation_id');
            $table->unsignedBigInteger('id_statut')->default(2);
            $table->unsignedBigInteger('type_imm_id');
            $table->unsignedBigInteger('usage_id');
            $table->string('document_propriete', 255);
            $table->integer('superfici_m2');
            $table->boolean('salle_exercice')->default(false); 
            $table->integer('nbr_salle_exercice');
            $table->integer('superface_salle_exercice');
            $table->boolean('piscine')->default(false); 
            $table->integer('nbr_piscine');
            $table->integer('superface_piscine');
            $table->boolean('vestiaire')->default(false); 
            $table->integer('nbr_vestiaire');
            $table->integer('superface_vestiaire');
            $table->boolean('unitaires_sanitaire')->default(false); 
            $table->integer('superface_unitaires_sanitaire');
            $table->boolean('stockage_conservation')->default(false); 
            $table->integer('superface_stockage_conser');
            $table->boolean('espace_exterieur')->default(false); 
            $table->integer('superface_espace_exterieur');
            $table->boolean('garage')->default(false); 
            $table->integer('superface_garage');
            $table->integer('autres_surfaces');
            $table->string('commentaire_motif', 255);


            $table->foreign('user_id')
                ->references('id')->on('utilisateur')
                ->onDelete('cascade');
            $table->foreign('gouvernorat_id')
                ->references('id_gouver')->on('tp_gouvernorat')
                ->onDelete('cascade');
            $table->foreign('delegation_id')
                ->references('id_delegation')->on('tp_delegation')
                ->onDelete('cascade');
            $table->foreign('id_statut')
                ->references('id_statut')->on('tp_statut')
                ->onDelete('cascade');
            $table->foreign('type_imm_id')
                ->references('id_type')->on('tp_immobilier')
                ->onDelete('cascade');
            $table->foreign('usage_id')
                ->references('id_usage_imm')->on('tp_usage_immobilier')
                ->onDelete('cascade');    
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('immobilier');
    }
};
