<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('demandes_manifestation', function (Blueprint $table) {
            $table->id('id_demande'); 
            $table->string('sujet', 150);
            $table->string('sport_type', 100);
            $table->string('event_name', 100)->nullable();
            $table->string('objectif', 255)->nullable();
            $table->string('commentaire_motif', 255)->nullable();

            // relations
            $table->unsignedBigInteger('type_formulaire_id');
            $table->foreign('type_formulaire_id')
                  ->references('id_type')
                  ->on('tp_type_formulaire')
                  ->onDelete('cascade');

            $table->unsignedBigInteger('attachments_id');
            $table->foreign('attachments_id')
                  ->references('id_type')
                  ->on('tp_attachement')
                  ->onDelete('cascade');

            $table->unsignedBigInteger('user_id');
            $table->foreign('user_id')
                  ->references('id')
                  ->on('utilisateur')
                  ->onDelete('cascade');

            $table->unsignedBigInteger('id_type');
            $table->foreign('id_type')
                  ->references('id_statut')
                  ->on('tp_statut')
                  ->onDelete('cascade');

            $table->unsignedBigInteger('organisme_non_sportif_id');
            $table->foreign('organisme_non_sportif_id')
                  ->references('id_org')
                  ->on('organismes_non_sportifs')
                  ->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('demandes_manifestation');
    }
};
