<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('jeune_creatif', function (Blueprint $table) {
            $table->id('id_jeune'); // clé primaire auto-incrémentée
            $table->string('presentez_vous', 200)->nullable();
            $table->string('nom_prenom', 100);
            $table->string('email', 200)->unique();
            $table->string('adresse', 150)->nullable();
            $table->string('niveau_education', 100)->nullable();
            $table->string('formation', 100)->nullable();
            $table->string('experiences', 255)->nullable();
            $table->string('presentation_detaillee', 255)->nullable();

            // relations
            $table->unsignedBigInteger('gouvernorat_id');
            $table->foreign('gouvernorat_id')
                  ->references('id_gouver')
                  ->on('tp_gouvernorat')
                  ->onDelete('cascade');

            $table->unsignedBigInteger('domaine_id');
            $table->foreign('domaine_id')
                  ->references('id_domaine')
                  ->on('tp_domaine_education')
                  ->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('jeune_creatif');
    }
};
