<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('evenement_sportif', function (Blueprint $table) {
            $table->id('id_even');
            $table->string('nom_even', 100);
            $table->string('objectifs', 200)->nullable();
            $table->string('contenus', 200)->nullable();
            $table->date('date')->nullable();
            $table->time('heure')->nullable();
            $table->string('instalation_sportives', 200)->nullable();
            $table->string('reference', 100)->nullable();
            $table->decimal('estimation_evenement', 12, 3)->nullable();
            $table->decimal('cout_total_evenement', 12, 3)->nullable();
            $table->decimal('difference_estimee', 12, 3)->nullable();
            $table->string('recompense', 200)->nullable();
            $table->string('moyen_transport', 200)->nullable();

            // Clés étrangères
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('id_type');
            $table->unsignedBigInteger('gouvernorat_id');
            $table->unsignedBigInteger('delegation_id');

            $table->foreign('user_id')->references('id')->on('utilisateur')->onDelete('cascade');
            $table->foreign('id_type')->references('id_statut')->on('tp_statut')->onDelete('cascade');
            $table->foreign('gouvernorat_id')->references('id_gouver')->on('tp_gouvernorat')->onDelete('cascade');
            $table->foreign('delegation_id')->references('id_delegation')->on('tp_delegation')->onDelete('cascade');

            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('evenement_sportif');
    }
};
