<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('guides', function (Blueprint $table) {
            $table->id('id_G');
            $table->string('titre_G', 100);
            $table->integer('ordre');
            $table->unsignedBigInteger('id_parent')->nullable();
            $table->unsignedBigInteger('id_type');
            $table->timestamps();

            $table->foreign('id_parent')
                  ->references('id_G')
                  ->on('guides')
                  ->onDelete('set null');

            $table->foreign('id_type')
                  ->references('id_type')
                  ->on('tp_type')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('guides');
    }
};
