<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
   
    public function up(): void
    {
        Schema::create('chambre_tente', function (Blueprint $table) {
           $table->id('id_chambre_tente');
            $table->integer('nbr_chambre_tente');
            $table->integer('capacite');
            $table->unsignedBigInteger('auberge_id');
            $table->unsignedBigInteger('type_chambre_id');
            $table->string('type', 50); // "chambre" ou "tente"

            $table->foreign('auberge_id')
                  ->references('id')
                  ->on('auberge')
                  ->onDelete('cascade');

            $table->foreign('type_chambre_id')
                  ->references('id_type')
                  ->on('tp_type_chambre')
                  ->onDelete('cascade');

            $table->timestamps();
        });
    }

   
    public function down(): void
    {
        Schema::dropIfExists('chambre_tente');
    }
};
