<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('equipement', function (Blueprint $table) {
            $table->id('id_equipement');
            $table->string('nom', 100);
            $table->string('descr', 255)->nullable();
            $table->unsignedBigInteger('auberge_id');

            $table->foreign('auberge_id')
                  ->references('id')
                  ->on('auberge')
                  ->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('equipement');
    }
};
