<?php
namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;

class ReservationRejectedNotification extends Notification
{
    use Queueable;

    public $reservation;
    public $motif;
    public $params;

    public function __construct($reservation, $motif, array $params = [])
    {
        $this->reservation = $reservation;
        $this->motif = $motif;
        $this->params = $params;
    }

    public function via($notifiable)
    {
        return ['database'];
    }

    public function toDatabase($notifiable)
    {
        return [
            'translation_key'    => 'site.notifications.reservation.rejected',
            'translation_params' => $this->params,
            'reservation_id'     => $this->reservation->id,
            'date'               => now()->toDateTimeString(),
        ];
    }

    public function toArray($notifiable)
    {
        return $this->toDatabase($notifiable);
    }
}
