<?php
namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;

class ReservationAcceptedNotification extends Notification
{
    use Queueable;

    public $reservation;
    public $params;

    public function __construct($reservation, array $params = [])
    {
        $this->reservation = $reservation;
        $this->params = $params;
    }

    public function via($notifiable)
    {
        return ['database'];
    }

    // prefer toDatabase for database channel
    public function toDatabase($notifiable)
    {
        // explicit translation key under your site notifications -> reservation.accepted
        return [
            'translation_key'    => 'site.notifications.reservation.accepted',
            'translation_params' => $this->params,
            'reservation_id'     => $this->reservation->id,
            'date'               => now()->toDateTimeString(),
        ];
    }

    // fallback for other uses
    public function toArray($notifiable)
    {
        return $this->toDatabase($notifiable);
    }
}
