<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;

class DocumentStatusNotification extends Notification
{
    use Queueable;

    public $type;
    public $translationParams;
    public $numeroDossier;

    /**
     * @param string $type normalized type: accepted|rejected|incomplete|deferred|status_changed
     * @param array $translationParams associative params for the translation (e.g. ['reason' => '...'])
     * @param string|null $numeroDossier
     */
    public function __construct(string $type, array $translationParams = [], $numeroDossier = null)
    {
        $this->type = $type;
        $this->translationParams = $translationParams;
        $this->numeroDossier = $numeroDossier;
    }

    public function via($notifiable)
    {
        return ['database'];
    }

    public function toDatabase($notifiable)
    {
        $translationKey = "site.notifications.documents_formulaire.{$this->type}";

        return [
            'type' => $this->type,
            'translation_key' => $translationKey,
            'translation_params' => $this->translationParams,
            'num_dossier' => $this->numeroDossier,
            'date' => now()->toDateTimeString(),
        ];
    }

    public function toArray($notifiable)
    {
        return $this->toDatabase($notifiable);
    }
}
