<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class DemandeStatusChanged extends Notification
{
    use Queueable;

    protected $demande;
    protected $type;   // 'accepte' ou 'refuse'
    protected $motif;  // null ou string

    public function __construct($demande, $type = null, $motif = null)
    {
        $this->demande = $demande;
        $this->type = $type;
        $this->motif = $motif;
    }

    public function via($notifiable)
    {
        // envoie mail + enregistrement en base
        return ['mail', 'database'];
    }

    public function toMail($notifiable)
    {
        // Prépare les variables pour le template markdown
        $numDossier = $this->demande->num_dossier ?? '-';
        $date = now()->format('Y-m-d H:i');

        $subject = 'تحديث حالة طلبك';
        $type = $this->type === 'accepte' ? 'accepte' : ($this->type === 'refuse' ? 'refuse' : 'update');

        return (new MailMessage)
            ->subject($subject)
            ->markdown('emails.demande.statut', [
                'type' => $type,
                'user' => $notifiable,
                'motif' => $this->motif ?? $this->demande->commentaire_motif ?? null,
                'num_dossier' => $numDossier,
                'date' => $date,
            ]);
    }

    public function toArray($notifiable)
    {
        return [
            'demande_id' => $this->demande->id_demande,
            'status' => $this->type,
            'motif' => $this->motif ?? $this->demande->commentaire_motif ?? null,
            'num_dossier' => $this->demande->num_dossier ?? null,
            'date' => now()->toDateTimeString(),
            'message' => $this->type === 'accepte'
                ? 'تم قبول الطلب'
                : ($this->type === 'refuse'
                    ? 'تم رفض الطلب'
                    : 'تم تحديث حالة الطلب'),
        ];
    }
}
