<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Support\Carbon;

class DebutActiviteStatutNotification extends Notification
{
    use Queueable;

    protected string $type; // normalized: accepted|rejected|incomplete|deferred|status_changed
    protected array $translationParams;

    public function __construct(string $type, array $translationParams = [])
    {
        $this->type = $type;
        $this->translationParams = $translationParams;
    }

    public function via($notifiable)
    {
        // database only (mail is sent separately in controller)
        return ['database'];
    }

    public function toDatabase($notifiable)
    {
        $normType = $this->type;
        // translation key used by your blade: __('site.notifications.debut_activite.'.$normType, $params)
        $translationKey = "site.notifications.debut_activite.{$normType}";

        return [
            'type' => $normType,
            'translation_key' => $translationKey,
            'translation_params' => $this->translationParams,
            'date' => Carbon::now()->toDateTimeString(),
            // optional reference to let UI show dossier id or number
            'reference' => $this->translationParams['reference'] ?? null,
        ];
    }

    // for array fallback
    public function toArray($notifiable)
    {
        return $this->toDatabase($notifiable);
    }
}
