<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Permission extends Model
{
    protected $table = 'permissions';
    protected $primaryKey = 'id_perm';
    public $incrementing = true;
    protected $keyType = 'int';

    protected $fillable = ['nom_ar','nom_fr','nom_en','guard_name'];

    public function roles()
    {
        return $this->belongsToMany(Role::class, 'roles_permissions', 'perm_id', 'roles_id');
    }
}
