<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OfficielGest extends Model
{
    use HasFactory;

    protected $table = 'officiel_gests';

    protected $primaryKey = 'id_officiel';

    public $incrementing = true;

    protected $keyType = 'int';

    protected $fillable = [
        'nom',
        'fonction',
        'demande_id',
    ];

    public $timestamps = true;

    public function demande()
    {
        return $this->belongsTo(DemandesManifestation::class, 'demande_id', 'id_demande');
    }
}
