<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
//use Illuminate\Support\Facades\Storage;

class News extends Model
{
    protected $fillable = [
        'title','title_fr','title_en', 'date','slug', 'content','content_fr',
        'content_en', 'image', 'youtube_url', 'published','id_user','resume_ar',
    'resume_fr',
    'resume_en',
    ];

    protected static function booted()
    {
        static::creating(function ($news) {
            if (empty($news->slug)) {
                $news->slug = Str::slug($news->title) . '-' . Str::random(6);
            }
        });
    }

    public function utilisateur()
    {
        return $this->belongsTo(Utilisateur::class, 'id_user', 'id');
    }

    protected $appends = ['image_url'];

    public function getImageUrlAttribute()
    {
        if (!$this->image) return null;
        return asset('storage/' . $this->image);
    }

    /*public function getImageUrlAttribute()
    {
        if (!$this->image) return null;
       
        return url(Storage::disk('public')->url($this->image));
    }*/
}
