<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ReservationPerson extends Model
{
    protected $table = 'reservation_persons';

    protected $primaryKey = 'id';

    public $incrementing = true;

    // Type de clé primaire
    protected $keyType = 'int';

    // Activer les timestamps (created_at / updated_at)
    public $timestamps = true;

    // Champs autorisés pour le mass assignment
    protected $fillable = [
        'reservation_id',
        'id_type_tarif',
        'nbr_hommes',
        'nbr_femmes',
        'nbr_total',
		'tarif',          
        'subtotal',       
        'accomodation_type'
    ];

    /**
     * Relation avec la réservation
     */
    public function reservation()
    {
        return $this->belongsTo(Reservation::class, 'reservation_id', 'id_reserv');
    }

    /**
     * Relation avec le type de tarif
     */
    public function typeTarif()
    {
        return $this->belongsTo(TpTypeTarif::class, 'id_type_tarif', 'id_type');
    }
}
